/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.health.connect.datatypes;


/** Capture user's VO2 max score and optionally the measurement method. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class Vo2MaxRecord extends android.health.connect.datatypes.InstantRecord {

Vo2MaxRecord() { throw new RuntimeException("Stub!"); }

/**
 * @return measurementMethod

 * Value is {@link android.health.connect.datatypes.Vo2MaxRecord.Vo2MaxMeasurementMethod#MEASUREMENT_METHOD_OTHER}, {@link android.health.connect.datatypes.Vo2MaxRecord.Vo2MaxMeasurementMethod#MEASUREMENT_METHOD_METABOLIC_CART}, {@link android.health.connect.datatypes.Vo2MaxRecord.Vo2MaxMeasurementMethod#MEASUREMENT_METHOD_HEART_RATE_RATIO}, {@link android.health.connect.datatypes.Vo2MaxRecord.Vo2MaxMeasurementMethod#MEASUREMENT_METHOD_COOPER_TEST}, {@link android.health.connect.datatypes.Vo2MaxRecord.Vo2MaxMeasurementMethod#MEASUREMENT_METHOD_MULTISTAGE_FITNESS_TEST}, or {@link android.health.connect.datatypes.Vo2MaxRecord.Vo2MaxMeasurementMethod#MEASUREMENT_METHOD_ROCKPORT_FITNESS_TEST}
 */

public int getMeasurementMethod() { throw new RuntimeException("Stub!"); }

/**
 * @return vo2MillilitersPerMinuteKilogram
 */

public double getVo2MillilitersPerMinuteKilogram() { throw new RuntimeException("Stub!"); }

/**
 * Indicates whether some other object is "equal to" this one.
 *
 * @param o the reference object with which to compare.
 * @return {@code true} if this object is the same as the obj
 */

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

/** Returns a hash code value for the object. */

public int hashCode() { throw new RuntimeException("Stub!"); }
/** Builder class for {@link android.health.connect.datatypes.Vo2MaxRecord Vo2MaxRecord} */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/**
 * @param metadata Metadata to be associated with the record. See {@link android.health.connect.datatypes.Metadata Metadata}.
 * This value cannot be {@code null}.
 * @param time Start time of this activity
 * This value cannot be {@code null}.
 * @param measurementMethod VO2 max measurement method. Optional field. Allowed values:
 *     {@link android.health.connect.datatypes.Vo2MaxRecord.Vo2MaxMeasurementMethod Vo2MaxMeasurementMethod}.
 * Value is {@link android.health.connect.datatypes.Vo2MaxRecord.Vo2MaxMeasurementMethod#MEASUREMENT_METHOD_OTHER}, {@link android.health.connect.datatypes.Vo2MaxRecord.Vo2MaxMeasurementMethod#MEASUREMENT_METHOD_METABOLIC_CART}, {@link android.health.connect.datatypes.Vo2MaxRecord.Vo2MaxMeasurementMethod#MEASUREMENT_METHOD_HEART_RATE_RATIO}, {@link android.health.connect.datatypes.Vo2MaxRecord.Vo2MaxMeasurementMethod#MEASUREMENT_METHOD_COOPER_TEST}, {@link android.health.connect.datatypes.Vo2MaxRecord.Vo2MaxMeasurementMethod#MEASUREMENT_METHOD_MULTISTAGE_FITNESS_TEST}, or {@link android.health.connect.datatypes.Vo2MaxRecord.Vo2MaxMeasurementMethod#MEASUREMENT_METHOD_ROCKPORT_FITNESS_TEST}
 * @param vo2MillilitersPerMinuteKilogram Maximal aerobic capacity (VO2 max) in milliliters.
 *     Required field. Valid range: 0-100.

 * Value is between 0 and 100 inclusive
 */

public Builder(@android.annotation.NonNull android.health.connect.datatypes.Metadata metadata, @android.annotation.NonNull java.time.Instant time, int measurementMethod, double vo2MillilitersPerMinuteKilogram) { throw new RuntimeException("Stub!"); }

/**
 * Sets the zone offset of the user when the activity happened
 * @param zoneOffset This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.Vo2MaxRecord.Builder setZoneOffset(@android.annotation.NonNull java.time.ZoneOffset zoneOffset) { throw new RuntimeException("Stub!"); }

/**
 * Sets the zone offset of this record to system default.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.Vo2MaxRecord.Builder clearZoneOffset() { throw new RuntimeException("Stub!"); }

/**
 * @return Object of {@link android.health.connect.datatypes.Vo2MaxRecord Vo2MaxRecord}

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.Vo2MaxRecord build() { throw new RuntimeException("Stub!"); }
}

/** Identifier for V02 max measurement method */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Vo2MaxMeasurementMethod {

Vo2MaxMeasurementMethod() { throw new RuntimeException("Stub!"); }

public static final int MEASUREMENT_METHOD_COOPER_TEST = 3; // 0x3

public static final int MEASUREMENT_METHOD_HEART_RATE_RATIO = 2; // 0x2

public static final int MEASUREMENT_METHOD_METABOLIC_CART = 1; // 0x1

public static final int MEASUREMENT_METHOD_MULTISTAGE_FITNESS_TEST = 4; // 0x4

public static final int MEASUREMENT_METHOD_OTHER = 0; // 0x0

public static final int MEASUREMENT_METHOD_ROCKPORT_FITNESS_TEST = 5; // 0x5
}

}

