/*
 * Copyright (C) 2019 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.location;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class GnssCapabilities implements android.os.Parcelable {

GnssCapabilities() { throw new RuntimeException("Stub!"); }

public boolean hasScheduling() { throw new RuntimeException("Stub!"); }

public boolean hasMsb() { throw new RuntimeException("Stub!"); }

public boolean hasMsa() { throw new RuntimeException("Stub!"); }

public boolean hasSingleShotFix() { throw new RuntimeException("Stub!"); }

public boolean hasOnDemandTime() { throw new RuntimeException("Stub!"); }

public boolean hasGeofencing() { throw new RuntimeException("Stub!"); }

public boolean hasMeasurements() { throw new RuntimeException("Stub!"); }

public boolean hasNavigationMessages() { throw new RuntimeException("Stub!"); }

public boolean hasLowPowerMode() { throw new RuntimeException("Stub!"); }

public boolean hasSatelliteBlocklist() { throw new RuntimeException("Stub!"); }

public boolean hasSatellitePvt() { throw new RuntimeException("Stub!"); }

public boolean hasMeasurementCorrections() { throw new RuntimeException("Stub!"); }

@Deprecated
public boolean hasGnssAntennaInfo() { throw new RuntimeException("Stub!"); }

public boolean hasAntennaInfo() { throw new RuntimeException("Stub!"); }

public boolean hasMeasurementCorrelationVectors() { throw new RuntimeException("Stub!"); }

public boolean hasMeasurementCorrectionsForDriving() { throw new RuntimeException("Stub!"); }

public int hasAccumulatedDeltaRange() { throw new RuntimeException("Stub!"); }

public boolean hasMeasurementCorrectionsLosSats() { throw new RuntimeException("Stub!"); }

public boolean hasMeasurementCorrectionsExcessPathLength() { throw new RuntimeException("Stub!"); }

public boolean hasMeasurementCorrectionsReflectingPlane() { throw new RuntimeException("Stub!"); }

public boolean hasPowerTotal() { throw new RuntimeException("Stub!"); }

public boolean hasPowerSinglebandTracking() { throw new RuntimeException("Stub!"); }

public boolean hasPowerMultibandTracking() { throw new RuntimeException("Stub!"); }

public boolean hasPowerSinglebandAcquisition() { throw new RuntimeException("Stub!"); }

public boolean hasPowerMultibandAcquisition() { throw new RuntimeException("Stub!"); }

public boolean hasPowerOtherModes() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.location.GnssSignalType> getGnssSignalTypes() { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public void writeToParcel(@android.annotation.NonNull android.os.Parcel parcel, int flags) { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

public static final int CAPABILITY_SUPPORTED = 1; // 0x1

public static final int CAPABILITY_UNKNOWN = 0; // 0x0

public static final int CAPABILITY_UNSUPPORTED = 2; // 0x2

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.location.GnssCapabilities> CREATOR;
static { CREATOR = null; }
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

public Builder(@android.annotation.NonNull android.location.GnssCapabilities capabilities) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.location.GnssCapabilities.Builder setHasScheduling(boolean capable) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.location.GnssCapabilities.Builder setHasMsb(boolean capable) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.location.GnssCapabilities.Builder setHasMsa(boolean capable) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.location.GnssCapabilities.Builder setHasSingleShotFix(boolean capable) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.location.GnssCapabilities.Builder setHasOnDemandTime(boolean capable) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.location.GnssCapabilities.Builder setHasGeofencing(boolean capable) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.location.GnssCapabilities.Builder setHasMeasurements(boolean capable) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.location.GnssCapabilities.Builder setHasNavigationMessages(boolean capable) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.location.GnssCapabilities.Builder setHasLowPowerMode(boolean capable) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.location.GnssCapabilities.Builder setHasSatelliteBlocklist(boolean capable) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.location.GnssCapabilities.Builder setHasSatellitePvt(boolean capable) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.location.GnssCapabilities.Builder setHasMeasurementCorrections(boolean capable) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.location.GnssCapabilities.Builder setHasAntennaInfo(boolean capable) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.location.GnssCapabilities.Builder setHasMeasurementCorrelationVectors(boolean capable) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.location.GnssCapabilities.Builder setHasMeasurementCorrectionsForDriving(boolean capable) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.location.GnssCapabilities.Builder setHasAccumulatedDeltaRange(int capable) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.location.GnssCapabilities.Builder setHasMeasurementCorrectionsLosSats(boolean capable) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.location.GnssCapabilities.Builder setHasMeasurementCorrectionsExcessPathLength(boolean capable) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.location.GnssCapabilities.Builder setHasMeasurementCorrectionsReflectingPlane(boolean capable) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.location.GnssCapabilities.Builder setHasPowerTotal(boolean capable) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.location.GnssCapabilities.Builder setHasPowerSinglebandTracking(boolean capable) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.location.GnssCapabilities.Builder setHasPowerMultibandTracking(boolean capable) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.location.GnssCapabilities.Builder setHasPowerSinglebandAcquisition(boolean capable) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.location.GnssCapabilities.Builder setHasPowerMultibandAcquisition(boolean capable) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.location.GnssCapabilities.Builder setHasPowerOtherModes(boolean capable) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.location.GnssCapabilities.Builder setGnssSignalTypes(@android.annotation.NonNull java.util.List<android.location.GnssSignalType> gnssSignalTypes) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.location.GnssCapabilities build() { throw new RuntimeException("Stub!"); }
}

}

