/*
 * Copyright (C) 2012 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.media;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class MediaCodec {

MediaCodec() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static android.media.MediaCodec createDecoderByType(@android.annotation.NonNull java.lang.String type) throws java.io.IOException { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static android.media.MediaCodec createEncoderByType(@android.annotation.NonNull java.lang.String type) throws java.io.IOException { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static android.media.MediaCodec createByCodecName(@android.annotation.NonNull java.lang.String name) throws java.io.IOException { throw new RuntimeException("Stub!"); }

protected void finalize() { throw new RuntimeException("Stub!"); }

public void reset() { throw new RuntimeException("Stub!"); }

public void release() { throw new RuntimeException("Stub!"); }

public void configure(@android.annotation.Nullable android.media.MediaFormat format, @android.annotation.Nullable android.view.Surface surface, @android.annotation.Nullable android.media.MediaCrypto crypto, int flags) { throw new RuntimeException("Stub!"); }

public void configure(@android.annotation.Nullable android.media.MediaFormat format, @android.annotation.Nullable android.view.Surface surface, int flags, @android.annotation.Nullable android.media.MediaDescrambler descrambler) { throw new RuntimeException("Stub!"); }

public void setOutputSurface(@android.annotation.NonNull android.view.Surface surface) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static android.view.Surface createPersistentInputSurface() { throw new RuntimeException("Stub!"); }

public void setInputSurface(@android.annotation.NonNull android.view.Surface surface) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public native android.view.Surface createInputSurface();

public void start() { throw new RuntimeException("Stub!"); }

public void stop() { throw new RuntimeException("Stub!"); }

public void flush() { throw new RuntimeException("Stub!"); }

public void queueInputBuffer(int index, int offset, int size, long presentationTimeUs, int flags) throws android.media.MediaCodec.CryptoException { throw new RuntimeException("Stub!"); }

public void queueSecureInputBuffer(int index, int offset, @android.annotation.NonNull android.media.MediaCodec.CryptoInfo info, long presentationTimeUs, int flags) throws android.media.MediaCodec.CryptoException { throw new RuntimeException("Stub!"); }

public int dequeueInputBuffer(long timeoutUs) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public static android.media.Image mapHardwareBuffer(@android.annotation.NonNull android.hardware.HardwareBuffer hardwareBuffer) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.MediaCodec.QueueRequest getQueueRequest(int index) { throw new RuntimeException("Stub!"); }

public int dequeueOutputBuffer(@android.annotation.NonNull android.media.MediaCodec.BufferInfo info, long timeoutUs) { throw new RuntimeException("Stub!"); }

public void releaseOutputBuffer(int index, boolean render) { throw new RuntimeException("Stub!"); }

public void releaseOutputBuffer(int index, long renderTimestampNs) { throw new RuntimeException("Stub!"); }

public native void signalEndOfInputStream();

@android.annotation.NonNull
public android.media.MediaFormat getOutputFormat() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.MediaFormat getInputFormat() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.MediaFormat getOutputFormat(int index) { throw new RuntimeException("Stub!"); }

@Deprecated
@android.annotation.NonNull
public java.nio.ByteBuffer[] getInputBuffers() { throw new RuntimeException("Stub!"); }

@Deprecated
@android.annotation.NonNull
public java.nio.ByteBuffer[] getOutputBuffers() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.nio.ByteBuffer getInputBuffer(int index) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.media.Image getInputImage(int index) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.nio.ByteBuffer getOutputBuffer(int index) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.media.Image getOutputImage(int index) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.MediaCodec.OutputFrame getOutputFrame(int index) { throw new RuntimeException("Stub!"); }

public native void setVideoScalingMode(int mode);

public void setAudioPresentation(@android.annotation.NonNull android.media.AudioPresentation presentation) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.lang.String getName() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public native java.lang.String getCanonicalName();

public android.os.PersistableBundle getMetrics() { throw new RuntimeException("Stub!"); }

public void setParameters(@android.annotation.Nullable android.os.Bundle params) { throw new RuntimeException("Stub!"); }

public void setCallback(@android.annotation.Nullable android.media.MediaCodec.Callback cb, @android.annotation.Nullable android.os.Handler handler) { throw new RuntimeException("Stub!"); }

public void setCallback(@android.annotation.Nullable android.media.MediaCodec.Callback cb) { throw new RuntimeException("Stub!"); }

public void setOnFirstTunnelFrameReadyListener(@android.annotation.Nullable android.os.Handler handler, @android.annotation.Nullable android.media.MediaCodec.OnFirstTunnelFrameReadyListener listener) { throw new RuntimeException("Stub!"); }

public void setOnFrameRenderedListener(@android.annotation.Nullable android.media.MediaCodec.OnFrameRenderedListener listener, @android.annotation.Nullable android.os.Handler handler) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<java.lang.String> getSupportedVendorParameters() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.media.MediaCodec.ParameterDescriptor getParameterDescriptor(@android.annotation.NonNull java.lang.String name) { throw new RuntimeException("Stub!"); }

public void subscribeToVendorParameters(@android.annotation.NonNull java.util.List<java.lang.String> names) { throw new RuntimeException("Stub!"); }

public void unsubscribeFromVendorParameters(@android.annotation.NonNull java.util.List<java.lang.String> names) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.MediaCodecInfo getCodecInfo() { throw new RuntimeException("Stub!"); }

public static final int BUFFER_FLAG_CODEC_CONFIG = 2; // 0x2

public static final int BUFFER_FLAG_DECODE_ONLY = 32; // 0x20

public static final int BUFFER_FLAG_END_OF_STREAM = 4; // 0x4

public static final int BUFFER_FLAG_KEY_FRAME = 1; // 0x1

public static final int BUFFER_FLAG_PARTIAL_FRAME = 8; // 0x8

@Deprecated public static final int BUFFER_FLAG_SYNC_FRAME = 1; // 0x1

public static final int CONFIGURE_FLAG_ENCODE = 1; // 0x1

public static final int CONFIGURE_FLAG_USE_BLOCK_MODEL = 2; // 0x2

public static final int CONFIGURE_FLAG_USE_CRYPTO_ASYNC = 4; // 0x4

public static final int CRYPTO_MODE_AES_CBC = 2; // 0x2

public static final int CRYPTO_MODE_AES_CTR = 1; // 0x1

public static final int CRYPTO_MODE_UNENCRYPTED = 0; // 0x0

@Deprecated public static final int INFO_OUTPUT_BUFFERS_CHANGED = -3; // 0xfffffffd

public static final int INFO_OUTPUT_FORMAT_CHANGED = -2; // 0xfffffffe

public static final int INFO_TRY_AGAIN_LATER = -1; // 0xffffffff

public static final java.lang.String PARAMETER_KEY_HDR10_PLUS_INFO = "hdr10-plus-info";

public static final java.lang.String PARAMETER_KEY_LOW_LATENCY = "low-latency";

public static final java.lang.String PARAMETER_KEY_OFFSET_TIME = "time-offset-us";

public static final java.lang.String PARAMETER_KEY_REQUEST_SYNC_FRAME = "request-sync";

public static final java.lang.String PARAMETER_KEY_SUSPEND = "drop-input-frames";

public static final java.lang.String PARAMETER_KEY_SUSPEND_TIME = "drop-start-time-us";

public static final java.lang.String PARAMETER_KEY_TUNNEL_PEEK = "tunnel-peek";

public static final java.lang.String PARAMETER_KEY_VIDEO_BITRATE = "video-bitrate";

public static final int VIDEO_SCALING_MODE_SCALE_TO_FIT = 1; // 0x1

public static final int VIDEO_SCALING_MODE_SCALE_TO_FIT_WITH_CROPPING = 2; // 0x2
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class BufferInfo {

public BufferInfo() { throw new RuntimeException("Stub!"); }

public void set(int newOffset, int newSize, long newTimeUs, int newFlags) { throw new RuntimeException("Stub!"); }

public int flags;

public int offset;

public long presentationTimeUs;

public int size;
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract static class Callback {

public Callback() { throw new RuntimeException("Stub!"); }

public abstract void onInputBufferAvailable(@android.annotation.NonNull android.media.MediaCodec codec, int index);

public abstract void onOutputBufferAvailable(@android.annotation.NonNull android.media.MediaCodec codec, int index, @android.annotation.NonNull android.media.MediaCodec.BufferInfo info);

public abstract void onError(@android.annotation.NonNull android.media.MediaCodec codec, @android.annotation.NonNull android.media.MediaCodec.CodecException e);

public void onCryptoError(@android.annotation.NonNull android.media.MediaCodec codec, @android.annotation.NonNull android.media.MediaCodec.CryptoException e) { throw new RuntimeException("Stub!"); }

public abstract void onOutputFormatChanged(@android.annotation.NonNull android.media.MediaCodec codec, @android.annotation.NonNull android.media.MediaFormat format);
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class CodecException extends java.lang.IllegalStateException {

CodecException() { throw new RuntimeException("Stub!"); }

public boolean isTransient() { throw new RuntimeException("Stub!"); }

public boolean isRecoverable() { throw new RuntimeException("Stub!"); }

public int getErrorCode() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.lang.String getDiagnosticInfo() { throw new RuntimeException("Stub!"); }

public static final int ERROR_INSUFFICIENT_RESOURCE = 1100; // 0x44c

public static final int ERROR_RECLAIMED = 1101; // 0x44d
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class CryptoException extends java.lang.RuntimeException implements android.media.MediaDrmThrowable {

public CryptoException(int errorCode, @android.annotation.Nullable java.lang.String detailMessage) { throw new RuntimeException("Stub!"); }

public int getErrorCode() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.media.MediaCodec.CryptoInfo getCryptoInfo() { throw new RuntimeException("Stub!"); }

public int getVendorError() { throw new RuntimeException("Stub!"); }

public int getOemError() { throw new RuntimeException("Stub!"); }

public int getErrorContext() { throw new RuntimeException("Stub!"); }

@Deprecated public static final int ERROR_FRAME_TOO_LARGE = 8; // 0x8

@Deprecated public static final int ERROR_INSUFFICIENT_OUTPUT_PROTECTION = 4; // 0x4

@Deprecated public static final int ERROR_INSUFFICIENT_SECURITY = 7; // 0x7

@Deprecated public static final int ERROR_KEY_EXPIRED = 2; // 0x2

@Deprecated public static final int ERROR_LOST_STATE = 9; // 0x9

@Deprecated public static final int ERROR_NO_KEY = 1; // 0x1

@Deprecated public static final int ERROR_RESOURCE_BUSY = 3; // 0x3

@Deprecated public static final int ERROR_SESSION_NOT_OPENED = 5; // 0x5

@Deprecated public static final int ERROR_UNSUPPORTED_OPERATION = 6; // 0x6
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class CryptoInfo {

public CryptoInfo() { throw new RuntimeException("Stub!"); }

public void set(int newNumSubSamples, @android.annotation.NonNull int[] newNumBytesOfClearData, @android.annotation.NonNull int[] newNumBytesOfEncryptedData, @android.annotation.NonNull byte[] newKey, @android.annotation.NonNull byte[] newIV, int newMode) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.MediaCodec.CryptoInfo.Pattern getPattern() { throw new RuntimeException("Stub!"); }

public void setPattern(android.media.MediaCodec.CryptoInfo.Pattern newPattern) { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

public byte[] iv;

public byte[] key;

public int mode;

public int[] numBytesOfClearData;

public int[] numBytesOfEncryptedData;

public int numSubSamples;
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Pattern {

public Pattern(int blocksToEncrypt, int blocksToSkip) { throw new RuntimeException("Stub!"); }

public void set(int blocksToEncrypt, int blocksToSkip) { throw new RuntimeException("Stub!"); }

public int getSkipBlocks() { throw new RuntimeException("Stub!"); }

public int getEncryptBlocks() { throw new RuntimeException("Stub!"); }
}

}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class IncompatibleWithBlockModelException extends java.lang.RuntimeException {

IncompatibleWithBlockModelException() { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class InvalidBufferFlagsException extends java.lang.RuntimeException {

InvalidBufferFlagsException() { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class LinearBlock {

LinearBlock() { throw new RuntimeException("Stub!"); }

public boolean isMappable() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.nio.ByteBuffer map() { throw new RuntimeException("Stub!"); }

public void recycle() { throw new RuntimeException("Stub!"); }

protected void finalize() { throw new RuntimeException("Stub!"); }

public static boolean isCodecCopyFreeCompatible(@android.annotation.NonNull java.lang.String[] codecNames) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public static android.media.MediaCodec.LinearBlock obtain(int capacity, @android.annotation.NonNull java.lang.String[] codecNames) { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class MetricsConstants {

MetricsConstants() { throw new RuntimeException("Stub!"); }

public static final java.lang.String CODEC = "android.media.mediacodec.codec";

public static final java.lang.String ENCODER = "android.media.mediacodec.encoder";

public static final java.lang.String HEIGHT = "android.media.mediacodec.height";

public static final java.lang.String MIME_TYPE = "android.media.mediacodec.mime";

public static final java.lang.String MODE = "android.media.mediacodec.mode";

public static final java.lang.String MODE_AUDIO = "audio";

public static final java.lang.String MODE_VIDEO = "video";

public static final java.lang.String ROTATION = "android.media.mediacodec.rotation";

public static final java.lang.String SECURE = "android.media.mediacodec.secure";

public static final java.lang.String WIDTH = "android.media.mediacodec.width";
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface OnFirstTunnelFrameReadyListener {

public void onFirstTunnelFrameReady(@android.annotation.NonNull android.media.MediaCodec codec);
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface OnFrameRenderedListener {

public void onFrameRendered(@android.annotation.NonNull android.media.MediaCodec codec, long presentationTimeUs, long nanoTime);
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class OutputFrame {

OutputFrame() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.media.MediaCodec.LinearBlock getLinearBlock() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.hardware.HardwareBuffer getHardwareBuffer() { throw new RuntimeException("Stub!"); }

public long getPresentationTimeUs() { throw new RuntimeException("Stub!"); }

public int getFlags() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.MediaFormat getFormat() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.Set<java.lang.String> getChangedKeys() { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class ParameterDescriptor {

ParameterDescriptor() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.lang.String getName() { throw new RuntimeException("Stub!"); }

public int getType() { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class QueueRequest {

QueueRequest() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.MediaCodec.QueueRequest setLinearBlock(@android.annotation.NonNull android.media.MediaCodec.LinearBlock block, int offset, int size) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.MediaCodec.QueueRequest setEncryptedLinearBlock(@android.annotation.NonNull android.media.MediaCodec.LinearBlock block, int offset, int size, @android.annotation.NonNull android.media.MediaCodec.CryptoInfo cryptoInfo) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.MediaCodec.QueueRequest setHardwareBuffer(@android.annotation.NonNull android.hardware.HardwareBuffer buffer) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.MediaCodec.QueueRequest setPresentationTimeUs(long presentationTimeUs) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.MediaCodec.QueueRequest setFlags(int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.MediaCodec.QueueRequest setIntegerParameter(@android.annotation.NonNull java.lang.String key, int value) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.MediaCodec.QueueRequest setLongParameter(@android.annotation.NonNull java.lang.String key, long value) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.MediaCodec.QueueRequest setFloatParameter(@android.annotation.NonNull java.lang.String key, float value) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.MediaCodec.QueueRequest setByteBufferParameter(@android.annotation.NonNull java.lang.String key, @android.annotation.NonNull java.nio.ByteBuffer value) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.MediaCodec.QueueRequest setStringParameter(@android.annotation.NonNull java.lang.String key, @android.annotation.NonNull java.lang.String value) { throw new RuntimeException("Stub!"); }

public void queue() { throw new RuntimeException("Stub!"); }
}

}

