/*
 * Copyright (C) 2020 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.media;


/**
 * MediaFeature defines various media features, e.g.&nbsp;hdr type.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class MediaFeature {

public MediaFeature() { throw new RuntimeException("Stub!"); }
/**
 * Defines tye type of HDR(high dynamic range) video.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class HdrType {

HdrType() { throw new RuntimeException("Stub!"); }

/**
 * HDR type for dolby-vision.
 */

public static final java.lang.String DOLBY_VISION = "android.media.feature.hdr.dolby_vision";

/**
 * HDR type for hdr10.
 */

public static final java.lang.String HDR10 = "android.media.feature.hdr.hdr10";

/**
 * HDR type for hdr10+.
 */

public static final java.lang.String HDR10_PLUS = "android.media.feature.hdr.hdr10_plus";

/**
 * HDR type for hlg.
 */

public static final java.lang.String HLG = "android.media.feature.hdr.hlg";
}

}

