/*
 * Copyright (C) 2020 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.media.metrics;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class PlaybackErrorEvent extends android.media.metrics.Event implements android.os.Parcelable {

PlaybackErrorEvent() { throw new RuntimeException("Stub!"); }

public int getErrorCode() { throw new RuntimeException("Stub!"); }

public int getSubErrorCode() { throw new RuntimeException("Stub!"); }

public long getTimeSinceCreatedMillis() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.os.Bundle getMetricsBundle() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

public boolean equals(@android.annotation.Nullable java.lang.Object o) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.media.metrics.PlaybackErrorEvent> CREATOR;
static { CREATOR = null; }

public static final int ERROR_AUDIO_TRACK_INIT_FAILED = 17; // 0x11

public static final int ERROR_AUDIO_TRACK_OTHER = 19; // 0x13

public static final int ERROR_AUDIO_TRACK_WRITE_FAILED = 18; // 0x12

public static final int ERROR_DECODER_INIT_FAILED = 13; // 0xd

public static final int ERROR_DECODING_FAILED = 14; // 0xe

public static final int ERROR_DECODING_FORMAT_EXCEEDS_CAPABILITIES = 15; // 0xf

public static final int ERROR_DECODING_FORMAT_UNSUPPORTED = 35; // 0x23

public static final int ERROR_DECODING_OTHER = 16; // 0x10

public static final int ERROR_DRM_CONTENT_ERROR = 28; // 0x1c

public static final int ERROR_DRM_DEVICE_REVOKED = 29; // 0x1d

public static final int ERROR_DRM_DISALLOWED_OPERATION = 26; // 0x1a

public static final int ERROR_DRM_LICENSE_ACQUISITION_FAILED = 25; // 0x19

public static final int ERROR_DRM_OTHER = 30; // 0x1e

public static final int ERROR_DRM_PROVISIONING_FAILED = 24; // 0x18

public static final int ERROR_DRM_SCHEME_UNSUPPORTED = 23; // 0x17

public static final int ERROR_DRM_SYSTEM_ERROR = 27; // 0x1b

public static final int ERROR_IO_BAD_HTTP_STATUS = 5; // 0x5

public static final int ERROR_IO_CONNECTION_CLOSED = 8; // 0x8

public static final int ERROR_IO_CONNECTION_TIMEOUT = 7; // 0x7

public static final int ERROR_IO_DNS_FAILED = 6; // 0x6

public static final int ERROR_IO_FILE_NOT_FOUND = 31; // 0x1f

public static final int ERROR_IO_NETWORK_CONNECTION_FAILED = 4; // 0x4

public static final int ERROR_IO_NETWORK_UNAVAILABLE = 3; // 0x3

public static final int ERROR_IO_NO_PERMISSION = 32; // 0x20

public static final int ERROR_IO_OTHER = 9; // 0x9

public static final int ERROR_OTHER = 1; // 0x1

public static final int ERROR_PARSING_CONTAINER_MALFORMED = 11; // 0xb

public static final int ERROR_PARSING_CONTAINER_UNSUPPORTED = 34; // 0x22

public static final int ERROR_PARSING_MANIFEST_MALFORMED = 10; // 0xa

public static final int ERROR_PARSING_MANIFEST_UNSUPPORTED = 33; // 0x21

public static final int ERROR_PARSING_OTHER = 12; // 0xc

public static final int ERROR_PLAYER_BEHIND_LIVE_WINDOW = 21; // 0x15

public static final int ERROR_PLAYER_OTHER = 22; // 0x16

public static final int ERROR_PLAYER_REMOTE = 20; // 0x14

public static final int ERROR_RUNTIME = 2; // 0x2

public static final int ERROR_UNKNOWN = 0; // 0x0
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.metrics.PlaybackErrorEvent.Builder setException(@android.annotation.NonNull java.lang.Exception value) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.metrics.PlaybackErrorEvent.Builder setErrorCode(int value) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.metrics.PlaybackErrorEvent.Builder setSubErrorCode(int value) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.metrics.PlaybackErrorEvent.Builder setTimeSinceCreatedMillis(long value) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.metrics.PlaybackErrorEvent.Builder setMetricsBundle(@android.annotation.NonNull android.os.Bundle metricsBundle) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.metrics.PlaybackErrorEvent build() { throw new RuntimeException("Stub!"); }
}

}

