/*
 * Copyright (C) 2018 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.net.ipsec.ike.exceptions;

import android.net.ipsec.ike.ChildSessionCallback;
import android.net.ipsec.ike.IkeSessionCallback;

/**
 * This exception is thrown when major version of an inbound message is higher than 2.
 *
 * @see <a href="https://tools.ietf.org/html/rfc7296#section-2.5">RFC 7296, Internet Key Exchange
 *     Protocol Version 2 (IKEv2)</a>
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class InvalidMajorVersionException extends android.net.ipsec.ike.exceptions.IkeProtocolException {

/**
 * Construct a instance of InvalidMajorVersionException
 *
 * <p>Except for testing, IKE library users normally do not instantiate this object themselves
 * but instead get a reference via {@link android.net.ipsec.ike.IkeSessionCallback IkeSessionCallback} or {@link android.net.ipsec.ike.ChildSessionCallback ChildSessionCallback}.
 *
 * @param version the major version in received packet
 */

public InvalidMajorVersionException(byte version) { throw new RuntimeException("Stub!"); }

/**
 * Return the major version included in this exception.
 *
 * @return the major version
 */

public byte getMajorVersion() { throw new RuntimeException("Stub!"); }
}

