/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.net.wifi;

import android.os.Parcelable;

/**
 * Data structure class representing a Wi-Fi Multi-Link Operation (MLO) link
 * This is only used by 802.11be capable devices
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class MloLink implements android.os.Parcelable {

/**
 * Constructor for a MloLInk.
 */

public MloLink() { throw new RuntimeException("Stub!"); }

/** Returns the Wi-Fi band of this link as one of:
 *      {@link android.net.wifi.WifiScanner#WIFI_BAND_UNSPECIFIED WifiScanner#WIFI_BAND_UNSPECIFIED},
 *      {@link android.net.wifi.WifiScanner#WIFI_BAND_24_GHZ WifiScanner#WIFI_BAND_24_GHZ},
 *      {@link android.net.wifi.WifiScanner#WIFI_BAND_5_GHZ WifiScanner#WIFI_BAND_5_GHZ},
 *      {@link android.net.wifi.WifiScanner#WIFI_BAND_6_GHZ WifiScanner#WIFI_BAND_6_GHZ}

 * @return Value is android.net.wifi.WifiScanner.WIFI_BAND_UNSPECIFIED, android.net.wifi.WifiScanner.WIFI_BAND_24_GHZ, android.net.wifi.WifiScanner.WIFI_BAND_5_GHZ, android.net.wifi.WifiScanner.WIFI_BAND_5_GHZ_DFS_ONLY, or android.net.wifi.WifiScanner.WIFI_BAND_6_GHZ
 */

public int getBand() { throw new RuntimeException("Stub!"); }

/**
 * Returns the channel number of this link.
 * A valid value is based on the 802.11 specification in sections 19.3.15 and 27.3.23

 * @return Value is 1 or greater
 */

public int getChannel() { throw new RuntimeException("Stub!"); }

/**
 * Returns the link id of this link.
 * Valid values are 0-15, as described in IEEE 802.11be Specification, section 9.4.2.295b.2.
 *
 * @return {@link #INVALID_MLO_LINK_ID} or a valid value (0-15).

 * Value is between INVALID_MLO_LINK_ID and MAX_MLO_LINK_ID inclusive
 */

public int getLinkId() { throw new RuntimeException("Stub!"); }

/** Returns the state of this link as one of:
 *     {@link #MLO_LINK_STATE_INVALID}
 *     {@link #MLO_LINK_STATE_UNASSOCIATED}
 *     {@link #MLO_LINK_STATE_IDLE}
 *     {@link #MLO_LINK_STATE_ACTIVE}

 * @return Value is {@link android.net.wifi.MloLink#MLO_LINK_STATE_INVALID}, {@link android.net.wifi.MloLink#MLO_LINK_STATE_UNASSOCIATED}, {@link android.net.wifi.MloLink#MLO_LINK_STATE_IDLE}, or {@link android.net.wifi.MloLink#MLO_LINK_STATE_ACTIVE}
 */

public int getState() { throw new RuntimeException("Stub!"); }

/**
 * Returns the AP MAC address of this link.
 *
 * @return AP MAC address for this link or null when the caller has insufficient
 * permissions to access the access point MAC Address.
 */

@android.annotation.Nullable
public android.net.MacAddress getApMacAddress() { throw new RuntimeException("Stub!"); }

/**
 * Returns the STA MAC address of this link.
 *
 * @return STA MAC address assigned for this link, or null in the following cases:
 * <ul>
 *     <li> The caller has insufficient permissions to access the STA MAC Address </li>
 *     <li> Link is not associated, hence no MAC address is assigned to it by STA </li>
 * </ul>
 */

@android.annotation.Nullable
public android.net.MacAddress getStaMacAddress() { throw new RuntimeException("Stub!"); }

/**
 * Returns the current receive link speed in Mbps.
 * @return the Rx link speed or {@link android.net.wifi.WifiInfo#LINK_SPEED_UNKNOWN WifiInfo#LINK_SPEED_UNKNOWN} if link speed is unknown.
 * Value is -1 or greater
 * @see android.net.wifi.WifiInfo#LINK_SPEED_UNKNOWN
 */

public int getRxLinkSpeedMbps() { throw new RuntimeException("Stub!"); }

/**
 * Returns the current transmit link speed in Mbps.
 * @return the Tx link speed or {@link android.net.wifi.WifiInfo#LINK_SPEED_UNKNOWN WifiInfo#LINK_SPEED_UNKNOWN} if link speed is unknown.
 * Value is -1 or greater
 * @see android.net.wifi.WifiInfo#LINK_SPEED_UNKNOWN
 */

public int getTxLinkSpeedMbps() { throw new RuntimeException("Stub!"); }

/**
 * Returns the RSSI of the link.
 *
 * <p>Use {@link android.net.wifi.WifiManager#calculateSignalLevel} to convert this number into
 * an absolute signal level which can be displayed to a user.
 *
 * @return RSSI in dBM.
 */

public int getRssi() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param o This value may be {@code null}.
 */

public boolean equals(@android.annotation.Nullable java.lang.Object o) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/** Implement the Parcelable interface */

public int describeContents() { throw new RuntimeException("Stub!"); }

/**
 * Implement the Parcelable interface
 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

/** Implement the Parcelable interface */

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.net.wifi.MloLink> CREATOR;
static { CREATOR = null; }

/**
 * Invalid link id. Used in {link #getLinkId()}
 */

public static final int INVALID_MLO_LINK_ID = -1; // 0xffffffff

/**
 * MLO link state: Link is associated to the access point and mapped to at least one traffic
 * stream. {link #getState()}
 * Note that an MLO link could be in that state but in power save mode.
 */

public static final int MLO_LINK_STATE_ACTIVE = 3; // 0x3

/**
 * MLO link state: Link is associated to the access point but not mapped to any traffic stream.
 * Used in {link #getState()}
 */

public static final int MLO_LINK_STATE_IDLE = 2; // 0x2

/**
 * MLO link state: Invalid link state. Used in {link #getState()}
 */

public static final int MLO_LINK_STATE_INVALID = 0; // 0x0

/**
 * MLO link state: Link is not associated with the access point. Used in {link #getState()}
 */

public static final int MLO_LINK_STATE_UNASSOCIATED = 1; // 0x1
}

