/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.net.wifi.aware;


/**
 * The config for the Aware Pairing. Set to
 * {@link android.net.wifi.aware.PublishConfig.Builder#setPairingConfig(android.net.wifi.aware.AwarePairingConfig) PublishConfig.Builder#setPairingConfig(AwarePairingConfig)} and
 * {@link android.net.wifi.aware.SubscribeConfig.Builder#setPairingConfig(android.net.wifi.aware.AwarePairingConfig) SubscribeConfig.Builder#setPairingConfig(AwarePairingConfig)}.
 * Only valid when {@link android.net.wifi.aware.Characteristics#isAwarePairingSupported() Characteristics#isAwarePairingSupported()} is true.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class AwarePairingConfig implements android.os.Parcelable {

AwarePairingConfig() { throw new RuntimeException("Stub!"); }

/**
 * Check if the NPK/NIK cache is support in the config
 */

public boolean isPairingCacheEnabled() { throw new RuntimeException("Stub!"); }

/**
 * Check if the Aware Pairing setup is support in the config.
 * Setup is the first time for two device establish Aware Pairing
 */

public boolean isPairingSetupEnabled() { throw new RuntimeException("Stub!"); }

/**
 * Check if the Aware Pairing verification is support in the config.
 * Verification is for two device already paired and re-establish with cached NPK/NIK
 */

public boolean isPairingVerificationEnabled() { throw new RuntimeException("Stub!"); }

/**
 * Get the supported bootstrapping methods in this config. Set of the
 * STATUS_NETWORK_SUGGESTIONS_ values.

 * @return Value is either <code>0</code> or a combination of {@link android.net.wifi.aware.AwarePairingConfig#PAIRING_BOOTSTRAPPING_OPPORTUNISTIC}, {@link android.net.wifi.aware.AwarePairingConfig#PAIRING_BOOTSTRAPPING_PIN_CODE_DISPLAY}, {@link android.net.wifi.aware.AwarePairingConfig#PAIRING_BOOTSTRAPPING_PASSPHRASE_DISPLAY}, {@link android.net.wifi.aware.AwarePairingConfig#PAIRING_BOOTSTRAPPING_QR_DISPLAY}, {@link android.net.wifi.aware.AwarePairingConfig#PAIRING_BOOTSTRAPPING_NFC_TAG}, {@link android.net.wifi.aware.AwarePairingConfig#PAIRING_BOOTSTRAPPING_PIN_CODE_KEYPAD}, {@link android.net.wifi.aware.AwarePairingConfig#PAIRING_BOOTSTRAPPING_PASSPHRASE_KEYPAD}, {@link android.net.wifi.aware.AwarePairingConfig#PAIRING_BOOTSTRAPPING_QR_SCAN}, and {@link android.net.wifi.aware.AwarePairingConfig#PAIRING_BOOTSTRAPPING_NFC_READER}
 */

public int getBootstrappingMethods() { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.net.wifi.aware.AwarePairingConfig> CREATOR;
static { CREATOR = null; }

/**
 * Aware Pairing bootstrapping method NFC reader
 */

public static final int PAIRING_BOOTSTRAPPING_NFC_READER = 256; // 0x100

/**
 * Aware Pairing bootstrapping method NFC tag
 */

public static final int PAIRING_BOOTSTRAPPING_NFC_TAG = 16; // 0x10

/**
 * Aware Pairing bootstrapping method opportunistic
 */

public static final int PAIRING_BOOTSTRAPPING_OPPORTUNISTIC = 1; // 0x1

/**
 * Aware Pairing bootstrapping method passphrase display
 */

public static final int PAIRING_BOOTSTRAPPING_PASSPHRASE_DISPLAY = 4; // 0x4

/**
 * Aware Pairing bootstrapping method passphrase keypad
 */

public static final int PAIRING_BOOTSTRAPPING_PASSPHRASE_KEYPAD = 64; // 0x40

/**
 * Aware Pairing bootstrapping method pin-code display
 */

public static final int PAIRING_BOOTSTRAPPING_PIN_CODE_DISPLAY = 2; // 0x2

/**
 * Aware Pairing bootstrapping method pin-code keypad
 */

public static final int PAIRING_BOOTSTRAPPING_PIN_CODE_KEYPAD = 32; // 0x20

/**
 * Aware Pairing bootstrapping method QR-code display
 */

public static final int PAIRING_BOOTSTRAPPING_QR_DISPLAY = 8; // 0x8

/**
 * Aware Pairing bootstrapping method QR-code scan
 */

public static final int PAIRING_BOOTSTRAPPING_QR_SCAN = 128; // 0x80
/**
 * Builder used to build {@link android.net.wifi.aware.AwarePairingConfig AwarePairingConfig} objects.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * Set whether enable the Aware Pairing setup
 * @param enabled true to enable, false otherwise
 * @return the current {@link android.net.wifi.aware.AwarePairingConfig.Builder Builder} builder, enabling chaining of builder methods.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.wifi.aware.AwarePairingConfig.Builder setPairingSetupEnabled(boolean enabled) { throw new RuntimeException("Stub!"); }

/**
 * Set whether enable the Aware Pairing verification
 * @param enabled if set to true will accept Aware Pairing verification request from peer
 *                with cached NPK/NIK, otherwise will reject the request .
 * @return the current {@link android.net.wifi.aware.AwarePairingConfig.Builder Builder} builder, enabling chaining of builder methods.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.wifi.aware.AwarePairingConfig.Builder setPairingVerificationEnabled(boolean enabled) { throw new RuntimeException("Stub!"); }

/**
 * Set whether enable cache of the NPK/NIK of Aware Pairing setup
 * @param enabled true to enable caching, false otherwise
 * @return the current {@link android.net.wifi.aware.AwarePairingConfig.Builder Builder} builder, enabling chaining of builder methods.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.wifi.aware.AwarePairingConfig.Builder setPairingCacheEnabled(boolean enabled) { throw new RuntimeException("Stub!"); }

/**
 * Set the supported bootstrapping methods
 * @param methods methods supported, set of PAIRING_BOOTSTRAPPING_ values
 * Value is either <code>0</code> or a combination of {@link android.net.wifi.aware.AwarePairingConfig#PAIRING_BOOTSTRAPPING_OPPORTUNISTIC}, {@link android.net.wifi.aware.AwarePairingConfig#PAIRING_BOOTSTRAPPING_PIN_CODE_DISPLAY}, {@link android.net.wifi.aware.AwarePairingConfig#PAIRING_BOOTSTRAPPING_PASSPHRASE_DISPLAY}, {@link android.net.wifi.aware.AwarePairingConfig#PAIRING_BOOTSTRAPPING_QR_DISPLAY}, {@link android.net.wifi.aware.AwarePairingConfig#PAIRING_BOOTSTRAPPING_NFC_TAG}, {@link android.net.wifi.aware.AwarePairingConfig#PAIRING_BOOTSTRAPPING_PIN_CODE_KEYPAD}, {@link android.net.wifi.aware.AwarePairingConfig#PAIRING_BOOTSTRAPPING_PASSPHRASE_KEYPAD}, {@link android.net.wifi.aware.AwarePairingConfig#PAIRING_BOOTSTRAPPING_QR_SCAN}, and {@link android.net.wifi.aware.AwarePairingConfig#PAIRING_BOOTSTRAPPING_NFC_READER}
 * @return the current {@link android.net.wifi.aware.AwarePairingConfig.Builder Builder} builder, enabling chaining of builder methods.
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.wifi.aware.AwarePairingConfig.Builder setBootstrappingMethods(int methods) { throw new RuntimeException("Stub!"); }

/**
 * Build {@link android.net.wifi.aware.AwarePairingConfig AwarePairingConfig} given the current requests made on the
 * builder.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.wifi.aware.AwarePairingConfig build() { throw new RuntimeException("Stub!"); }
}

}

