/*
 * Copyright (C) 2006 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.widget;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public interface Adapter {

public void registerDataSetObserver(android.database.DataSetObserver observer);

public void unregisterDataSetObserver(android.database.DataSetObserver observer);

public int getCount();

public java.lang.Object getItem(int position);

public long getItemId(int position);

public boolean hasStableIds();

public android.view.View getView(int position, android.view.View convertView, android.view.ViewGroup parent);

public int getItemViewType(int position);

public int getViewTypeCount();

public boolean isEmpty();

@android.annotation.Nullable
public default java.lang.CharSequence[] getAutofillOptions() { throw new RuntimeException("Stub!"); }

public static final int IGNORE_ITEM_VIEW_TYPE = -1; // 0xffffffff

public static final int NO_SELECTION = -2147483648; // 0x80000000
}

