/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.adservices.adselection;


/**
 * This POJO represents the {@link android.adservices.adselection.TestAdSelectionManager#overrideAdSelectionFromOutcomesConfigRemoteInfo  } (
 * AddAdSelectionOverrideRequest, Executor, OutcomeReceiver)} request
 *
 * <p>It contains, a {@link android.adservices.adselection.AdSelectionFromOutcomesConfig AdSelectionFromOutcomesConfig} which will serve as the identifier for
 * the specific override, a {@code String} selectionLogicJs and {@code String} selectionSignals
 * field representing the override value
 *
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class AddAdSelectionFromOutcomesOverrideRequest {

/**
 * Builds a {@link android.adservices.adselection.AddAdSelectionFromOutcomesOverrideRequest AddAdSelectionFromOutcomesOverrideRequest} instance.
 * @param adSelectionFromOutcomesConfig This value cannot be {@code null}.
 
 * @param outcomeSelectionLogicJs This value cannot be {@code null}.

 * @param outcomeSelectionTrustedSignals This value cannot be {@code null}.
 */

public AddAdSelectionFromOutcomesOverrideRequest(@android.annotation.NonNull android.adservices.adselection.AdSelectionFromOutcomesConfig adSelectionFromOutcomesConfig, @android.annotation.NonNull java.lang.String outcomeSelectionLogicJs, @android.annotation.NonNull android.adservices.common.AdSelectionSignals outcomeSelectionTrustedSignals) { throw new RuntimeException("Stub!"); }

/**
 * @return an instance of {@link android.adservices.adselection.AdSelectionFromOutcomesConfig AdSelectionFromOutcomesConfig}, the configuration of the ad
 *     selection process. This configuration provides the data necessary to run Ad Selection
 *     flow that generates bids and scores to find a wining ad for rendering.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.adselection.AdSelectionFromOutcomesConfig getAdSelectionFromOutcomesConfig() { throw new RuntimeException("Stub!"); }

/**
 * @return The override javascript result, should be a string that contains valid JS code. The
 *     code should contain the outcome selection logic that will be executed during ad outcome
 *     selection.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String getOutcomeSelectionLogicJs() { throw new RuntimeException("Stub!"); }

/**
 * @return The override trusted scoring signals, should be a valid json string. The trusted
 *     signals would be fed into the outcome selection logic during ad outcome selection.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.common.AdSelectionSignals getOutcomeSelectionTrustedSignals() { throw new RuntimeException("Stub!"); }
}

