/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.adservices.adselection;

import android.os.OutcomeReceiver;
import java.util.concurrent.Executor;

/**
 * This POJO represents the {@link android.adservices.adselection.TestAdSelectionManager#overrideAdSelectionConfigRemoteInfo(android.adservices.adselection.AddAdSelectionOverrideRequest,java.util.concurrent.Executor,android.os.OutcomeReceiver)  } request
 *
 * <p>It contains, a {@link android.adservices.adselection.AdSelectionConfig AdSelectionConfig} which will serve as the identifier for the specific
 * override, a {@code String} decisionLogicJs and {@code String} trustedScoringSignals field
 * representing the override value
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class AddAdSelectionOverrideRequest {

/**
 * Builds a {@link android.adservices.adselection.AddAdSelectionOverrideRequest AddAdSelectionOverrideRequest} instance.
 *
 * @param adSelectionConfig configuration for ad selection. See {@link android.adservices.adselection.AdSelectionConfig AdSelectionConfig}
 * This value cannot be {@code null}.
 * @param decisionLogicJs override for scoring logic. See {@link android.adservices.adselection.AdSelectionConfig#getDecisionLogicUri()      }
 * This value cannot be {@code null}.
 * @param trustedScoringSignals override for trusted seller signals. See {@link android.adservices.adselection.AdSelectionConfig#getTrustedScoringSignalsUri()      }
 * This value cannot be {@code null}.
 * @param perBuyerDecisionLogic override for buyer's reporting logic for contextual ads. See
 *     {@link android.adservices.adselection.SignedContextualAds#getDecisionLogicUri() SignedContextualAds#getDecisionLogicUri()}

 * This value cannot be {@code null}.
 */

public AddAdSelectionOverrideRequest(@android.annotation.NonNull android.adservices.adselection.AdSelectionConfig adSelectionConfig, @android.annotation.NonNull java.lang.String decisionLogicJs, @android.annotation.NonNull android.adservices.common.AdSelectionSignals trustedScoringSignals, @android.annotation.NonNull android.adservices.adselection.PerBuyerDecisionLogic perBuyerDecisionLogic) { throw new RuntimeException("Stub!"); }

/**
 * Builds a {@link android.adservices.adselection.AddAdSelectionOverrideRequest AddAdSelectionOverrideRequest} instance.
 *
 * @param adSelectionConfig configuration for ad selection. See {@link android.adservices.adselection.AdSelectionConfig AdSelectionConfig}
 * This value cannot be {@code null}.
 * @param decisionLogicJs override for scoring logic. See {@link android.adservices.adselection.AdSelectionConfig#getDecisionLogicUri()      }
 * This value cannot be {@code null}.
 * @param trustedScoringSignals override for trusted seller signals. See {@link android.adservices.adselection.AdSelectionConfig#getTrustedScoringSignalsUri()      }

 * This value cannot be {@code null}.
 */

public AddAdSelectionOverrideRequest(@android.annotation.NonNull android.adservices.adselection.AdSelectionConfig adSelectionConfig, @android.annotation.NonNull java.lang.String decisionLogicJs, @android.annotation.NonNull android.adservices.common.AdSelectionSignals trustedScoringSignals) { throw new RuntimeException("Stub!"); }

/**
 * @return an instance of {@link android.adservices.adselection.AdSelectionConfig AdSelectionConfig}, the configuration of the ad selection
 *     process. This configuration provides the data necessary to run Ad Selection flow that
 *     generates bids and scores to find a wining ad for rendering.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.adselection.AdSelectionConfig getAdSelectionConfig() { throw new RuntimeException("Stub!"); }

/**
 * @return The override javascript result, should be a string that contains valid JS code. The
 *     code should contain the scoring logic that will be executed during Ad selection.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String getDecisionLogicJs() { throw new RuntimeException("Stub!"); }

/**
 * @return The override trusted scoring signals, should be a valid json string. The trusted
 *     signals would be fed into the scoring logic during Ad Selection.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.common.AdSelectionSignals getTrustedScoringSignals() { throw new RuntimeException("Stub!"); }

/**
 * @return The override for the decision logic for each buyer that is used by contextual ads for
 *     reporting, which may be extended to updating bid values for contextual ads in the future

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.adselection.PerBuyerDecisionLogic getPerBuyerDecisionLogic() { throw new RuntimeException("Stub!"); }
}

