/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.adservices.common;


/**
 * A container for the ad filters that are based on app install state.
 *
 * <p>App install filters filter out ads based on the presence of packages installed on the device.
 * In order for filtering to work, a package must call the setAppInstallAdvertisers API with the
 * identifier of the adtech who owns this ad. If that call has been made, and the ad contains an
 * {@link android.adservices.common.AppInstallFilters AppInstallFilters} object whose package name set contains the name of the package, the ad
 * will be removed from the auction.
 *
 * <p>Note that the filtering is based on any package with one of the listed package names being on
 * the device. It is possible that the package holding the package name is not the application
 * targeted by the ad.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class AppInstallFilters implements android.os.Parcelable {

AppInstallFilters() { throw new RuntimeException("Stub!"); }

/**
 * Gets the list of package names this ad is filtered on.
 *
 * <p>The ad containing this filter will be removed from the ad auction if any of the package
 * names are present on the device and have called setAppInstallAdvertisers.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.Set<java.lang.String> getPackageNames() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

/** @hide */

public int describeContents() { throw new RuntimeException("Stub!"); }

/** Checks whether the {@link android.adservices.common.AppInstallFilters AppInstallFilters} objects contain the same information. */

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

/** Returns the hash of the {@link android.adservices.common.AppInstallFilters AppInstallFilters} object's data. */

public int hashCode() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.adservices.common.AppInstallFilters> CREATOR;
static { CREATOR = null; }
/** Builder for creating {@link android.adservices.common.AppInstallFilters AppInstallFilters} objects. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * Gets the list of package names this ad is filtered on.
 *
 * <p>See {@link #getPackageNames()} for more information.
 
 * @param packageNames This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.common.AppInstallFilters.Builder setPackageNames(@android.annotation.NonNull java.util.Set<java.lang.String> packageNames) { throw new RuntimeException("Stub!"); }

/**
 * Builds and returns a {@link android.adservices.common.AppInstallFilters AppInstallFilters} instance.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.common.AppInstallFilters build() { throw new RuntimeException("Stub!"); }
}

}

