/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.adservices.common;

import java.time.Duration;

/**
 * A frequency cap for a specific ad counter key.
 *
 * <p>Frequency caps define the maximum rate an event can occur within a given time interval. If the
 * frequency cap is exceeded, the associated ad will be filtered out of ad selection.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class KeyedFrequencyCap implements android.os.Parcelable {

KeyedFrequencyCap() { throw new RuntimeException("Stub!"); }

/**
 * Returns the ad counter key that the frequency cap is applied to.
 *
 * <p>The ad counter key is defined by an adtech and is an arbitrary numeric identifier which
 * defines any criteria which may have previously been counted and persisted on the device. If
 * the on-device count exceeds the maximum count within a certain time interval, the frequency
 * cap has been exceeded.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public int getAdCounterKey() { throw new RuntimeException("Stub!"); }

/**
 * Returns the maximum count of event occurrences allowed within a given time interval.
 *
 * <p>If there are more events matching the ad counter key and ad event type counted on the
 * device within the time interval defined by {@link #getInterval()}, the frequency cap has been
 * exceeded, and the ad will not be eligible for ad selection.
 *
 * <p>For example, an ad that specifies a filter for a max count of two within one hour will not
 * be eligible for ad selection if the event has been counted two or more times within the hour
 * preceding the ad selection process.
 */

public int getMaxCount() { throw new RuntimeException("Stub!"); }

/**
 * Returns the interval, as a {@link java.time.Duration Duration} which will be truncated to the nearest second,
 * over which the frequency cap is calculated.
 *
 * <p>When this frequency cap is computed, the number of persisted events is counted in the most
 * recent time interval. If the count of previously occurring matching events for an adtech is
 * greater than the number returned by {@link #getMaxCount()}, the frequency cap has been
 * exceeded, and the ad will not be eligible for ad selection.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.time.Duration getInterval() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

/** @hide */

public int describeContents() { throw new RuntimeException("Stub!"); }

/** Checks whether the {@link android.adservices.common.KeyedFrequencyCap KeyedFrequencyCap} objects contain the same information. */

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

/** Returns the hash of the {@link android.adservices.common.KeyedFrequencyCap KeyedFrequencyCap} object's data. */

public int hashCode() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.adservices.common.KeyedFrequencyCap> CREATOR;
static { CREATOR = null; }
/** Builder for creating {@link android.adservices.common.KeyedFrequencyCap KeyedFrequencyCap} objects. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/**
 * @param interval This value cannot be {@code null}.
 */

public Builder(int adCounterKey, int maxCount, @android.annotation.NonNull java.time.Duration interval) { throw new RuntimeException("Stub!"); }

/**
 * Sets the ad counter key the frequency cap applies to.
 *
 * <p>See {@link #getAdCounterKey()} for more information.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.common.KeyedFrequencyCap.Builder setAdCounterKey(int adCounterKey) { throw new RuntimeException("Stub!"); }

/**
 * Sets the maximum count within the time interval for the frequency cap.
 *
 * <p>See {@link #getMaxCount()} for more information.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.common.KeyedFrequencyCap.Builder setMaxCount(int maxCount) { throw new RuntimeException("Stub!"); }

/**
 * Sets the interval, as a {@link java.time.Duration Duration} which will be truncated to the nearest second,
 * over which the frequency cap is calculated.
 *
 * <p>See {@link #getInterval()} for more information.
 
 * @param interval This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.common.KeyedFrequencyCap.Builder setInterval(@android.annotation.NonNull java.time.Duration interval) { throw new RuntimeException("Stub!"); }

/**
 * Builds and returns a {@link android.adservices.common.KeyedFrequencyCap KeyedFrequencyCap} instance.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.common.KeyedFrequencyCap build() { throw new RuntimeException("Stub!"); }
}

}

