/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.adservices.customaudience;

import android.content.Context;
import java.util.concurrent.Executor;

/** CustomAudienceManager provides APIs for app and ad-SDKs to join / leave custom audiences. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class CustomAudienceManager {

CustomAudienceManager() { throw new RuntimeException("Stub!"); }

/**
 * Factory method for creating an instance of CustomAudienceManager.
 *
 * @param context The {@link android.content.Context Context} to use
 * This value cannot be {@code null}.
 * @return A {@link android.adservices.customaudience.CustomAudienceManager CustomAudienceManager} instance
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public static android.adservices.customaudience.CustomAudienceManager get(@android.annotation.NonNull android.content.Context context) { throw new RuntimeException("Stub!"); }

/**
 * Create a service with test-enabling APIs
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.customaudience.TestCustomAudienceManager getTestCustomAudienceManager() { throw new RuntimeException("Stub!"); }

/**
 * Adds the user to the given {@link android.adservices.customaudience.CustomAudience CustomAudience}.
 *
 * <p>An attempt to register the user for a custom audience with the same combination of {@code
 * ownerPackageName}, {@code buyer}, and {@code name} will cause the existing custom audience's
 * information to be overwritten, including the list of ads data.
 *
 * <p>Note that the ads list can be completely overwritten by the daily background fetch job.
 *
 * <p>This call fails with an {@link java.lang.SecurityException SecurityException} if
 *
 * <ol>
 *   <li>the {@code ownerPackageName} is not calling app's package name and/or
 *   <li>the buyer is not authorized to use the API.
 * </ol>
 *
 * <p>This call fails with an {@link java.lang.IllegalArgumentException IllegalArgumentException} if
 *
 * <ol>
 *   <li>the storage limit has been exceeded by the calling application and/or
 *   <li>any URI parameters in the {@link android.adservices.customaudience.CustomAudience CustomAudience} given are not authenticated with the
 *       {@link android.adservices.customaudience.CustomAudience CustomAudience} buyer.
 * </ol>
 *
 * <p>This call fails with {@link android.os.LimitExceededException LimitExceededException} if the calling package exceeds the
 * allowed rate limits and is throttled.
 *
 * <p>This call fails with an {@link java.lang.IllegalStateException IllegalStateException} if an internal service error is
 * encountered.

 * <br>
 * Requires {@link android.adservices.common.AdServicesPermissions#ACCESS_ADSERVICES_CUSTOM_AUDIENCE}
 
 * @param joinCustomAudienceRequest This value cannot be {@code null}.

 * @param executor This value cannot be {@code null}.
 
 * Callback and listener events are dispatched through this
 * {@link java.util.concurrent.Executor Executor}, providing an easy way to control which thread is
 * used. To dispatch events through the main thread of your
 * application, you can use
 * {@link android.content.Context#getMainExecutor() Context.getMainExecutor()}.
 * Otherwise, provide an {@link java.util.concurrent.Executor Executor} that dispatches to an appropriate thread.

 * @param receiver This value cannot be {@code null}.
 */

public void joinCustomAudience(@android.annotation.NonNull android.adservices.customaudience.JoinCustomAudienceRequest joinCustomAudienceRequest, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.os.OutcomeReceiver<java.lang.Object,java.lang.Exception> receiver) { throw new RuntimeException("Stub!"); }

/**
 * Adds the user to the {@link android.adservices.customaudience.CustomAudience CustomAudience} fetched from a {@code fetchUri}.
 *
 * <p>An attempt to register the user for a custom audience with the same combination of {@code
 * ownerPackageName}, {@code buyer}, and {@code name} will cause the existing custom audience's
 * information to be overwritten, including the list of ads data.
 *
 * <p>Note that the ads list can be completely overwritten by the daily background fetch job.
 *
 * <p>This call fails with an {@link java.lang.SecurityException SecurityException} if
 *
 * <ol>
 *   <li>the {@code ownerPackageName} is not calling app's package name and/or
 *   <li>the buyer is not authorized to use the API.
 * </ol>
 *
 * <p>This call fails with an {@link java.lang.IllegalArgumentException IllegalArgumentException} if
 *
 * <ol>
 *   <li>the storage limit has been exceeded by the calling application and/or
 *   <li>any URI parameters in the {@link android.adservices.customaudience.CustomAudience CustomAudience} given are not authenticated with the
 *       {@link android.adservices.customaudience.CustomAudience CustomAudience} buyer.
 * </ol>
 *
 * <p>This call fails with {@link android.os.LimitExceededException LimitExceededException} if the calling package exceeds the
 * allowed rate limits and is throttled.
 *
 * <p>This call fails with an {@link java.lang.IllegalStateException IllegalStateException} if an internal service error is
 * encountered.

 * <br>
 * Requires {@link android.adservices.common.AdServicesPermissions#ACCESS_ADSERVICES_CUSTOM_AUDIENCE}
 
 * @param fetchAndJoinCustomAudienceRequest This value cannot be {@code null}.

 * @param executor This value cannot be {@code null}.
 
 * Callback and listener events are dispatched through this
 * {@link java.util.concurrent.Executor Executor}, providing an easy way to control which thread is
 * used. To dispatch events through the main thread of your
 * application, you can use
 * {@link android.content.Context#getMainExecutor() Context.getMainExecutor()}.
 * Otherwise, provide an {@link java.util.concurrent.Executor Executor} that dispatches to an appropriate thread.

 * @param receiver This value cannot be {@code null}.
 */

public void fetchAndJoinCustomAudience(@android.annotation.NonNull android.adservices.customaudience.FetchAndJoinCustomAudienceRequest fetchAndJoinCustomAudienceRequest, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.os.OutcomeReceiver<java.lang.Object,java.lang.Exception> receiver) { throw new RuntimeException("Stub!"); }

/**
 * Attempts to remove a user from a custom audience by deleting any existing {@link android.adservices.customaudience.CustomAudience CustomAudience} data, identified by {@code ownerPackageName}, {@code buyer}, and {@code
 * name}.
 *
 * <p>This call fails with an {@link java.lang.SecurityException SecurityException} if
 *
 * <ol>
 *   <li>the {@code ownerPackageName} is not calling app's package name; and/or
 *   <li>the buyer is not authorized to use the API.
 * </ol>
 *
 * <p>This call fails with {@link android.os.LimitExceededException LimitExceededException} if the calling package exceeds the
 * allowed rate limits and is throttled.
 *
 * <p>This call does not inform the caller whether the custom audience specified existed in
 * on-device storage. In other words, it will fail silently when a buyer attempts to leave a
 * custom audience that was not joined.

 * <br>
 * Requires {@link android.adservices.common.AdServicesPermissions#ACCESS_ADSERVICES_CUSTOM_AUDIENCE}
 
 * @param leaveCustomAudienceRequest This value cannot be {@code null}.

 * @param executor This value cannot be {@code null}.
 
 * Callback and listener events are dispatched through this
 * {@link java.util.concurrent.Executor Executor}, providing an easy way to control which thread is
 * used. To dispatch events through the main thread of your
 * application, you can use
 * {@link android.content.Context#getMainExecutor() Context.getMainExecutor()}.
 * Otherwise, provide an {@link java.util.concurrent.Executor Executor} that dispatches to an appropriate thread.

 * @param receiver This value cannot be {@code null}.
 */

public void leaveCustomAudience(@android.annotation.NonNull android.adservices.customaudience.LeaveCustomAudienceRequest leaveCustomAudienceRequest, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.os.OutcomeReceiver<java.lang.Object,java.lang.Exception> receiver) { throw new RuntimeException("Stub!"); }

/**
 * Allows the API caller to schedule a deferred Custom Audience update. For each update the user
 * will be able to join or leave a set of CustomAudiences.
 *
 * <p>This API only guarantees minimum delay to make the update, and does not guarantee a
 * maximum deadline within which the update request would be made. Scheduled updates could be
 * batched and queued together to preserve system resources, thus exact delay time is not
 * guaranteed.
 *
 * <p>In order to conserve system resources the API will make and update request only if the
 * following constraints are satisfied
 *
 * <ol>
 *   <li>The device is using an un-metered internet connection
 *   <li>The device battery is not low
 *   <li>The device storage is not low
 * </ol>
 *
 * <p>When the deferred update is triggered the API makes a POST request to the provided
 * updateUri with the request body containing a JSON of Partial Custom Audience list.
 *
 * <p>An example of request body containing list of Partial Custom Audiences would look like:
 *
 * <pre>{@code
 * {
 *     "partial_custom_audience_data": [
 *         {
 *             "name": "running_shoes",
 *             "activation_time": 1644375856883,
 *             "expiration_time": 1644375908397
 *         },
 *         {
 *             "name": "casual_shirt",
 *             "user_bidding_signals": {
 *                 "signal1": "value1"
 *             }
 *         }
 *     ]
 * }
 * }</pre>
 *
 * <p>In response the API expects a JSON in return with following keys:
 *
 * <ol>
 *   <li>"join" : Should contain list containing full data for a {@link android.adservices.customaudience.CustomAudience CustomAudience} object
 *   <li>"leave" : List of {@link android.adservices.customaudience.CustomAudience CustomAudience} names that user is intended to be removed from
 * </ol>
 *
 * <p>An example of JSON in response would look like:
 *
 * <pre>{@code
 * {
 *     "join": [
 *         {
 *             "name": "running-shoes",
 *             "activation_time": 1680603133,
 *             "expiration_time": 1680803133,
 *             "user_bidding_signals": {
 *                 "signal1": "value"
 *             },
 *             "trusted_bidding_data": {
 *                 "trusted_bidding_uri": "https://example-dsp.com/",
 *                 "trusted_bidding_keys": [
 *                     "k1",
 *                     "k2"
 *                 ]
 *             },
 *             "bidding_logic_uri": "https://example-dsp.com/...",
 *             "ads": [
 *                 {
 *                     "render_uri": "https://example-dsp.com/...",
 *                     "metadata": {},
 *                     "ad_filters": {
 *                         "frequency_cap": {
 *                             "win": [
 *                                 {
 *                                     "ad_counter_key": "key1",
 *                                     "max_count": 2,
 *                                     "interval_in_seconds": 60
 *                                 }
 *                             ],
 *                             "view": [
 *                                 {
 *                                     "ad_counter_key": "key2",
 *                                     "max_count": 10,
 *                                     "interval_in_seconds": 3600
 *                                 }
 *                             ]
 *                         },
 *                         "app_install": {
 *                             "package_names": [
 *                                 "package.name.one"
 *                             ]
 *                         }
 *                     }
 *                 }
 *             ]
 *         },
 *         {}
 *     ],
 *     "leave": [
 *         "tennis_shoes",
 *         "formal_shirt"
 *     ]
 * }
 * }</pre>
 *
 * <p>An attempt to register the user for a custom audience from the same application with the
 * same combination of {@code buyer} inferred from Update Uri, and {@code name} will cause the
 * existing custom audience's information to be overwritten, including the list of ads data.
 *
 * <p>In case information related to any of the CustomAudience to be joined is malformed, the
 * deferred update would silently ignore that single Custom Audience
 *
 * <p>When removing this API attempts to remove a user from a custom audience by deleting any
 * existing {@link android.adservices.customaudience.CustomAudience CustomAudience} identified by owner i.e. calling app, {@code buyer} inferred
 * from Update Uri, and {@code name}
 *
 * <p>Any partial custom audience field set by the caller cannot be overridden by the custom
 * audience fetched from the {@code updateUri}. Given multiple Custom Audiences could be
 * returned by a DSP we will match the override restriction based on the names of the Custom
 * Audiences. A DSP may skip returning a full Custom Audience for any Partial Custom Audience in
 * request.
 *
 * <p>In case the API encounters transient errors while making the network call for update, like
 * 5xx, connection timeout, rate limit exceeded it would employ retries, with backoff up to a
 * 'retry limit' number of times. The API would also honor 'retry-after' header specifying the
 * min amount of seconds by which the next request should be delayed.
 *
 * <p>In a scenario where server responds with a '429 status code', signifying 'Too many
 * requests', API would place the deferred update and other updates for the same requester i.e.
 * caller package and buyer combination, in a quarantine. The quarantine records would be
 * referred before making any calls for requesters, and request will only be made once the
 * quarantine period has expired. The applications can leverage the `retry-after` header to
 * self-quarantine for traffic management to their servers and prevent being overwhelmed with
 * requests. The default quarantine value will be set to 30 minutes.
 *
 * <p>This call fails with an {@link java.lang.SecurityException SecurityException} if
 *
 * <ol>
 *   <li>the {@code ownerPackageName} is not calling app's package name; and/or
 *   <li>the buyer, inferred from {@code updateUri}, is not authorized to use the API.
 * </ol>
 *
 * <p>This call fails with an {@link java.lang.IllegalArgumentException IllegalArgumentException} if
 *
 * <ol>
 *   <li>the provided {@code updateUri} is invalid or malformed.
 *   <li>the provided {@code delayTime} is not within permissible bounds
 *   <li>the combined size of {@code partialCustomAudience} list is larger than allowed limits
 * </ol>
 *
 * <p>This call fails with {@link android.os.LimitExceededException LimitExceededException} if the calling package exceeds the
 * allowed rate limits and is throttled.

 * <br>
 * Requires {@link android.adservices.common.AdServicesPermissions#ACCESS_ADSERVICES_CUSTOM_AUDIENCE}
 
 * @param request This value cannot be {@code null}.

 * @param executor This value cannot be {@code null}.
 
 * Callback and listener events are dispatched through this
 * {@link java.util.concurrent.Executor Executor}, providing an easy way to control which thread is
 * used. To dispatch events through the main thread of your
 * application, you can use
 * {@link android.content.Context#getMainExecutor() Context.getMainExecutor()}.
 * Otherwise, provide an {@link java.util.concurrent.Executor Executor} that dispatches to an appropriate thread.

 * @param receiver This value cannot be {@code null}.
 */

public void scheduleCustomAudienceUpdate(@android.annotation.NonNull android.adservices.customaudience.ScheduleCustomAudienceUpdateRequest request, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.adservices.common.AdServicesOutcomeReceiver<java.lang.Object,java.lang.Exception> receiver) { throw new RuntimeException("Stub!"); }
}

