/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.adservices.customaudience;

import android.net.Uri;
import java.time.Instant;

/**
 * The request object wrapping the required and optional parameters needed to fetch a {@link android.adservices.customaudience.CustomAudience CustomAudience}.
 *
 * <p>{@code fetchUri} is the only required parameter. It represents the URI to fetch a custom
 * audience from. {@code name}, {@code activationTime}, {@code expirationTime} and {@code
 * userBiddingSignals} are optional parameters. They represent a partial custom audience which can
 * be used by the caller to inform the choice of the custom audience the user should be added to.
 * Any field set by the caller cannot be overridden by the custom audience fetched from the {@code
 * fetchUri}. For more information about each field refer to {@link android.adservices.customaudience.CustomAudience CustomAudience}.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class FetchAndJoinCustomAudienceRequest {

FetchAndJoinCustomAudienceRequest() { throw new RuntimeException("Stub!"); }

/**
 * @return the {@link android.net.Uri Uri} from which the custom audience is to be fetched.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.Uri getFetchUri() { throw new RuntimeException("Stub!"); }

/**
 * Reference {@link android.adservices.customaudience.CustomAudience#getName() CustomAudience#getName()} for details.
 *
 * @return the {@link java.lang.String String} name of the custom audience to join.

 * This value may be {@code null}.
 */

@android.annotation.Nullable
public java.lang.String getName() { throw new RuntimeException("Stub!"); }

/**
 * Reference {@link android.adservices.customaudience.CustomAudience#getActivationTime() CustomAudience#getActivationTime()} for details.
 *
 * @return the {@link java.time.Instant Instant} by which joining the custom audience will be delayed.

 * This value may be {@code null}.
 */

@android.annotation.Nullable
public java.time.Instant getActivationTime() { throw new RuntimeException("Stub!"); }

/**
 * Reference {@link android.adservices.customaudience.CustomAudience#getExpirationTime() CustomAudience#getExpirationTime()} for details.
 *
 * @return the {@link java.time.Instant Instant} by when the membership to the custom audience will expire.

 * This value may be {@code null}.
 */

@android.annotation.Nullable
public java.time.Instant getExpirationTime() { throw new RuntimeException("Stub!"); }

/**
 * Reference {@link android.adservices.customaudience.CustomAudience#getUserBiddingSignals() CustomAudience#getUserBiddingSignals()} for details.
 *
 * @return the buyer signals to be consumed by the buyer-provided JavaScript when the custom
 *     audience participates in an ad selection.

 * This value may be {@code null}.
 */

@android.annotation.Nullable
public android.adservices.common.AdSelectionSignals getUserBiddingSignals() { throw new RuntimeException("Stub!"); }

/**
 * @return {@code true} only if two {@link android.adservices.customaudience.FetchAndJoinCustomAudienceRequest FetchAndJoinCustomAudienceRequest} objects contain
 *     the same information.
 */

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

/**
 * @return the hash of the {@link android.adservices.customaudience.FetchAndJoinCustomAudienceRequest FetchAndJoinCustomAudienceRequest} object's data.
 */

public int hashCode() { throw new RuntimeException("Stub!"); }

/**
 * @return a human-readable representation of {@link android.adservices.customaudience.FetchAndJoinCustomAudienceRequest FetchAndJoinCustomAudienceRequest}.
 */

public java.lang.String toString() { throw new RuntimeException("Stub!"); }
/** Builder for {@link android.adservices.customaudience.FetchAndJoinCustomAudienceRequest FetchAndJoinCustomAudienceRequest} objects. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/**
 * Instantiates a {@link android.adservices.customaudience.FetchAndJoinCustomAudienceRequest.Builder FetchAndJoinCustomAudienceRequest.Builder} with the {@link android.net.Uri Uri}
 * from which the custom audience is to be fetched.

 * @param fetchUri This value cannot be {@code null}.
 */

public Builder(@android.annotation.NonNull android.net.Uri fetchUri) { throw new RuntimeException("Stub!"); }

/**
 * Sets the {@link android.net.Uri Uri} from which the custom audience is to be fetched.
 *
 * <p>See {@link #getFetchUri()} ()} for details.
 
 * @param fetchUri This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.customaudience.FetchAndJoinCustomAudienceRequest.Builder setFetchUri(@android.annotation.NonNull android.net.Uri fetchUri) { throw new RuntimeException("Stub!"); }

/**
 * Sets the {@link java.lang.String String} name of the custom audience to join.
 *
 * <p>See {@link #getName()} for details.
 
 * @param name This value may be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.customaudience.FetchAndJoinCustomAudienceRequest.Builder setName(@android.annotation.Nullable java.lang.String name) { throw new RuntimeException("Stub!"); }

/**
 * Sets the {@link java.time.Instant Instant} by which joining the custom audience will be delayed.
 *
 * <p>See {@link #getActivationTime()} for details.
 
 * @param activationTime This value may be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.customaudience.FetchAndJoinCustomAudienceRequest.Builder setActivationTime(@android.annotation.Nullable java.time.Instant activationTime) { throw new RuntimeException("Stub!"); }

/**
 * Sets the {@link java.time.Instant Instant} by when the membership to the custom audience will expire.
 *
 * <p>See {@link #getExpirationTime()} for details.
 
 * @param expirationTime This value may be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.customaudience.FetchAndJoinCustomAudienceRequest.Builder setExpirationTime(@android.annotation.Nullable java.time.Instant expirationTime) { throw new RuntimeException("Stub!"); }

/**
 * Sets the buyer signals to be consumed by the buyer-provided JavaScript when the custom
 * audience participates in an ad selection.
 *
 * <p>See {@link #getUserBiddingSignals()} for details.
 
 * @param userBiddingSignals This value may be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.customaudience.FetchAndJoinCustomAudienceRequest.Builder setUserBiddingSignals(@android.annotation.Nullable android.adservices.common.AdSelectionSignals userBiddingSignals) { throw new RuntimeException("Stub!"); }

/**
 * Builds an instance of a {@link android.adservices.customaudience.FetchAndJoinCustomAudienceRequest FetchAndJoinCustomAudienceRequest}.
 *
 * @throws java.lang.NullPointerException if any non-null parameter is null.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.customaudience.FetchAndJoinCustomAudienceRequest build() { throw new RuntimeException("Stub!"); }
}

}

