/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.adservices.measurement;

import android.net.Uri;

/** Class to hold input to measurement trigger registration calls from web context. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class WebTriggerRegistrationRequest implements android.os.Parcelable {

WebTriggerRegistrationRequest() { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

/**
 * Getter for trigger params.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<android.adservices.measurement.WebTriggerParams> getTriggerParams() { throw new RuntimeException("Stub!"); }

/**
 * Getter for destination.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.Uri getDestination() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param out This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel out, int flags) { throw new RuntimeException("Stub!"); }

/** Creator for Paracelable (via reflection). */

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.adservices.measurement.WebTriggerRegistrationRequest> CREATOR;
static { CREATOR = null; }
/** Builder for {@link android.adservices.measurement.WebTriggerRegistrationRequest WebTriggerRegistrationRequest}. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/**
 * Builder constructor for {@link android.adservices.measurement.WebTriggerRegistrationRequest WebTriggerRegistrationRequest}.
 *
 * @param webTriggerParams contains trigger registration parameters, the list should not be
 *     empty
 * This value cannot be {@code null}.
 * @param destination trigger destination {@link android.net.Uri Uri}

 * This value cannot be {@code null}.
 */

public Builder(@android.annotation.NonNull java.util.List<android.adservices.measurement.WebTriggerParams> webTriggerParams, @android.annotation.NonNull android.net.Uri destination) { throw new RuntimeException("Stub!"); }

/**
 * Pre-validates parameters and builds {@link android.adservices.measurement.WebTriggerRegistrationRequest WebTriggerRegistrationRequest}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.measurement.WebTriggerRegistrationRequest build() { throw new RuntimeException("Stub!"); }
}

}

