/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.adservices.ondevicepersonalization;


/**
 * Generates event tracking URLs for a request. The service can embed these URLs within the
 * HTML output as needed. When the HTML is rendered within an ODP WebView, ODP will intercept
 * requests to these URLs, call
 * {@code IsolatedWorker#onEvent(EventInput, android.os.OutcomeReceiver)}, and log the returned
 * output in the EVENTS table.
 *
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class EventUrlProvider {

EventUrlProvider() { throw new RuntimeException("Stub!"); }

/**
 * Creates an event tracking URL that returns the provided response. Returns HTTP Status
 * 200 (OK) if the response data is not empty. Returns HTTP Status 204 (No Content) if the
 * response data is empty.
 *
 * <br>
 * This method may take several seconds to complete, so it should
 * only be called from a worker thread.
 * @param eventParams The data to be passed to
 *     {@code IsolatedWorker#onEvent(EventInput, android.os.OutcomeReceiver)}
 *     when the event occurs.
 * This value cannot be {@code null}.
 * @param responseData The content to be returned to the WebView when the URL is fetched.
 * This value may be {@code null}.
 * @param mimeType The Mime Type of the URL response.
 * This value may be {@code null}.
 * @return An ODP event URL that can be inserted into a WebView.
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.Uri createEventTrackingUrlWithResponse(@android.annotation.NonNull android.os.PersistableBundle eventParams, @android.annotation.Nullable byte[] responseData, @android.annotation.Nullable java.lang.String mimeType) { throw new RuntimeException("Stub!"); }

/**
 * Creates an event tracking URL that redirects to the provided destination URL when it is
 * clicked in an ODP webview.
 *
 * <br>
 * This method may take several seconds to complete, so it should
 * only be called from a worker thread.
 * @param eventParams The data to be passed to
 *     {@code IsolatedWorker#onEvent(EventInput, android.os.OutcomeReceiver)}
 *     when the event occurs
 * This value cannot be {@code null}.
 * @param destinationUrl The URL to redirect to.
 * This value may be {@code null}.
 * @return An ODP event URL that can be inserted into a WebView.
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.Uri createEventTrackingUrlWithRedirect(@android.annotation.NonNull android.os.PersistableBundle eventParams, @android.annotation.Nullable android.net.Uri destinationUrl) { throw new RuntimeException("Stub!"); }
}

