/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.adservices.ondevicepersonalization;


/** The input data for {@link android.adservices.ondevicepersonalization.FederatedComputeScheduler#schedule FederatedComputeScheduler#schedule}. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class FederatedComputeInput {

FederatedComputeInput() { throw new RuntimeException("Stub!"); }

/**
 * Population refers to a collection of devices that specific task groups can run on. It should
 * match task plan configured at remote federated compute server.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String getPopulationName() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param o This value may be {@code null}.
 */

public boolean equals(@android.annotation.Nullable java.lang.Object o) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }
/** A builder for {@link android.adservices.ondevicepersonalization.FederatedComputeInput FederatedComputeInput} */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * Setter for {@link #getPopulationName}.
 * @param value This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.ondevicepersonalization.FederatedComputeInput.Builder setPopulationName(@android.annotation.NonNull java.lang.String value) { throw new RuntimeException("Stub!"); }

/**
 * Builds the instance. This builder should not be touched after calling this!
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.ondevicepersonalization.FederatedComputeInput build() { throw new RuntimeException("Stub!"); }
}

}

