/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.adservices.ondevicepersonalization;


/**
 * An interface to a read-write key-value store.
 *
 * Used as a Data Access Object for the LOCAL_DATA table.
 *
 * @see android.adservices.ondevicepersonalization.IsolatedService#getLocalData(RequestToken)
 *
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public interface MutableKeyValueStore extends android.adservices.ondevicepersonalization.KeyValueStore {

/**
 * Associates the specified value with the specified key.
 * If a value already exists for that key, the old value is replaced.
 *
 * <br>
 * This method may take several seconds to complete, so it should
 * only be called from a worker thread.
 * @param key key with which the specified value is to be associated
 * This value cannot be {@code null}.
 * @param value value to be associated with the specified key
 *
 * This value cannot be {@code null}.
 * @return the previous value associated with key, or null if there was no mapping for key.
 */

@android.annotation.Nullable
public byte[] put(@android.annotation.NonNull java.lang.String key, @android.annotation.NonNull byte[] value);

/**
 * Removes the mapping for the specified key.
 *
 * <br>
 * This method may take several seconds to complete, so it should
 * only be called from a worker thread.
 * @param key key whose mapping is to be removed
 *
 * This value cannot be {@code null}.
 * @return the previous value associated with key, or null if there was no mapping for key.
 */

@android.annotation.Nullable
public byte[] remove(@android.annotation.NonNull java.lang.String key);
}

