/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.adservices.ondevicepersonalization;

import android.content.ComponentName;
import android.content.Context;
import android.os.IBinder;
import android.os.OutcomeReceiver;
import android.os.PersistableBundle;
import android.view.SurfaceControlViewHost;
import java.util.concurrent.Executor;

/**
 * OnDevicePersonalizationManager provides APIs for apps to load an
 * {@link android.adservices.ondevicepersonalization.IsolatedService IsolatedService} in an isolated process and interact with it.
 *
 * An app can request an {@link android.adservices.ondevicepersonalization.IsolatedService IsolatedService} to generate content for display
 * within an {@link android.view.SurfaceView} within the app's view hierarchy, and also write
 * persistent results to on-device storage which can be consumed by Federated Analytics for
 * cross-device statistical analysis or by Federated Learning for model training. The displayed
 * content and the persistent output are both not directly accessible by the calling app.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class OnDevicePersonalizationManager {

OnDevicePersonalizationManager() { throw new RuntimeException("Stub!"); }

/**
 * Executes an {@link android.adservices.ondevicepersonalization.IsolatedService IsolatedService} in the OnDevicePersonalization sandbox. The
 * platform binds to the specified {@link android.adservices.ondevicepersonalization.IsolatedService IsolatedService} in an isolated process
 * and calls {@link android.adservices.ondevicepersonalization.IsolatedWorker#onExecute(android.adservices.ondevicepersonalization.ExecuteInput,android.os.OutcomeReceiver) IsolatedWorker#onExecute(ExecuteInput, android.os.OutcomeReceiver)}
 * with the caller-provided parameters. When the {@link android.adservices.ondevicepersonalization.IsolatedService IsolatedService} finishes execution,
 * the platform returns tokens that refer to the results from the service to the caller.
 * These tokens can be subsequently used to display results in a
 * {@link android.view.SurfaceView} within the calling app.
 *
 * @param service The {@link android.content.ComponentName ComponentName} of the {@link android.adservices.ondevicepersonalization.IsolatedService IsolatedService}.
 * This value cannot be {@code null}.
 * @param params a {@link android.os.PersistableBundle PersistableBundle} that is passed from the calling app to the
 *     {@link android.adservices.ondevicepersonalization.IsolatedService IsolatedService}. The expected contents of this parameter are defined
 *     by the{@link android.adservices.ondevicepersonalization.IsolatedService IsolatedService}. The platform does not interpret this parameter.
 * This value cannot be {@code null}.
 * @param executor the {@link java.util.concurrent.Executor Executor} on which to invoke the callback.
 * This value cannot be {@code null}.
 * Callback and listener events are dispatched through this
 * {@link java.util.concurrent.Executor Executor}, providing an easy way to control which thread is
 * used. To dispatch events through the main thread of your
 * application, you can use
 * {@link android.content.Context#getMainExecutor() Context.getMainExecutor()}.
 * Otherwise, provide an {@link java.util.concurrent.Executor Executor} that dispatches to an appropriate thread.
 * @param receiver This returns a {@link android.adservices.ondevicepersonalization.OnDevicePersonalizationManager.ExecuteResult ExecuteResult} object on success or an
 *     {@link java.lang.Exception Exception} on failure. If the
 *     {@link android.adservices.ondevicepersonalization.IsolatedService IsolatedService} returned a {@link android.adservices.ondevicepersonalization.RenderingConfig RenderingConfig} to be displayed,
 *     {@link android.adservices.ondevicepersonalization.OnDevicePersonalizationManager.ExecuteResult#getSurfacePackageToken() ExecuteResult#getSurfacePackageToken()} will return a non-null
 *     {@link android.adservices.ondevicepersonalization.SurfacePackageToken SurfacePackageToken}.
 *     The {@link android.adservices.ondevicepersonalization.SurfacePackageToken SurfacePackageToken} object can be used in a subsequent
 *     {@link #requestSurfacePackage(android.adservices.ondevicepersonalization.SurfacePackageToken,android.os.IBinder,int,int,int,java.util.concurrent.Executor,android.os.OutcomeReceiver)} call to display the result in a view. The returned
 *     {@link android.adservices.ondevicepersonalization.SurfacePackageToken SurfacePackageToken} may be null to indicate that no output is expected to be
 *     displayed for this request. If the {@link android.adservices.ondevicepersonalization.IsolatedService IsolatedService} has returned any output data
 *     and the calling app is allowlisted to receive data from this service, the
 *     {@link android.adservices.ondevicepersonalization.OnDevicePersonalizationManager.ExecuteResult#getOutputData() ExecuteResult#getOutputData()} will return a non-null byte array.
 *
 *     In case of an error, the receiver returns one of the following exceptions:
 *     Returns a {@link android.content.pm.PackageManager.NameNotFoundException} if the handler
 *     package is not installed or does not have a valid ODP manifest.
 *     Returns {@link java.lang.ClassNotFoundException ClassNotFoundException} if the handler class is not found.
 *     Returns an {@link android.adservices.ondevicepersonalization.OnDevicePersonalizationException OnDevicePersonalizationException} if execution of the handler fails.
 */

public void execute(@android.annotation.NonNull android.content.ComponentName service, @android.annotation.NonNull android.os.PersistableBundle params, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.os.OutcomeReceiver<android.adservices.ondevicepersonalization.OnDevicePersonalizationManager.ExecuteResult,java.lang.Exception> receiver) { throw new RuntimeException("Stub!"); }

/**
 * Requests a {@link android.view.SurfaceControlViewHost.SurfacePackage} to be inserted into a
 * {@link android.view.SurfaceView} inside the calling app. The surface package will contain an
 * {@link android.view.View} with the content from a result of a prior call to
 * {@code #execute(ComponentName, PersistableBundle, Executor, OutcomeReceiver)} running in
 * the OnDevicePersonalization sandbox.
 *
 * @param surfacePackageToken a reference to a {@link android.adservices.ondevicepersonalization.SurfacePackageToken SurfacePackageToken} returned by a prior
 *     call to {@code #execute(ComponentName, PersistableBundle, Executor, OutcomeReceiver)}.
 * This value cannot be {@code null}.
 * @param surfaceViewHostToken the hostToken of the {@link android.view.SurfaceView}, which is
 *     returned by {@link android.view.SurfaceView#getHostToken()} after the
 *     {@link android.view.SurfaceView} has been added to the view hierarchy.
 * This value cannot be {@code null}.
 * @param displayId the integer ID of the logical display on which to display the
 *     {@link android.view.SurfaceControlViewHost.SurfacePackage}, returned by
 *     {@code Context.getDisplay().getDisplayId()}.
 * @param width the width of the {@link android.view.SurfaceControlViewHost.SurfacePackage}
 *     in pixels.
 * @param height the height of the {@link android.view.SurfaceControlViewHost.SurfacePackage}
 *     in pixels.
 * @param executor the {@link java.util.concurrent.Executor Executor} on which to invoke the callback
 * This value cannot be {@code null}.
 * Callback and listener events are dispatched through this
 * {@link java.util.concurrent.Executor Executor}, providing an easy way to control which thread is
 * used. To dispatch events through the main thread of your
 * application, you can use
 * {@link android.content.Context#getMainExecutor() Context.getMainExecutor()}.
 * Otherwise, provide an {@link java.util.concurrent.Executor Executor} that dispatches to an appropriate thread.
 * @param receiver This either returns a
 *     {@link android.view.SurfaceControlViewHost.SurfacePackage} on success, or
 *     {@link java.lang.Exception Exception} on failure. The exception type is
 *     {@link android.adservices.ondevicepersonalization.OnDevicePersonalizationException OnDevicePersonalizationException} if execution of the handler fails.

 * This value cannot be {@code null}.
 */

public void requestSurfacePackage(@android.annotation.NonNull android.adservices.ondevicepersonalization.SurfacePackageToken surfacePackageToken, @android.annotation.NonNull android.os.IBinder surfaceViewHostToken, int displayId, int width, int height, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.os.OutcomeReceiver<android.view.SurfaceControlViewHost.SurfacePackage,java.lang.Exception> receiver) { throw new RuntimeException("Stub!"); }
/**
 * The result of a call to {@link android.adservices.ondevicepersonalization.OnDevicePersonalizationManager#execute(android.content.ComponentName,android.os.PersistableBundle,java.util.concurrent.Executor,android.os.OutcomeReceiver) OnDevicePersonalizationManager#execute(ComponentName,
 * PersistableBundle, Executor, OutcomeReceiver)}
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class ExecuteResult {

ExecuteResult() { throw new RuntimeException("Stub!"); }

/**
 * Returns a {@link android.adservices.ondevicepersonalization.SurfacePackageToken SurfacePackageToken}, which is an opaque reference to content that
 * can be displayed in a {@link android.view.SurfaceView}. This may be null if the
 * {@link android.adservices.ondevicepersonalization.IsolatedService IsolatedService} has not generated any content to be displayed within the
 * calling app.
 */

@android.annotation.Nullable
public android.adservices.ondevicepersonalization.SurfacePackageToken getSurfacePackageToken() { throw new RuntimeException("Stub!"); }

/**
 * Returns the output data that was returned by the {@link android.adservices.ondevicepersonalization.IsolatedService IsolatedService}. This will be
 * non-null if the {@link android.adservices.ondevicepersonalization.IsolatedService IsolatedService} returns any results to the caller, and the
 * egress of data from the {@link android.adservices.ondevicepersonalization.IsolatedService IsolatedService} to the specific calling app is allowed
 * by policy as well as an allowlist.
 */

@android.annotation.Nullable
public byte[] getOutputData() { throw new RuntimeException("Stub!"); }
}

}

