/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.adservices.ondevicepersonalization;

import java.util.List;

/**
 * Information returned by
 * {@link android.adservices.ondevicepersonalization.IsolatedWorker#onExecute(android.adservices.ondevicepersonalization.ExecuteInput,android.os.OutcomeReceiver) IsolatedWorker#onExecute(ExecuteInput, android.os.OutcomeReceiver)}
 * that is used in a subesequent call to
 * {@link android.adservices.ondevicepersonalization.IsolatedWorker#onRender(android.adservices.ondevicepersonalization.RenderInput,android.os.OutcomeReceiver) IsolatedWorker#onRender(RenderInput, android.os.OutcomeReceiver)} to identify the
 * content to be displayed in a single {@link android.view.View}.
 *
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class RenderingConfig implements android.os.Parcelable {

RenderingConfig() { throw new RuntimeException("Stub!"); }

/**
 * A List of keys in the REMOTE_DATA
 * {@link android.adservices.ondevicepersonalization.IsolatedService#getRemoteData(android.adservices.ondevicepersonalization.RequestToken) IsolatedService#getRemoteData(RequestToken)}
 * table that identify the content to be rendered.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<java.lang.String> getKeys() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param o This value may be {@code null}.
 */

public boolean equals(@android.annotation.Nullable java.lang.Object o) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.adservices.ondevicepersonalization.RenderingConfig> CREATOR;
static { CREATOR = null; }
/**
 * A builder for {@link android.adservices.ondevicepersonalization.RenderingConfig RenderingConfig}
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * A List of keys in the REMOTE_DATA
 * {@link android.adservices.ondevicepersonalization.IsolatedService#getRemoteData(android.adservices.ondevicepersonalization.RequestToken) IsolatedService#getRemoteData(RequestToken)}
 * table that identify the content to be rendered.
 
 * @param value This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.ondevicepersonalization.RenderingConfig.Builder setKeys(@android.annotation.NonNull java.util.List<java.lang.String> value) { throw new RuntimeException("Stub!"); }

/**
 * @see #setKeys
 * @param value This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.ondevicepersonalization.RenderingConfig.Builder addKey(@android.annotation.NonNull java.lang.String value) { throw new RuntimeException("Stub!"); }

/**
 * Builds the instance. This builder should not be touched after calling this!
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.ondevicepersonalization.RenderingConfig build() { throw new RuntimeException("Stub!"); }
}

}

