/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.adservices.ondevicepersonalization;


/** Training interval settings required for federated computation jobs. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class TrainingInterval {

TrainingInterval() { throw new RuntimeException("Stub!"); }

/**
 * The scheduling mode for this task, either {@link #SCHEDULING_MODE_ONE_TIME} or {@link
 * #SCHEDULING_MODE_RECURRENT}. The default scheduling mode is {@link #SCHEDULING_MODE_ONE_TIME}
 * if unspecified.

 * @return Value is {@link android.adservices.ondevicepersonalization.TrainingInterval#SCHEDULING_MODE_ONE_TIME}, or {@link android.adservices.ondevicepersonalization.TrainingInterval#SCHEDULING_MODE_RECURRENT}
 */

public int getSchedulingMode() { throw new RuntimeException("Stub!"); }

/**
 * Sets the minimum time interval between two training runs.
 *
 * <p>This field will only be used when the scheduling mode is {@link
 * #SCHEDULING_MODE_RECURRENT}. Only positive values are accepted, zero or negative values will
 * result in IllegalArgumentException.
 *
 * <p>Please also note this value is advisory, which does not guarantee the job will be run
 * immediately after the interval expired. Federated compute will still enforce a minimum
 * required interval and training constraints to ensure system health. The current training
 * constraints are device on unmetered network, idle and battery not low.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.time.Duration getMinimumInterval() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param o This value may be {@code null}.
 */

public boolean equals(@android.annotation.Nullable java.lang.Object o) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

/** The scheduling mode for a one-off task. */

public static final int SCHEDULING_MODE_ONE_TIME = 1; // 0x1

/** The scheduling mode for a task that will be rescheduled after each run. */

public static final int SCHEDULING_MODE_RECURRENT = 2; // 0x2
/** A builder for {@link android.adservices.ondevicepersonalization.TrainingInterval TrainingInterval} */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * The scheduling mode for this task, either {@link #SCHEDULING_MODE_ONE_TIME} or {@link
 * #SCHEDULING_MODE_RECURRENT}. The default scheduling mode is {@link
 * #SCHEDULING_MODE_ONE_TIME} if unspecified.
 
 * @param value Value is {@link android.adservices.ondevicepersonalization.TrainingInterval#SCHEDULING_MODE_ONE_TIME}, or {@link android.adservices.ondevicepersonalization.TrainingInterval#SCHEDULING_MODE_RECURRENT}
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.ondevicepersonalization.TrainingInterval.Builder setSchedulingMode(int value) { throw new RuntimeException("Stub!"); }

/**
 * Sets the minimum time interval between two training runs.
 *
 * <p>This field will only be used when the scheduling mode is {@link
 * #SCHEDULING_MODE_RECURRENT}. Only positive values are accepted, zero or negative values
 * will result in IllegalArgumentException.
 *
 * <p>Please also note this value is advisory, which does not guarantee the job will be run
 * immediately after the interval expired. Federated compute will still enforce a minimum
 * required interval and training constraints to ensure system health. The current training
 * constraints are device on unmetered network, idle and battery not low.
 
 * @param value This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.ondevicepersonalization.TrainingInterval.Builder setMinimumInterval(@android.annotation.NonNull java.time.Duration value) { throw new RuntimeException("Stub!"); }

/**
 * Builds the instance. This builder should not be touched after calling this!
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.ondevicepersonalization.TrainingInterval build() { throw new RuntimeException("Stub!"); }
}

}

