/*
 * Copyright 2020 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.app.appsearch;

import android.app.appsearch.exceptions.AppSearchException;
import java.util.Collection;

/**
 * The AppSearch Schema for a particular type of document.
 *
 * <p>For example, an e-mail message or a music recording could be a schema type.
 *
 * <p>The schema consists of type information, properties, and config (like tokenization type).
 *
 * @see android.app.appsearch.AppSearchSession#setSchema
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class AppSearchSchema implements android.os.Parcelable {

AppSearchSchema() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/**
 * Returns the name of this schema type, such as Email.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String getSchemaType() { throw new RuntimeException("Stub!"); }

/**
 * Returns the list of {@link android.app.appsearch.AppSearchSchema.PropertyConfig PropertyConfig}s that are part of this schema.
 *
 * <p>This method creates a new list when called.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<android.app.appsearch.AppSearchSchema.PropertyConfig> getProperties() { throw new RuntimeException("Stub!"); }

/**
 * Returns the list of parent types of this schema for polymorphism.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<java.lang.String> getParentTypes() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param other This value may be {@code null}.
 */

public boolean equals(@android.annotation.Nullable java.lang.Object other) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

/** @hide */

public final int describeContents() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.app.appsearch.AppSearchSchema> CREATOR;
static { CREATOR = null; }
/** Configuration for a property containing a boolean. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class BooleanPropertyConfig extends android.app.appsearch.AppSearchSchema.PropertyConfig {

BooleanPropertyConfig() { throw new RuntimeException("Stub!"); }
/** Builder for {@link android.app.appsearch.AppSearchSchema.BooleanPropertyConfig BooleanPropertyConfig}. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/**
 * Creates a new {@link android.app.appsearch.AppSearchSchema.BooleanPropertyConfig.Builder BooleanPropertyConfig.Builder}.
 * @param propertyName This value cannot be {@code null}.
 */

public Builder(@android.annotation.NonNull java.lang.String propertyName) { throw new RuntimeException("Stub!"); }

/**
 * Sets the cardinality of the property (whether it is optional, required or repeated).
 *
 * <p>If this method is not called, the default cardinality is {@link android.app.appsearch.AppSearchSchema.PropertyConfig#CARDINALITY_OPTIONAL  }.
 
 * @param cardinality Value is {@link android.app.appsearch.AppSearchSchema.PropertyConfig#CARDINALITY_REPEATED}, {@link android.app.appsearch.AppSearchSchema.PropertyConfig#CARDINALITY_OPTIONAL}, or {@link android.app.appsearch.AppSearchSchema.PropertyConfig#CARDINALITY_REQUIRED}
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.AppSearchSchema.BooleanPropertyConfig.Builder setCardinality(int cardinality) { throw new RuntimeException("Stub!"); }

/**
 * Constructs a new {@link android.app.appsearch.AppSearchSchema.BooleanPropertyConfig BooleanPropertyConfig} from the contents of this builder.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.AppSearchSchema.BooleanPropertyConfig build() { throw new RuntimeException("Stub!"); }
}

}

/** Builder for {@link android.app.appsearch.AppSearchSchema objects}. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/**
 * Creates a new {@link android.app.appsearch.AppSearchSchema.Builder AppSearchSchema.Builder}.
 * @param schemaType This value cannot be {@code null}.
 */

public Builder(@android.annotation.NonNull java.lang.String schemaType) { throw new RuntimeException("Stub!"); }

/**
 * Adds a property to the given type.
 * @param propertyConfig This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.AppSearchSchema.Builder addProperty(@android.annotation.NonNull android.app.appsearch.AppSearchSchema.PropertyConfig propertyConfig) { throw new RuntimeException("Stub!"); }

/**
 * Adds a parent type to the given type for polymorphism, so that the given type will be
 * considered as a subtype of {@code parentSchemaType}.
 *
 * <p>Subtype relations are automatically considered transitive, so callers are only
 * required to provide direct parents. Specifically, if T1 &lt;: T2 and T2 &lt;: T3 are
 * known, then T1 &lt;: T3 will be inferred automatically, where &lt;: is the subtype
 * symbol.
 *
 * <p>Polymorphism is currently supported in the following ways:
 *
 * <ul>
 *   <li>Search filters on a parent type will automatically be extended to the child types
 *       as well. For example, if Artist &lt;: Person, then a search with a filter on type
 *       Person (by calling {@link android.app.appsearch.SearchSpec.Builder#addFilterSchemas SearchSpec.Builder#addFilterSchemas}) will also include
 *       documents of type Artist in the search result.
 *   <li>In the projection API, the property paths to project specified for a parent type
 *       will automatically be extended to the child types as well. If both a parent type
 *       and one of its child type are specified in the projection API, the parent type's
 *       paths will be merged into the child's. For more details on projection, see {@link android.app.appsearch.SearchSpec.Builder#addProjection        }.
 *   <li>A document property defined as type U is allowed to be set with a document of type
 *       T, as long as T &lt;: U, but note that index will only be based on the defined
 *       type, which is U. For example, consider a document of type "Company" with a
 *       repeated "employees" field of type "Person". We can add employees of either type
 *       "Person" or type "Artist" or both to this property, as long as "Artist" is a
 *       subtype of "Person". However, the index of the "employees" property will be based
 *       on what's defined in "Person", even for an added document of type "Artist".
 * </ul>
 *
 * <p>Subtypes must meet the following requirements. A violation of the requirements will
 * cause {@link android.app.appsearch.AppSearchSession#setSchema AppSearchSession#setSchema} to throw an {@link android.app.appsearch.exceptions.AppSearchException AppSearchException} with the
 * result code of {@link android.app.appsearch.AppSearchResult#RESULT_INVALID_ARGUMENT AppSearchResult#RESULT_INVALID_ARGUMENT}. Consider a type Artist
 * and a type Person, and Artist claims to be a subtype of Person, then:
 *
 * <ul>
 *   <li>Every property in Person must have a corresponding property in Artist with the same
 *       name.
 *   <li>Every non-document property in Person must have the same type as the type of the
 *       corresponding property in Artist. For example, if "age" is an integer property in
 *       Person, then "age" must also be an integer property in Artist, instead of a string.
 *   <li>The schema type of every document property in Artist must be a subtype of the
 *       schema type of the corresponding document property in Person, if such a property
 *       exists in Person. For example, if "awards" is a document property of type Award in
 *       Person, then the type of the "awards" property in Artist must be a subtype of
 *       Award, say ArtAward. Note that every type is a subtype of itself.
 *   <li>Every property in Artist must have a cardinality stricter than or equal to the
 *       cardinality of the corresponding property in Person, if such a property exists in
 *       Person. For example, if "awards" is a property in Person of cardinality OPTIONAL,
 *       then the cardinality of the "awards" property in Artist can only be REQUIRED or
 *       OPTIONAL. Rule: REQUIRED &lt; OPTIONAL &lt; REPEATED.
 *   <li>There are no other enforcements on the corresponding properties in Artist, such as
 *       index type, tokenizer type, etc. These settings can be safely overridden.
 * </ul>
 *
 * <p>A type can be defined to have multiple parents, but it must be compatible with each of
 * its parents based on the above rules. For example, if LocalBusiness is defined as a
 * subtype of both Place and Organization, then the compatibility of LocalBusiness with
 * Place and the compatibility of LocalBusiness with Organization will both be checked.
 
 * @param parentSchemaType This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.AppSearchSchema.Builder addParentType(@android.annotation.NonNull java.lang.String parentSchemaType) { throw new RuntimeException("Stub!"); }

/**
 * Constructs a new {@link android.app.appsearch.AppSearchSchema AppSearchSchema} from the contents of this builder.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.AppSearchSchema build() { throw new RuntimeException("Stub!"); }
}

/** Configuration for a property containing a byte array. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class BytesPropertyConfig extends android.app.appsearch.AppSearchSchema.PropertyConfig {

BytesPropertyConfig() { throw new RuntimeException("Stub!"); }
/** Builder for {@link android.app.appsearch.AppSearchSchema.BytesPropertyConfig BytesPropertyConfig}. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/**
 * Creates a new {@link android.app.appsearch.AppSearchSchema.BytesPropertyConfig.Builder BytesPropertyConfig.Builder}.
 * @param propertyName This value cannot be {@code null}.
 */

public Builder(@android.annotation.NonNull java.lang.String propertyName) { throw new RuntimeException("Stub!"); }

/**
 * Sets the cardinality of the property (whether it is optional, required or repeated).
 *
 * <p>If this method is not called, the default cardinality is {@link android.app.appsearch.AppSearchSchema.PropertyConfig#CARDINALITY_OPTIONAL  }.
 
 * @param cardinality Value is {@link android.app.appsearch.AppSearchSchema.PropertyConfig#CARDINALITY_REPEATED}, {@link android.app.appsearch.AppSearchSchema.PropertyConfig#CARDINALITY_OPTIONAL}, or {@link android.app.appsearch.AppSearchSchema.PropertyConfig#CARDINALITY_REQUIRED}
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.AppSearchSchema.BytesPropertyConfig.Builder setCardinality(int cardinality) { throw new RuntimeException("Stub!"); }

/**
 * Constructs a new {@link android.app.appsearch.AppSearchSchema.BytesPropertyConfig BytesPropertyConfig} from the contents of this builder.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.AppSearchSchema.BytesPropertyConfig build() { throw new RuntimeException("Stub!"); }
}

}

/** Configuration for a property containing another Document. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class DocumentPropertyConfig extends android.app.appsearch.AppSearchSchema.PropertyConfig {

DocumentPropertyConfig() { throw new RuntimeException("Stub!"); }

/**
 * Returns the logical schema-type of the contents of this document property.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String getSchemaType() { throw new RuntimeException("Stub!"); }

/**
 * Returns whether properties in the nested document should be indexed according to that
 * document's schema.
 *
 * <p>If false, the nested document's properties are not indexed regardless of its own
 * schema.
 *
 * @see android.app.appsearch.AppSearchSchema.DocumentPropertyConfig.Builder#addIndexableNestedProperties(Collection) for indexing
 *     a subset of properties from the nested document.
 */

public boolean shouldIndexNestedProperties() { throw new RuntimeException("Stub!"); }

/**
 * Returns the list of indexable nested properties for the nested document.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<java.lang.String> getIndexableNestedProperties() { throw new RuntimeException("Stub!"); }
/** Builder for {@link android.app.appsearch.AppSearchSchema.DocumentPropertyConfig DocumentPropertyConfig}. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/**
 * Creates a new {@link android.app.appsearch.AppSearchSchema.DocumentPropertyConfig.Builder DocumentPropertyConfig.Builder}.
 *
 * @param propertyName The logical name of the property in the schema, which will be
 *     used as the key for this property in {@link android.app.appsearch.GenericDocument.Builder#setPropertyDocument      }.
 * This value cannot be {@code null}.
 * @param schemaType The type of documents which will be stored in this property.
 *     Documents of different types cannot be mixed into a single property.

 * This value cannot be {@code null}.
 */

public Builder(@android.annotation.NonNull java.lang.String propertyName, @android.annotation.NonNull java.lang.String schemaType) { throw new RuntimeException("Stub!"); }

/**
 * Sets the cardinality of the property (whether it is optional, required or repeated).
 *
 * <p>If this method is not called, the default cardinality is {@link android.app.appsearch.AppSearchSchema.PropertyConfig#CARDINALITY_OPTIONAL  }.
 
 * @param cardinality Value is {@link android.app.appsearch.AppSearchSchema.PropertyConfig#CARDINALITY_REPEATED}, {@link android.app.appsearch.AppSearchSchema.PropertyConfig#CARDINALITY_OPTIONAL}, or {@link android.app.appsearch.AppSearchSchema.PropertyConfig#CARDINALITY_REQUIRED}
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.AppSearchSchema.DocumentPropertyConfig.Builder setCardinality(int cardinality) { throw new RuntimeException("Stub!"); }

/**
 * Configures whether properties in the nested document should be indexed according to
 * that document's schema.
 *
 * <p>If false, the nested document's properties are not indexed regardless of its own
 * schema.
 *
 * <p>To index a subset of properties from the nested document, set this to false and
 * use {@link #addIndexableNestedProperties(java.util.Collection)}.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.AppSearchSchema.DocumentPropertyConfig.Builder setShouldIndexNestedProperties(boolean indexNestedProperties) { throw new RuntimeException("Stub!"); }

/**
 * Adds one or more properties for indexing from the nested document property.
 *
 * @see #addIndexableNestedProperties(Collection)
 
 * @param indexableNestedProperties This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.AppSearchSchema.DocumentPropertyConfig.Builder addIndexableNestedProperties(@android.annotation.NonNull java.lang.String... indexableNestedProperties) { throw new RuntimeException("Stub!"); }

/**
 * Adds one or more property paths for indexing from the nested document property.
 *
 * @see #addIndexableNestedProperties(Collection)
 
 * @param indexableNestedPropertyPaths This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.AppSearchSchema.DocumentPropertyConfig.Builder addIndexableNestedPropertyPaths(@android.annotation.NonNull android.app.appsearch.PropertyPath... indexableNestedPropertyPaths) { throw new RuntimeException("Stub!"); }

/**
 * Adds one or more properties for indexing from the nested document. The added property
 * will be indexed according to that property's indexing configurations in the
 * document's schema definition. All properties in this list will consume a sectionId
 * regardless of its actual indexing config -- this includes properties added that do
 * not actually exist, as well as properties that are not set as indexable in the nested
 * schema type.
 *
 * <p>Input strings should follow the format of the property path for the nested
 * property, with '.' as the path separator. This nested document's property name should
 * not be included in the property path.
 *
 * <p>Ex. Consider an 'Organization' schema type which defines a nested document
 * property 'address' (Address schema type), where Address has a nested document
 * property 'country' (Country schema type with string 'name' property), and a string
 * 'street' property. The 'street' and 'country's name' properties from the 'address'
 * document property can be indexed for the 'Organization' schema type by calling:
 *
 * <pre>{@code
 * OrganizationSchema.addProperty(
 *                 new DocumentPropertyConfig.Builder("address", "Address")
 *                         .addIndexableNestedProperties("street", "country.name")
 *                         .build()).
 * }</pre>
 *
 * <p>{@link DocumentPropertyConfig.Builder#setShouldIndexNestedProperties} is required
 * to be false if any indexable nested property is added this way for the document
 * property. Attempting to build a DocumentPropertyConfig when this is not true throws
 * {@link java.lang.IllegalArgumentException IllegalArgumentException}.
 
 * @param indexableNestedProperties This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.AppSearchSchema.DocumentPropertyConfig.Builder addIndexableNestedProperties(@android.annotation.NonNull java.util.Collection<java.lang.String> indexableNestedProperties) { throw new RuntimeException("Stub!"); }

/**
 * Adds one or more property paths for indexing from the nested document property.
 *
 * @see #addIndexableNestedProperties(Collection)
 
 * @param indexableNestedPropertyPaths This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.AppSearchSchema.DocumentPropertyConfig.Builder addIndexableNestedPropertyPaths(@android.annotation.NonNull java.util.Collection<android.app.appsearch.PropertyPath> indexableNestedPropertyPaths) { throw new RuntimeException("Stub!"); }

/**
 * Constructs a new {@link android.app.appsearch.AppSearchSchema.PropertyConfig PropertyConfig} from the contents of this builder.
 *
 * @throws java.lang.IllegalArgumentException if the provided PropertyConfig sets {@link
 *     #shouldIndexNestedProperties()} to true and has one or more properties defined
 *     using {@link #addIndexableNestedProperties(java.util.Collection)}.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.AppSearchSchema.DocumentPropertyConfig build() { throw new RuntimeException("Stub!"); }
}

}

/** Configuration for a property containing a double-precision decimal number. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class DoublePropertyConfig extends android.app.appsearch.AppSearchSchema.PropertyConfig {

DoublePropertyConfig() { throw new RuntimeException("Stub!"); }
/** Builder for {@link android.app.appsearch.AppSearchSchema.DoublePropertyConfig DoublePropertyConfig}. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/**
 * Creates a new {@link android.app.appsearch.AppSearchSchema.DoublePropertyConfig.Builder DoublePropertyConfig.Builder}.
 * @param propertyName This value cannot be {@code null}.
 */

public Builder(@android.annotation.NonNull java.lang.String propertyName) { throw new RuntimeException("Stub!"); }

/**
 * Sets the cardinality of the property (whether it is optional, required or repeated).
 *
 * <p>If this method is not called, the default cardinality is {@link android.app.appsearch.AppSearchSchema.PropertyConfig#CARDINALITY_OPTIONAL  }.
 
 * @param cardinality Value is {@link android.app.appsearch.AppSearchSchema.PropertyConfig#CARDINALITY_REPEATED}, {@link android.app.appsearch.AppSearchSchema.PropertyConfig#CARDINALITY_OPTIONAL}, or {@link android.app.appsearch.AppSearchSchema.PropertyConfig#CARDINALITY_REQUIRED}
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.AppSearchSchema.DoublePropertyConfig.Builder setCardinality(int cardinality) { throw new RuntimeException("Stub!"); }

/**
 * Constructs a new {@link android.app.appsearch.AppSearchSchema.DoublePropertyConfig DoublePropertyConfig} from the contents of this builder.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.AppSearchSchema.DoublePropertyConfig build() { throw new RuntimeException("Stub!"); }
}

}

/** Configuration for a property containing a 64-bit integer. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class LongPropertyConfig extends android.app.appsearch.AppSearchSchema.PropertyConfig {

LongPropertyConfig() { throw new RuntimeException("Stub!"); }

/**
 * Returns how the property is indexed.
 * @return Value is {@link android.app.appsearch.AppSearchSchema.LongPropertyConfig#INDEXING_TYPE_NONE}, or {@link android.app.appsearch.AppSearchSchema.LongPropertyConfig#INDEXING_TYPE_RANGE}
 */

public int getIndexingType() { throw new RuntimeException("Stub!"); }

/** Content in this property will not be indexed. */

public static final int INDEXING_TYPE_NONE = 0; // 0x0

/**
 * Content in this property will be indexed and can be fetched via numeric search range
 * query.
 *
 * <p>For example, a property with 1024 should match numeric search range query [0, 2000].
 */

public static final int INDEXING_TYPE_RANGE = 1; // 0x1
/** Builder for {@link android.app.appsearch.AppSearchSchema.LongPropertyConfig LongPropertyConfig}. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/**
 * Creates a new {@link android.app.appsearch.AppSearchSchema.LongPropertyConfig.Builder LongPropertyConfig.Builder}.
 * @param propertyName This value cannot be {@code null}.
 */

public Builder(@android.annotation.NonNull java.lang.String propertyName) { throw new RuntimeException("Stub!"); }

/**
 * Sets the cardinality of the property (whether it is optional, required or repeated).
 *
 * <p>If this method is not called, the default cardinality is {@link android.app.appsearch.AppSearchSchema.PropertyConfig#CARDINALITY_OPTIONAL  }.
 
 * @param cardinality Value is {@link android.app.appsearch.AppSearchSchema.PropertyConfig#CARDINALITY_REPEATED}, {@link android.app.appsearch.AppSearchSchema.PropertyConfig#CARDINALITY_OPTIONAL}, or {@link android.app.appsearch.AppSearchSchema.PropertyConfig#CARDINALITY_REQUIRED}
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.AppSearchSchema.LongPropertyConfig.Builder setCardinality(int cardinality) { throw new RuntimeException("Stub!"); }

/**
 * Configures how a property should be indexed so that it can be retrieved by queries.
 *
 * <p>If this method is not called, the default indexing type is {@link android.app.appsearch.AppSearchSchema.LongPropertyConfig#INDEXING_TYPE_NONE  }, so that it will not be indexed and cannot be
 * matched by queries.
 
 * @param indexingType Value is {@link android.app.appsearch.AppSearchSchema.LongPropertyConfig#INDEXING_TYPE_NONE}, or {@link android.app.appsearch.AppSearchSchema.LongPropertyConfig#INDEXING_TYPE_RANGE}
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.AppSearchSchema.LongPropertyConfig.Builder setIndexingType(int indexingType) { throw new RuntimeException("Stub!"); }

/**
 * Constructs a new {@link android.app.appsearch.AppSearchSchema.LongPropertyConfig LongPropertyConfig} from the contents of this builder.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.AppSearchSchema.LongPropertyConfig build() { throw new RuntimeException("Stub!"); }
}

}

/**
 * Common configuration for a single property (field) in a Document.
 *
 * <p>For example, an {@code EmailMessage} would be a type and the {@code subject} would be a
 * property.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract static class PropertyConfig {

PropertyConfig() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/**
 * Returns the name of this property.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String getName() { throw new RuntimeException("Stub!"); }

/**
 * Returns the cardinality of the property (whether it is optional, required or repeated).

 * @return Value is {@link android.app.appsearch.AppSearchSchema.PropertyConfig#CARDINALITY_REPEATED}, {@link android.app.appsearch.AppSearchSchema.PropertyConfig#CARDINALITY_OPTIONAL}, or {@link android.app.appsearch.AppSearchSchema.PropertyConfig#CARDINALITY_REQUIRED}
 */

public int getCardinality() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param other This value may be {@code null}.
 */

public boolean equals(@android.annotation.Nullable java.lang.Object other) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

/** Zero or one value [0,1]. */

public static final int CARDINALITY_OPTIONAL = 2; // 0x2

/** Any number of items (including zero) [0...*]. */

public static final int CARDINALITY_REPEATED = 1; // 0x1

/** Exactly one value [1]. */

public static final int CARDINALITY_REQUIRED = 3; // 0x3
}

/** Configuration for a property of type String in a Document. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class StringPropertyConfig extends android.app.appsearch.AppSearchSchema.PropertyConfig {

StringPropertyConfig() { throw new RuntimeException("Stub!"); }

/**
 * Returns how the property is indexed.
 * @return Value is {@link android.app.appsearch.AppSearchSchema.StringPropertyConfig#INDEXING_TYPE_NONE}, {@link android.app.appsearch.AppSearchSchema.StringPropertyConfig#INDEXING_TYPE_EXACT_TERMS}, or {@link android.app.appsearch.AppSearchSchema.StringPropertyConfig#INDEXING_TYPE_PREFIXES}
 */

public int getIndexingType() { throw new RuntimeException("Stub!"); }

/**
 * Returns how this property is tokenized (split into words).
 * @return Value is {@link android.app.appsearch.AppSearchSchema.StringPropertyConfig#TOKENIZER_TYPE_NONE}, {@link android.app.appsearch.AppSearchSchema.StringPropertyConfig#TOKENIZER_TYPE_PLAIN}, {@link android.app.appsearch.AppSearchSchema.StringPropertyConfig#TOKENIZER_TYPE_VERBATIM}, or {@link android.app.appsearch.AppSearchSchema.StringPropertyConfig#TOKENIZER_TYPE_RFC822}
 */

public int getTokenizerType() { throw new RuntimeException("Stub!"); }

/**
 * Returns how this property is going to be used to join documents from other schema types.

 * @return Value is {@link android.app.appsearch.AppSearchSchema.StringPropertyConfig#JOINABLE_VALUE_TYPE_NONE}, or {@link android.app.appsearch.AppSearchSchema.StringPropertyConfig#JOINABLE_VALUE_TYPE_QUALIFIED_ID}
 */

public int getJoinableValueType() { throw new RuntimeException("Stub!"); }

/**
 * Content in this property should only be returned for queries matching the exact tokens
 * appearing in this property.
 *
 * <p>For example, a property with "fool" should NOT match a query for "foo".
 */

public static final int INDEXING_TYPE_EXACT_TERMS = 1; // 0x1

/** Content in this property will not be tokenized or indexed. */

public static final int INDEXING_TYPE_NONE = 0; // 0x0

/**
 * Content in this property should be returned for queries that are either exact matches or
 * query matches of the tokens appearing in this property.
 *
 * <p>For example, a property with "fool" <b>should</b> match a query for "foo".
 */

public static final int INDEXING_TYPE_PREFIXES = 2; // 0x2

/** Content in this property is not joinable. */

public static final int JOINABLE_VALUE_TYPE_NONE = 0; // 0x0

/**
 * Content in this string property will be used as a qualified id to join documents.
 *
 * <ul>
 *   <li>Qualified id: a unique identifier for a document, and this joinable value type is
 *       similar to primary and foreign key in relational database. See {@link
 *       android.app.appsearch.util.DocumentIdUtil} for more details.
 *   <li>Currently we only support single string joining, so it should only be used with
 *       {@link android.app.appsearch.AppSearchSchema.PropertyConfig#CARDINALITY_OPTIONAL PropertyConfig#CARDINALITY_OPTIONAL} and {@link android.app.appsearch.AppSearchSchema.PropertyConfig#CARDINALITY_REQUIRED        }.
 * </ul>
 */

public static final int JOINABLE_VALUE_TYPE_QUALIFIED_ID = 1; // 0x1

/**
 * This value indicates that no tokens should be extracted from this property.
 *
 * <p>It is only valid for tokenizer_type to be 'NONE' if {@link #getIndexingType} is {@link
 * #INDEXING_TYPE_NONE}.
 */

public static final int TOKENIZER_TYPE_NONE = 0; // 0x0

/**
 * Tokenization for plain text. This value indicates that tokens should be extracted from
 * this property based on word breaks. Segments of whitespace and punctuation are not
 * considered tokens.
 *
 * <p>For example, a property with "foo bar. baz." will produce tokens for "foo", "bar" and
 * "baz". The segments " " and "." will not be considered tokens.
 *
 * <p>It is only valid for tokenizer_type to be 'PLAIN' if {@link #getIndexingType} is
 * {@link #INDEXING_TYPE_EXACT_TERMS} or {@link #INDEXING_TYPE_PREFIXES}.
 */

public static final int TOKENIZER_TYPE_PLAIN = 1; // 0x1

/**
 * Tokenization for emails. This value indicates that tokens should be extracted from this
 * property based on email structure.
 *
 * <p>For example, a property with "alex.sav@google.com" will produce tokens for "alex",
 * "sav", "alex.sav", "google", "com", and "alexsav@google.com"
 *
 * <p>It is only valid for tokenizer_type to be 'RFC822' if {@link #getIndexingType} is
 * {@link #INDEXING_TYPE_EXACT_TERMS} or {@link #INDEXING_TYPE_PREFIXES}.
 */

public static final int TOKENIZER_TYPE_RFC822 = 3; // 0x3

/**
 * This value indicates that no normalization or segmentation should be applied to string
 * values that are tokenized using this type. Therefore, the output token is equivalent to
 * the raw string value.
 *
 * <p>For example, a property with "Hello, world!" will produce the token "Hello, world!",
 * preserving punctuation and capitalization, and not creating separate tokens between the
 * space.
 *
 * <p>It is only valid for tokenizer_type to be 'VERBATIM' if {@link #getIndexingType} is
 * {@link #INDEXING_TYPE_EXACT_TERMS} or {@link #INDEXING_TYPE_PREFIXES}.
 */

public static final int TOKENIZER_TYPE_VERBATIM = 2; // 0x2
/** Builder for {@link android.app.appsearch.AppSearchSchema.StringPropertyConfig StringPropertyConfig}. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/**
 * Creates a new {@link android.app.appsearch.AppSearchSchema.StringPropertyConfig.Builder StringPropertyConfig.Builder}.
 * @param propertyName This value cannot be {@code null}.
 */

public Builder(@android.annotation.NonNull java.lang.String propertyName) { throw new RuntimeException("Stub!"); }

/**
 * Sets the cardinality of the property (whether it is optional, required or repeated).
 *
 * <p>If this method is not called, the default cardinality is {@link android.app.appsearch.AppSearchSchema.PropertyConfig#CARDINALITY_OPTIONAL  }.
 
 * @param cardinality Value is {@link android.app.appsearch.AppSearchSchema.PropertyConfig#CARDINALITY_REPEATED}, {@link android.app.appsearch.AppSearchSchema.PropertyConfig#CARDINALITY_OPTIONAL}, or {@link android.app.appsearch.AppSearchSchema.PropertyConfig#CARDINALITY_REQUIRED}
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.AppSearchSchema.StringPropertyConfig.Builder setCardinality(int cardinality) { throw new RuntimeException("Stub!"); }

/**
 * Configures how a property should be indexed so that it can be retrieved by queries.
 *
 * <p>If this method is not called, the default indexing type is {@link android.app.appsearch.AppSearchSchema.StringPropertyConfig#INDEXING_TYPE_NONE  }, so that it cannot be matched by queries.
 
 * @param indexingType Value is {@link android.app.appsearch.AppSearchSchema.StringPropertyConfig#INDEXING_TYPE_NONE}, {@link android.app.appsearch.AppSearchSchema.StringPropertyConfig#INDEXING_TYPE_EXACT_TERMS}, or {@link android.app.appsearch.AppSearchSchema.StringPropertyConfig#INDEXING_TYPE_PREFIXES}
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.AppSearchSchema.StringPropertyConfig.Builder setIndexingType(int indexingType) { throw new RuntimeException("Stub!"); }

/**
 * Configures how this property should be tokenized (split into words).
 *
 * <p>If this method is not called, the default indexing type is {@link android.app.appsearch.AppSearchSchema.StringPropertyConfig#TOKENIZER_TYPE_NONE  }, so that it is not tokenized.
 *
 * <p>This method must be called with a value other than {@link android.app.appsearch.AppSearchSchema.StringPropertyConfig#TOKENIZER_TYPE_NONE  } if the property is indexed (that is, if
 * {@link #setIndexingType} has been called with a value other than {@link android.app.appsearch.AppSearchSchema.StringPropertyConfig#INDEXING_TYPE_NONE  }).
 
 * @param tokenizerType Value is {@link android.app.appsearch.AppSearchSchema.StringPropertyConfig#TOKENIZER_TYPE_NONE}, {@link android.app.appsearch.AppSearchSchema.StringPropertyConfig#TOKENIZER_TYPE_PLAIN}, {@link android.app.appsearch.AppSearchSchema.StringPropertyConfig#TOKENIZER_TYPE_VERBATIM}, or {@link android.app.appsearch.AppSearchSchema.StringPropertyConfig#TOKENIZER_TYPE_RFC822}
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.AppSearchSchema.StringPropertyConfig.Builder setTokenizerType(int tokenizerType) { throw new RuntimeException("Stub!"); }

/**
 * Configures how this property should be used as a joining matcher.
 *
 * <p>If this method is not called, the default joinable value type is {@link android.app.appsearch.AppSearchSchema.StringPropertyConfig#JOINABLE_VALUE_TYPE_NONE  }, so that it is not joinable.
 *
 * <p>At most, 64 properties can be set as joinable per schema.
 
 * @param joinableValueType Value is {@link android.app.appsearch.AppSearchSchema.StringPropertyConfig#JOINABLE_VALUE_TYPE_NONE}, or {@link android.app.appsearch.AppSearchSchema.StringPropertyConfig#JOINABLE_VALUE_TYPE_QUALIFIED_ID}
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.AppSearchSchema.StringPropertyConfig.Builder setJoinableValueType(int joinableValueType) { throw new RuntimeException("Stub!"); }

/**
 * Constructs a new {@link android.app.appsearch.AppSearchSchema.StringPropertyConfig StringPropertyConfig} from the contents of this builder.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.AppSearchSchema.StringPropertyConfig build() { throw new RuntimeException("Stub!"); }
}

}

}

