/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.app.appsearch;

import java.util.List;

/**
 * Represents a property path returned from searching the AppSearch Database.
 *
 * <p>One of the use cases for this class is when searching the AppSearch Database for the snippet
 * matching use case. In this case you will get back {@link android.app.appsearch.SearchResult.MatchInfo SearchResult.MatchInfo} objects that
 * contain a property path signifying the location of a match within the database. This is a string
 * that may look something like "foo.bar[0]". {@link android.app.appsearch.PropertyPath PropertyPath} parses this string and breaks it
 * up into a List of {@link android.app.appsearch.PropertyPath.PathSegment PathSegment}s. These may represent either a property or a property and a
 * 0-based index into the property. For instance, "foo.bar[1]" would be parsed into a {@link android.app.appsearch.PropertyPath.PathSegment PathSegment} with a property name of foo and a {@link android.app.appsearch.PropertyPath.PathSegment PathSegment} with a property name of bar
 * and an index of 1. This allows for easier manipulation of the property path.
 *
 * <p>This class won't perform any retrievals, it will only parse the path string. As such, it may
 * not necessarily refer to a valid path in the database.
 *
 * @see android.app.appsearch.SearchResult.MatchInfo
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class PropertyPath implements java.lang.Iterable<android.app.appsearch.PropertyPath.PathSegment> {

/**
 * Constructor directly accepting a path list
 *
 * @param pathList a list of PathSegments

 * This value cannot be {@code null}.
 */

public PropertyPath(@android.annotation.NonNull java.util.List<android.app.appsearch.PropertyPath.PathSegment> pathList) { throw new RuntimeException("Stub!"); }

/**
 * Constructor that parses a string representing the path to populate a List of PathSegments
 *
 * @param path the string to be validated and parsed into PathSegments
 * This value cannot be {@code null}.
 * @throws java.lang.IllegalArgumentException when the path is invalid or malformed
 */

public PropertyPath(@android.annotation.NonNull java.lang.String path) { throw new RuntimeException("Stub!"); }

/**
 * Returns the {@link android.app.appsearch.PropertyPath.PathSegment PathSegment} at a specified index of the PropertyPath.
 *
 * <p>Calling {@code get(1)} on a {@link android.app.appsearch.PropertyPath PropertyPath} representing "foo.bar[1]" will return a
 * {@link android.app.appsearch.PropertyPath.PathSegment PathSegment} representing "bar[1]". {@link android.app.appsearch.PropertyPath.PathSegment PathSegment}s both with and without a
 * property index of {@link android.app.appsearch.PropertyPath.PathSegment#NON_REPEATED_CARDINALITY PathSegment#NON_REPEATED_CARDINALITY} are retrieved the same.
 *
 * @param index the position into the PropertyPath
 * @throws java.lang.ArrayIndexOutOfBoundsException if index is not a valid index in the path list

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.PropertyPath.PathSegment get(int index) { throw new RuntimeException("Stub!"); }

/**
 * Returns the number of {@link android.app.appsearch.PropertyPath.PathSegment PathSegment}s in the PropertyPath.
 *
 * <p>Paths representing "foo.bar" and "foo[1].bar[1]" will have the same size, as a property
 * and an index into that property are stored in one {@link android.app.appsearch.PropertyPath.PathSegment PathSegment}.
 */

public int size() { throw new RuntimeException("Stub!"); }

/**
 * Returns a valid path string representing this PropertyPath
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/**
 * Returns an iterator over the PathSegments within the PropertyPath
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.Iterator<android.app.appsearch.PropertyPath.PathSegment> iterator() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param o This value may be {@code null}.
 */

public boolean equals(@android.annotation.Nullable java.lang.Object o) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }
/**
 * A segment of a PropertyPath, which includes the name of the property and a 0-based index into
 * this property.
 *
 * <p>If the property index is not set to {@link #NON_REPEATED_CARDINALITY}, this represents a
 * schema property with the "repeated" cardinality, or a path like "foo[1]". Otherwise, this
 * represents a schema property that could have any cardinality, or a path like "foo".
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class PathSegment {

PathSegment() { throw new RuntimeException("Stub!"); }

/**
 * Creation method that accepts and validates both a property name and the index into the
 * property.
 *
 * <p>The property name may not be blank. It also may not contain square brackets or dots,
 * as they are control characters in property paths. The index into the property may not be
 * negative, unless it is {@link #NON_REPEATED_CARDINALITY}, as these are invalid array
 * indices.
 *
 * @param propertyName the name of the property
 * This value cannot be {@code null}.
 * @param propertyIndex the index into the property
 * @return A new PathSegment
 * This value cannot be {@code null}.
 * @throws java.lang.IllegalArgumentException if the property name or index is invalid.
 */

@android.annotation.NonNull
public static android.app.appsearch.PropertyPath.PathSegment create(@android.annotation.NonNull java.lang.String propertyName, int propertyIndex) { throw new RuntimeException("Stub!"); }

/**
 * Creation method that accepts and validates a property name
 *
 * <p>The property index is set to {@link #NON_REPEATED_CARDINALITY}
 *
 * @param propertyName the name of the property
 * This value cannot be {@code null}.
 * @return A new PathSegment
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public static android.app.appsearch.PropertyPath.PathSegment create(@android.annotation.NonNull java.lang.String propertyName) { throw new RuntimeException("Stub!"); }

/**
 * @return the property name

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String getPropertyName() { throw new RuntimeException("Stub!"); }

/**
 * Returns the index into the property, or {@link #NON_REPEATED_CARDINALITY} if this does
 * not represent a PathSegment with an index.
 */

public int getPropertyIndex() { throw new RuntimeException("Stub!"); }

/**
 * Returns a path representing a PathSegment, either "foo" or "foo[1]"
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param o This value may be {@code null}.
 */

public boolean equals(@android.annotation.Nullable java.lang.Object o) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

/**
 * A marker variable to signify that a PathSegment represents a schema property that isn't
 * indexed into. The value is chosen to be invalid if used as an array index.
 */

public static final int NON_REPEATED_CARDINALITY = -1; // 0xffffffff
}

}

