/*
 * Copyright 2020 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.app.appsearch;


/**
 * Encapsulates a request to remove documents by namespace and IDs from the {@link android.app.appsearch.AppSearchSession AppSearchSession}
 * database.
 *
 * @see AppSearchSession#remove
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class RemoveByDocumentIdRequest implements android.os.Parcelable {

RemoveByDocumentIdRequest() { throw new RuntimeException("Stub!"); }

/**
 * Returns the namespace to remove documents from.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String getNamespace() { throw new RuntimeException("Stub!"); }

/**
 * Returns the set of document IDs attached to the request.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.Set<java.lang.String> getIds() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

/** @hide */

public final int describeContents() { throw new RuntimeException("Stub!"); }

/** Creator class for {@link android.app.appsearch.RemoveByDocumentIdRequest}. */

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.app.appsearch.RemoveByDocumentIdRequest> CREATOR;
static { CREATOR = null; }
/** Builder for {@link android.app.appsearch.RemoveByDocumentIdRequest RemoveByDocumentIdRequest} objects. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/**
 * Creates a {@link android.app.appsearch.RemoveByDocumentIdRequest.Builder RemoveByDocumentIdRequest.Builder} instance.
 * @param namespace This value cannot be {@code null}.
 */

public Builder(@android.annotation.NonNull java.lang.String namespace) { throw new RuntimeException("Stub!"); }

/**
 * Adds one or more document IDs to the request.
 * @param ids This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.RemoveByDocumentIdRequest.Builder addIds(@android.annotation.NonNull java.lang.String... ids) { throw new RuntimeException("Stub!"); }

/**
 * Adds a collection of IDs to the request.
 * @param ids This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.RemoveByDocumentIdRequest.Builder addIds(@android.annotation.NonNull java.util.Collection<java.lang.String> ids) { throw new RuntimeException("Stub!"); }

/**
 * Builds a new {@link android.app.appsearch.RemoveByDocumentIdRequest RemoveByDocumentIdRequest}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.RemoveByDocumentIdRequest build() { throw new RuntimeException("Stub!"); }
}

}

