/*
 * Copyright (C) 2017 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.bluetooth;

import android.os.Parcel;

/**
 * Represents the codec status (configuration and capability) for a Bluetooth A2DP source device.
 *
 * @see android.bluetooth.BluetoothA2dp
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class BluetoothCodecStatus implements android.os.Parcelable {

BluetoothCodecStatus() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param o This value may be {@code null}.
 */

public boolean equals(@android.annotation.Nullable java.lang.Object o) { throw new RuntimeException("Stub!"); }

/**
 * Checks whether the codec config matches the selectable capabilities. Any parameters of the
 * codec config with NONE value will be considered a wildcard matching.
 *
 * @param codecConfig the codec config to compare against
 * This value may be {@code null}.
 * @return {@code true} if the codec config matches, {@code false} otherwise
 */

public boolean isCodecConfigSelectable(@android.annotation.Nullable android.bluetooth.BluetoothCodecConfig codecConfig) { throw new RuntimeException("Stub!"); }

/** Returns a hash based on the codec config and local capabilities. */

public int hashCode() { throw new RuntimeException("Stub!"); }

/**
 * Returns a {@link java.lang.String String} that describes each BluetoothCodecStatus parameter current value.
 */

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/**
 * @return 0
 * @hide
 */

public int describeContents() { throw new RuntimeException("Stub!"); }

/**
 * Flattens the object to a parcel.
 *
 * @param out The Parcel in which the object should be written
 * This value cannot be {@code null}.
 * @param flags Additional flags about how the object should be written
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel out, int flags) { throw new RuntimeException("Stub!"); }

/**
 * Returns the current codec configuration.
 * @return This value may be {@code null}.
 */

@android.annotation.Nullable
public android.bluetooth.BluetoothCodecConfig getCodecConfig() { throw new RuntimeException("Stub!"); }

/**
 * Returns the codecs local capabilities.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<android.bluetooth.BluetoothCodecConfig> getCodecsLocalCapabilities() { throw new RuntimeException("Stub!"); }

/**
 * Returns the codecs selectable capabilities.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<android.bluetooth.BluetoothCodecConfig> getCodecsSelectableCapabilities() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.bluetooth.BluetoothCodecStatus> CREATOR;
static { CREATOR = null; }

/**
 * Extra for the codec configuration intents of the individual profiles.
 *
 * <p>This extra represents the current codec status of the A2DP profile.
 */

public static final java.lang.String EXTRA_CODEC_STATUS = "android.bluetooth.extra.CODEC_STATUS";
/** Builder for {@link android.bluetooth.BluetoothCodecStatus BluetoothCodecStatus}. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * Set Bluetooth codec config for this codec status.
 *
 * @param codecConfig of this codec status
 * This value cannot be {@code null}.
 * @return the same Builder instance
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.bluetooth.BluetoothCodecStatus.Builder setCodecConfig(@android.annotation.NonNull android.bluetooth.BluetoothCodecConfig codecConfig) { throw new RuntimeException("Stub!"); }

/**
 * Set codec local capabilities list for this codec status.
 *
 * @param codecsLocalCapabilities of this codec status
 * This value cannot be {@code null}.
 * @return the same Builder instance
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.bluetooth.BluetoothCodecStatus.Builder setCodecsLocalCapabilities(@android.annotation.NonNull java.util.List<android.bluetooth.BluetoothCodecConfig> codecsLocalCapabilities) { throw new RuntimeException("Stub!"); }

/**
 * Set codec selectable capabilities list for this codec status.
 *
 * @param codecsSelectableCapabilities of this codec status
 * This value cannot be {@code null}.
 * @return the same Builder instance
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.bluetooth.BluetoothCodecStatus.Builder setCodecsSelectableCapabilities(@android.annotation.NonNull java.util.List<android.bluetooth.BluetoothCodecConfig> codecsSelectableCapabilities) { throw new RuntimeException("Stub!"); }

/**
 * Build {@link android.bluetooth.BluetoothCodecStatus BluetoothCodecStatus}.
 *
 * @return new BluetoothCodecStatus built

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.bluetooth.BluetoothCodecStatus build() { throw new RuntimeException("Stub!"); }
}

}

