/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.bluetooth;

import android.os.Parcel;
import android.os.Parcelable;

/**
 * Represents the codec status (configuration and capability) for a Bluetooth Le Audio source
 * device.
 *
 * @see android.bluetooth.BluetoothLeAudio
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class BluetoothLeAudioCodecStatus implements android.os.Parcelable {

/**
 * Represents the codec status for a Bluetooth LE Audio source device.
 *
 * @param inputCodecConfig the current input codec configuration.
 * This value may be {@code null}.
 * @param outputCodecConfig the current output codec configuration.
 * This value may be {@code null}.
 * @param inputCodecsLocalCapabilities the local input codecs capabilities.
 * This value cannot be {@code null}.
 * @param outputCodecsLocalCapabilities the local output codecs capabilities.
 * This value cannot be {@code null}.
 * @param inputCodecsSelectableCapabilities the selectable input codecs capabilities.
 * This value cannot be {@code null}.
 * @param outputCodecsSelectableCapabilities the selectable output codecs capabilities.

 * This value cannot be {@code null}.
 */

public BluetoothLeAudioCodecStatus(@android.annotation.Nullable android.bluetooth.BluetoothLeAudioCodecConfig inputCodecConfig, @android.annotation.Nullable android.bluetooth.BluetoothLeAudioCodecConfig outputCodecConfig, @android.annotation.NonNull java.util.List<android.bluetooth.BluetoothLeAudioCodecConfig> inputCodecsLocalCapabilities, @android.annotation.NonNull java.util.List<android.bluetooth.BluetoothLeAudioCodecConfig> outputCodecsLocalCapabilities, @android.annotation.NonNull java.util.List<android.bluetooth.BluetoothLeAudioCodecConfig> inputCodecsSelectableCapabilities, @android.annotation.NonNull java.util.List<android.bluetooth.BluetoothLeAudioCodecConfig> outputCodecsSelectableCapabilities) { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param o This value may be {@code null}.
 */

public boolean equals(@android.annotation.Nullable java.lang.Object o) { throw new RuntimeException("Stub!"); }

/**
 * Checks whether the Input codec config matches the selectable capabilities. Any parameters of
 * the codec config with NONE value will be considered a wildcard matching.
 *
 * @param codecConfig the codec config to compare against
 * This value may be {@code null}.
 * @return {@code true} if the codec config matches, {@code false} otherwise
 */

public boolean isInputCodecConfigSelectable(@android.annotation.Nullable android.bluetooth.BluetoothLeAudioCodecConfig codecConfig) { throw new RuntimeException("Stub!"); }

/**
 * Checks whether the Output codec config matches the selectable capabilities. Any parameters of
 * the codec config with NONE value will be considered a wildcard matching.
 *
 * @param codecConfig the codec config to compare against
 * This value may be {@code null}.
 * @return {@code true} if the codec config matches, {@code false} otherwise
 */

public boolean isOutputCodecConfigSelectable(@android.annotation.Nullable android.bluetooth.BluetoothLeAudioCodecConfig codecConfig) { throw new RuntimeException("Stub!"); }

/** Returns a hash based on the codec config and local capabilities. */

public int hashCode() { throw new RuntimeException("Stub!"); }

/**
 * Returns a {@link java.lang.String String} that describes each BluetoothLeAudioCodecStatus parameter current
 * value.
 */

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/**
 * @return 0
 */

public int describeContents() { throw new RuntimeException("Stub!"); }

/**
 * Flattens the object to a parcel.
 *
 * @param out The Parcel in which the object should be written
 * This value cannot be {@code null}.
 * @param flags Additional flags about how the object should be written
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel out, int flags) { throw new RuntimeException("Stub!"); }

/**
 * Returns the current Input codec configuration.
 *
 * @return The current input codec config.

 * This value may be {@code null}.
 */

@android.annotation.Nullable
public android.bluetooth.BluetoothLeAudioCodecConfig getInputCodecConfig() { throw new RuntimeException("Stub!"); }

/**
 * Returns the current Output codec configuration.
 *
 * @return The current output codec config.

 * This value may be {@code null}.
 */

@android.annotation.Nullable
public android.bluetooth.BluetoothLeAudioCodecConfig getOutputCodecConfig() { throw new RuntimeException("Stub!"); }

/**
 * Returns the input codecs local capabilities.
 *
 * @return The list of codec config that supported by the local system.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<android.bluetooth.BluetoothLeAudioCodecConfig> getInputCodecLocalCapabilities() { throw new RuntimeException("Stub!"); }

/**
 * Returns the output codecs local capabilities.
 *
 * @return The list of codec config that supported by the local system.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<android.bluetooth.BluetoothLeAudioCodecConfig> getOutputCodecLocalCapabilities() { throw new RuntimeException("Stub!"); }

/**
 * Returns the Input codecs selectable capabilities.
 *
 * @return The list of codec config that supported by both of the local system and remote
 *     devices.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<android.bluetooth.BluetoothLeAudioCodecConfig> getInputCodecSelectableCapabilities() { throw new RuntimeException("Stub!"); }

/**
 * Returns the Output codecs selectable capabilities.
 *
 * @return The list of codec config that supported by both of the local system and remote
 *     devices.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<android.bluetooth.BluetoothLeAudioCodecConfig> getOutputCodecSelectableCapabilities() { throw new RuntimeException("Stub!"); }

/** {@link android.os.Parcelable.Creator Parcelable.Creator} interface implementation. */

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.bluetooth.BluetoothLeAudioCodecStatus> CREATOR;
static { CREATOR = null; }

/**
 * Extra for the codec configuration intents of the individual profiles.
 *
 * <p>This extra represents the current codec status of the Le Audio profile.
 */

public static final java.lang.String EXTRA_LE_AUDIO_CODEC_STATUS = "android.bluetooth.extra.LE_AUDIO_CODEC_STATUS";
}

