/*
 * Copyright (C) 2021 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.bluetooth;


/**
 * A class with constants representing possible return values for Bluetooth APIs. General return
 * values occupy the range 0 to 199. Profile-specific return values occupy the range 200-999.
 * API-specific return values start at 1000. The exception to this is the "UNKNOWN" error code which
 * occupies the max integer value.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class BluetoothStatusCodes {

BluetoothStatusCodes() { throw new RuntimeException("Stub!"); }

/**
 * Error code indicating that the API call was initiated by neither the system nor the active
 * user.
 */

public static final int ERROR_BLUETOOTH_NOT_ALLOWED = 2; // 0x2

/** Error code indicating that Bluetooth is not enabled. */

public static final int ERROR_BLUETOOTH_NOT_ENABLED = 1; // 0x1

/** Error code indicating that the Bluetooth Device specified is not bonded. */

public static final int ERROR_DEVICE_NOT_BONDED = 3; // 0x3

/** A GATT writeCharacteristic request is not permitted on the remote device. */

public static final int ERROR_GATT_WRITE_NOT_ALLOWED = 200; // 0xc8

/** A GATT writeCharacteristic request is issued to a busy remote device. */

public static final int ERROR_GATT_WRITE_REQUEST_BUSY = 201; // 0xc9

/**
 * Error code indicating that the caller does not have the {@link
 * android.Manifest.permission#BLUETOOTH_CONNECT} permission.
 */

public static final int ERROR_MISSING_BLUETOOTH_CONNECT_PERMISSION = 6; // 0x6

/**
 * Error code indicating that the profile service is not bound. You can bind a profile service
 * by calling {@link android.bluetooth.BluetoothAdapter#getProfileProxy BluetoothAdapter#getProfileProxy}.
 */

public static final int ERROR_PROFILE_SERVICE_NOT_BOUND = 9; // 0x9

/** Indicates that an unknown error has occurred. */

public static final int ERROR_UNKNOWN = 2147483647; // 0x7fffffff

/** Indicates that the feature status is not configured yet. */

public static final int FEATURE_NOT_CONFIGURED = 30; // 0x1e

/** Indicates that the feature is not supported. */

public static final int FEATURE_NOT_SUPPORTED = 11; // 0xb

/** Indicates that the feature is supported. */

public static final int FEATURE_SUPPORTED = 10; // 0xa

/** Indicates that the API call was successful. */

public static final int SUCCESS = 0; // 0x0
}

