/*
 * Copyright (C) 2014 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.bluetooth.le;


/**
 * Wrapper for Transport Discovery Data Transport Blocks. This class represents a Transport Block
 * from a Transport Discovery Data.
 *
 * @see android.bluetooth.le.TransportDiscoveryData
 * @see android.bluetooth.le.AdvertiseData
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class TransportBlock implements android.os.Parcelable {

/**
 * Creates an instance of TransportBlock from raw data.
 *
 * @param orgId the Organization ID
 * @param tdsFlags the TDS flags
 * @param transportDataLength the total length of the Transport Data
 * @param transportData the Transport Data

 * This value may be {@code null}.
 */

public TransportBlock(int orgId, int tdsFlags, int transportDataLength, @android.annotation.Nullable byte[] transportData) { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

/** @hide */

public int describeContents() { throw new RuntimeException("Stub!"); }

/** @hide */

public boolean equals(@android.annotation.Nullable java.lang.Object obj) { throw new RuntimeException("Stub!"); }

/** @hide */

public int hashCode() { throw new RuntimeException("Stub!"); }

/**
 * Gets the Organization ID of the Transport Block which corresponds to one of the Bluetooth SIG
 * Assigned Numbers.
 */

public int getOrgId() { throw new RuntimeException("Stub!"); }

/**
 * Gets the TDS flags of the Transport Block which represents the role of the device and
 * information about its state and supported features.
 */

public int getTdsFlags() { throw new RuntimeException("Stub!"); }

/** Gets the total number of octets in the Transport Data field in this Transport Block. */

public int getTransportDataLength() { throw new RuntimeException("Stub!"); }

/**
 * Gets the Transport Data of the Transport Block which contains organization-specific data.
 * @return This value may be {@code null}.
 */

@android.annotation.Nullable
public byte[] getTransportData() { throw new RuntimeException("Stub!"); }

/**
 * Converts this TransportBlock to byte array
 *
 * @return byte array representation of this Transport Block or null if the conversion failed
 */

@android.annotation.Nullable
public byte[] toByteArray() { throw new RuntimeException("Stub!"); }

/**
 * @return total byte count of this TransportBlock
 */

public int totalBytes() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.bluetooth.le.TransportBlock> CREATOR;
static { CREATOR = null; }
}

