/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.devicelock;


/**
 * The response returned from {@link android.devicelock.DeviceLockManager#getDeviceId DeviceLockManager#getDeviceId} on success.
 * A DeviceId represents a stable identifier (i.e. an identifier that is preserved after a factory
 * reset). At this moment, the only supported identifiers are IMEI and MEID.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class DeviceId {

DeviceId() { throw new RuntimeException("Stub!"); }

/**
 * @return Value is {@link android.devicelock.DeviceId#DEVICE_ID_TYPE_IMEI}, or {@link android.devicelock.DeviceId#DEVICE_ID_TYPE_MEID}
 */

public int getType() { throw new RuntimeException("Stub!"); }

/**
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String getId() { throw new RuntimeException("Stub!"); }

/** The device id is an IMEI */

public static final int DEVICE_ID_TYPE_IMEI = 0; // 0x0

/** The device id is a MEID */

public static final int DEVICE_ID_TYPE_MEID = 1; // 0x1
}

