/*
 * Copyright (C) 2016 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.graphics;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract class ColorSpace {

ColorSpace() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.lang.String getName() { throw new RuntimeException("Stub!"); }

public int getId() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.graphics.ColorSpace.Model getModel() { throw new RuntimeException("Stub!"); }

public int getComponentCount() { throw new RuntimeException("Stub!"); }

public abstract boolean isWideGamut();

public boolean isSrgb() { throw new RuntimeException("Stub!"); }

public abstract float getMinValue(int component);

public abstract float getMaxValue(int component);

@android.annotation.NonNull
public float[] toXyz(float r, float g, float b) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public abstract float[] toXyz(@android.annotation.NonNull float[] v);

@android.annotation.NonNull
public float[] fromXyz(float x, float y, float z) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public abstract float[] fromXyz(@android.annotation.NonNull float[] v);

@android.annotation.NonNull
public java.lang.String toString() { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static android.graphics.ColorSpace.Connector connect(@android.annotation.NonNull android.graphics.ColorSpace source, @android.annotation.NonNull android.graphics.ColorSpace destination) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static android.graphics.ColorSpace.Connector connect(@android.annotation.NonNull android.graphics.ColorSpace source, @android.annotation.NonNull android.graphics.ColorSpace destination, @android.annotation.NonNull android.graphics.ColorSpace.RenderIntent intent) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static android.graphics.ColorSpace.Connector connect(@android.annotation.NonNull android.graphics.ColorSpace source) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static android.graphics.ColorSpace.Connector connect(@android.annotation.NonNull android.graphics.ColorSpace source, @android.annotation.NonNull android.graphics.ColorSpace.RenderIntent intent) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static android.graphics.ColorSpace adapt(@android.annotation.NonNull android.graphics.ColorSpace colorSpace, @android.annotation.NonNull float[] whitePoint) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static android.graphics.ColorSpace adapt(@android.annotation.NonNull android.graphics.ColorSpace colorSpace, @android.annotation.NonNull float[] whitePoint, @android.annotation.NonNull android.graphics.ColorSpace.Adaptation adaptation) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public static android.graphics.ColorSpace getFromDataSpace(int dataSpace) { throw new RuntimeException("Stub!"); }

public int getDataSpace() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static android.graphics.ColorSpace get(@android.annotation.NonNull android.graphics.ColorSpace.Named name) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public static android.graphics.ColorSpace match(@android.annotation.NonNull float[] toXYZD50, @android.annotation.NonNull android.graphics.ColorSpace.Rgb.TransferParameters function) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static float[] cctToXyz(int cct) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static float[] chromaticAdaptation(@android.annotation.NonNull android.graphics.ColorSpace.Adaptation adaptation, @android.annotation.NonNull float[] srcWhitePoint, @android.annotation.NonNull float[] dstWhitePoint) { throw new RuntimeException("Stub!"); }

public static final float[] ILLUMINANT_A;
static { ILLUMINANT_A = null; }

public static final float[] ILLUMINANT_B;
static { ILLUMINANT_B = null; }

public static final float[] ILLUMINANT_C;
static { ILLUMINANT_C = null; }

public static final float[] ILLUMINANT_D50;
static { ILLUMINANT_D50 = null; }

public static final float[] ILLUMINANT_D55;
static { ILLUMINANT_D55 = null; }

public static final float[] ILLUMINANT_D60;
static { ILLUMINANT_D60 = null; }

public static final float[] ILLUMINANT_D65;
static { ILLUMINANT_D65 = null; }

public static final float[] ILLUMINANT_D75;
static { ILLUMINANT_D75 = null; }

public static final float[] ILLUMINANT_E;
static { ILLUMINANT_E = null; }

public static final int MAX_ID = 63; // 0x3f

public static final int MIN_ID = -1; // 0xffffffff
@SuppressWarnings({"unchecked", "deprecation", "all"})
public enum Adaptation {
BRADFORD,
VON_KRIES,
CIECAT02;
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class Connector {

Connector() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.graphics.ColorSpace getSource() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.graphics.ColorSpace getDestination() { throw new RuntimeException("Stub!"); }

public android.graphics.ColorSpace.RenderIntent getRenderIntent() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public float[] transform(float r, float g, float b) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public float[] transform(@android.annotation.NonNull float[] v) { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public enum Model {
RGB,
XYZ,
LAB,
CMYK;

public int getComponentCount() { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public enum Named {
SRGB,
LINEAR_SRGB,
EXTENDED_SRGB,
LINEAR_EXTENDED_SRGB,
BT709,
BT2020,
DCI_P3,
DISPLAY_P3,
NTSC_1953,
SMPTE_C,
ADOBE_RGB,
PRO_PHOTO_RGB,
ACES,
ACESCG,
CIE_XYZ,
CIE_LAB,
BT2020_HLG,
BT2020_PQ;
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public enum RenderIntent {
PERCEPTUAL,
RELATIVE,
SATURATION,
ABSOLUTE;
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class Rgb extends android.graphics.ColorSpace {

public Rgb(@android.annotation.NonNull java.lang.String name, @android.annotation.NonNull float[] toXYZ, @android.annotation.NonNull java.util.function.DoubleUnaryOperator oetf, @android.annotation.NonNull java.util.function.DoubleUnaryOperator eotf) { throw new RuntimeException("Stub!"); }

public Rgb(@android.annotation.NonNull java.lang.String name, @android.annotation.NonNull float[] primaries, @android.annotation.NonNull float[] whitePoint, @android.annotation.NonNull java.util.function.DoubleUnaryOperator oetf, @android.annotation.NonNull java.util.function.DoubleUnaryOperator eotf, float min, float max) { throw new RuntimeException("Stub!"); }

public Rgb(@android.annotation.NonNull java.lang.String name, @android.annotation.NonNull float[] toXYZ, @android.annotation.NonNull android.graphics.ColorSpace.Rgb.TransferParameters function) { throw new RuntimeException("Stub!"); }

public Rgb(@android.annotation.NonNull java.lang.String name, @android.annotation.NonNull float[] primaries, @android.annotation.NonNull float[] whitePoint, @android.annotation.NonNull android.graphics.ColorSpace.Rgb.TransferParameters function) { throw new RuntimeException("Stub!"); }

public Rgb(@android.annotation.NonNull java.lang.String name, @android.annotation.NonNull float[] toXYZ, double gamma) { throw new RuntimeException("Stub!"); }

public Rgb(@android.annotation.NonNull java.lang.String name, @android.annotation.NonNull float[] primaries, @android.annotation.NonNull float[] whitePoint, double gamma) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public float[] getWhitePoint(@android.annotation.NonNull float[] whitePoint) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public float[] getWhitePoint() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public float[] getPrimaries(@android.annotation.NonNull float[] primaries) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public float[] getPrimaries() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public float[] getTransform(@android.annotation.NonNull float[] transform) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public float[] getTransform() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public float[] getInverseTransform(@android.annotation.NonNull float[] inverseTransform) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public float[] getInverseTransform() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.function.DoubleUnaryOperator getOetf() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.function.DoubleUnaryOperator getEotf() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.graphics.ColorSpace.Rgb.TransferParameters getTransferParameters() { throw new RuntimeException("Stub!"); }

public boolean isSrgb() { throw new RuntimeException("Stub!"); }

public boolean isWideGamut() { throw new RuntimeException("Stub!"); }

public float getMinValue(int component) { throw new RuntimeException("Stub!"); }

public float getMaxValue(int component) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public float[] toLinear(float r, float g, float b) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public float[] toLinear(@android.annotation.NonNull float[] v) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public float[] fromLinear(float r, float g, float b) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public float[] fromLinear(@android.annotation.NonNull float[] v) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public float[] toXyz(@android.annotation.NonNull float[] v) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public float[] fromXyz(@android.annotation.NonNull float[] v) { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class TransferParameters {

public TransferParameters(double a, double b, double c, double d, double g) { throw new RuntimeException("Stub!"); }

public TransferParameters(double a, double b, double c, double d, double e, double f, double g) { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

public final double a;
{ a = 0; }

public final double b;
{ b = 0; }

public final double c;
{ c = 0; }

public final double d;
{ d = 0; }

public final double e;
{ e = 0; }

public final double f;
{ f = 0; }

public final double g;
{ g = 0; }
}

}

}

