/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.graphics.pdf.content;


/**
 * <p>
 * Represents the content associated with an image type in a page of a PDF document.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class PdfPageImageContent implements android.os.Parcelable {

/**
 * Creates a new instance of {@link android.graphics.pdf.content.PdfPageImageContent PdfPageImageContent} using the alternate text of the image
 * on the page.
 *
 * @param altText Alternate text for the image.
 * This value cannot be {@code null}.
 * @throws java.lang.NullPointerException If the alternate text is null.
 */

public PdfPageImageContent(@android.annotation.NonNull java.lang.String altText) { throw new RuntimeException("Stub!"); }

/**
 * Gets the alternate text associated with the image represented by this instance. If there
 * is no such text associated with the image, the method will return an empty string.
 *
 * @return the alternate text of the image.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String getAltText() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.graphics.pdf.content.PdfPageImageContent> CREATOR;
static { CREATOR = null; }
}

