/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.graphics.pdf.models;

import android.graphics.RectF;

/**
 * Represents the bounds of a single search match on a page of the PDF document.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class PageMatchBounds implements android.os.Parcelable {

/**
 * Creates a new instance of {@link android.graphics.pdf.models.PageMatchBounds PageMatchBounds} for the text match found on the page. The
 * match is represented by bounds of the text match and the starting index of the character
 * "stream" (0-based index).
 *
 * @param bounds         Bounds of the text match.
 * This value cannot be {@code null}.
 * @param textStartIndex starting index of the text match.
 * @throws java.lang.NullPointerException     If bounds if null.
 * @throws java.lang.IllegalArgumentException If bounds list is empty or if the text starting index is
 *                                  negative.
 */

public PageMatchBounds(@android.annotation.NonNull java.util.List<android.graphics.RectF> bounds, int textStartIndex) { throw new RuntimeException("Stub!"); }

/**
 * <p>
 * Represents the {@link android.graphics.RectF RectF} bounds of a match. Matches which are spread across multiple
 * lines will be represented by multiple {@link android.graphics.RectF RectF} in order of viewing.
 * <p><strong>Note:</strong> The bounds only represent the coordinates of the bounds of a
 * single line using {@link android.graphics.RectF RectF}. The developer will need to render the highlighter as well
 * as
 * intercept the touch events for any additional UI interactions.
 *
 * @return list of bounds for the match on the page.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<android.graphics.RectF> getBounds() { throw new RuntimeException("Stub!"); }

/**
 * Gets the starting index of the match found on the page. Characters in a page form a "stream"
 * and inside the stream, each character has an index starting from 0.
 *
 * @return the starting index of the match on the page.
 */

public int getTextStartIndex() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.graphics.pdf.models.PageMatchBounds> CREATOR;
static { CREATOR = null; }
}

