/*
 * Copyright (C) 2018 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.graphics.text;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class LineBreaker {

LineBreaker() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.graphics.text.LineBreaker.Result computeLineBreaks(@android.annotation.NonNull android.graphics.text.MeasuredText measuredPara, @android.annotation.NonNull android.graphics.text.LineBreaker.ParagraphConstraints constraints, int lineNumber) { throw new RuntimeException("Stub!"); }

public static final int BREAK_STRATEGY_BALANCED = 2; // 0x2

public static final int BREAK_STRATEGY_HIGH_QUALITY = 1; // 0x1

public static final int BREAK_STRATEGY_SIMPLE = 0; // 0x0

public static final int HYPHENATION_FREQUENCY_FULL = 2; // 0x2

public static final int HYPHENATION_FREQUENCY_NONE = 0; // 0x0

public static final int HYPHENATION_FREQUENCY_NORMAL = 1; // 0x1

public static final int JUSTIFICATION_MODE_INTER_CHARACTER = 2; // 0x2

public static final int JUSTIFICATION_MODE_INTER_WORD = 1; // 0x1

public static final int JUSTIFICATION_MODE_NONE = 0; // 0x0
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.graphics.text.LineBreaker.Builder setBreakStrategy(int breakStrategy) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.graphics.text.LineBreaker.Builder setHyphenationFrequency(int hyphenationFrequency) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.graphics.text.LineBreaker.Builder setJustificationMode(int justificationMode) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.graphics.text.LineBreaker.Builder setIndents(@android.annotation.Nullable int[] indents) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.graphics.text.LineBreaker.Builder setUseBoundsForWidth(boolean useBoundsForWidth) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.graphics.text.LineBreaker build() { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class ParagraphConstraints {

public ParagraphConstraints() { throw new RuntimeException("Stub!"); }

public void setWidth(float width) { throw new RuntimeException("Stub!"); }

public void setIndent(float firstWidth, int firstWidthLineCount) { throw new RuntimeException("Stub!"); }

public void setTabStops(@android.annotation.Nullable float[] tabStops, float defaultTabStop) { throw new RuntimeException("Stub!"); }

public float getWidth() { throw new RuntimeException("Stub!"); }

public float getFirstWidth() { throw new RuntimeException("Stub!"); }

public int getFirstWidthLineCount() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public float[] getTabStops() { throw new RuntimeException("Stub!"); }

public float getDefaultTabStop() { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class Result {

Result() { throw new RuntimeException("Stub!"); }

public int getLineCount() { throw new RuntimeException("Stub!"); }

public int getLineBreakOffset(int lineIndex) { throw new RuntimeException("Stub!"); }

public float getLineWidth(int lineIndex) { throw new RuntimeException("Stub!"); }

public float getLineAscent(int lineIndex) { throw new RuntimeException("Stub!"); }

public float getLineDescent(int lineIndex) { throw new RuntimeException("Stub!"); }

public boolean hasLineTab(int lineIndex) { throw new RuntimeException("Stub!"); }

public int getStartLineHyphenEdit(int lineIndex) { throw new RuntimeException("Stub!"); }

public int getEndLineHyphenEdit(int lineIndex) { throw new RuntimeException("Stub!"); }
}

}

