/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.health.connect;

import android.health.connect.datatypes.DataOrigin;
import java.time.LocalDateTime;
import java.time.ZoneOffset;

/**
 * Class to represent the response from {@link android.health.connect.HealthConnectManager#aggregateGroupByPeriod HealthConnectManager#aggregateGroupByPeriod}
 *
 * @see android.health.connect.HealthConnectManager#aggregateGroupByPeriod
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class AggregateRecordsGroupedByPeriodResponse<T> {

AggregateRecordsGroupedByPeriodResponse() { throw new RuntimeException("Stub!"); }

/**
 * @return Start {@link java.time.LocalDateTime LocalDateTime} of the window for the underlying aggregation

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.time.LocalDateTime getStartTime() { throw new RuntimeException("Stub!"); }

/**
 * @return End {@link java.time.LocalDateTime LocalDateTime} of the window for the underlying aggregation

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.time.LocalDateTime getEndTime() { throw new RuntimeException("Stub!"); }

/**
 * @param aggregationType This value cannot be {@code null}.
 * @return An aggregation result for {@code aggregationType}, and null if one doesn't exist
 */

@android.annotation.Nullable
public T get(@android.annotation.NonNull android.health.connect.datatypes.AggregationType<T> aggregationType) { throw new RuntimeException("Stub!"); }

/**
 * @param aggregationType This value cannot be {@code null}.
 * @return {@link java.time.ZoneOffset ZoneOffset} for the underlying aggregation record, null if the corresponding
 *     aggregation doesn't exist or if multiple records were present.
 */

@android.annotation.Nullable
public java.time.ZoneOffset getZoneOffset(@android.annotation.NonNull android.health.connect.datatypes.AggregationType<T> aggregationType) { throw new RuntimeException("Stub!"); }

/**
 * Returns a set of {@link android.health.connect.datatypes.DataOrigin DataOrigin}s for the underlying aggregation record, empty set if the
 * corresponding aggregation doesn't exist and or if multiple records were present.
 
 * @param aggregationType This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.Set<android.health.connect.datatypes.DataOrigin> getDataOrigins(@android.annotation.NonNull android.health.connect.datatypes.AggregationType<T> aggregationType) { throw new RuntimeException("Stub!"); }
}

