/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.health.connect.datatypes;

import java.time.Instant;
import java.util.Set;

/** Set of shared metadata fields for {@link android.health.connect.datatypes.Record Record} */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class Metadata {

Metadata() { throw new RuntimeException("Stub!"); }

/**
 * @return Client record ID if set, null otherwise
 */

@android.annotation.Nullable
public java.lang.String getClientRecordId() { throw new RuntimeException("Stub!"); }

/**
 * @return Client record version if set, 0 otherwise
 */

public long getClientRecordVersion() { throw new RuntimeException("Stub!"); }

/**
 * @return Corresponds to package name if set. If no data origin is set {@code
 *     getDataOrigin().getPackageName()} will return null
 */

@android.annotation.NonNull
public android.health.connect.datatypes.DataOrigin getDataOrigin() { throw new RuntimeException("Stub!"); }

/**
 * @return Record identifier if set, empty string otherwise

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String getId() { throw new RuntimeException("Stub!"); }

/**
 * Returns recording method which indicates how data was recorded for the {@link android.health.connect.datatypes.Record Record}
 * @return Value is {@link android.health.connect.datatypes.Metadata#RECORDING_METHOD_UNKNOWN}, {@link android.health.connect.datatypes.Metadata#RECORDING_METHOD_ACTIVELY_RECORDED}, {@link android.health.connect.datatypes.Metadata#RECORDING_METHOD_AUTOMATICALLY_RECORDED}, or {@link android.health.connect.datatypes.Metadata#RECORDING_METHOD_MANUAL_ENTRY}
 */

public int getRecordingMethod() { throw new RuntimeException("Stub!"); }

/**
 * @return Record's last modified time if set, Instant.EPOCH otherwise

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.time.Instant getLastModifiedTime() { throw new RuntimeException("Stub!"); }

/**
 * @return The device details that contributed to this record

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.Device getDevice() { throw new RuntimeException("Stub!"); }

/**
 * Indicates whether some other object is "equal to" this one.
 *
 * @param object the reference object with which to compare.
 * This value may be {@code null}.
 * @return {@code true} if this object is the same as the obj
 */

public boolean equals(@android.annotation.Nullable java.lang.Object object) { throw new RuntimeException("Stub!"); }

/**
 * Returns a hash code value for the object.
 *
 * @return a hash code value for this object.
 */

public int hashCode() { throw new RuntimeException("Stub!"); }

/**
 * For actively recorded data by the user.
 *
 * <p>For e.g. An exercise session actively recorded by the user using a phone or a watch
 * device.
 */

public static final int RECORDING_METHOD_ACTIVELY_RECORDED = 1; // 0x1

/**
 * For passively recorded data by the app.
 *
 * <p>For e.g. Steps data recorded by a watch or phone without the user starting a session.
 */

public static final int RECORDING_METHOD_AUTOMATICALLY_RECORDED = 2; // 0x2

/**
 * For manually entered data by the user.
 *
 * <p>For e.g. Nutrition or weight data entered by the user.
 */

public static final int RECORDING_METHOD_MANUAL_ENTRY = 3; // 0x3

/** Unknown recording method. */

public static final int RECORDING_METHOD_UNKNOWN = 0; // 0x0
/**
 * @see android.health.connect.datatypes.Metadata
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * Sets optional client supplied device information associated with the data.
 * @param device This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.Metadata.Builder setDevice(@android.annotation.NonNull android.health.connect.datatypes.Device device) { throw new RuntimeException("Stub!"); }

/**
 * Sets where the data comes from, such as application information originally generated this
 * data. When {@link android.health.connect.datatypes.Record Record} is created before insertion, this contains a sentinel value,
 * any assigned value will be ignored. After insertion, this will be populated with inserted
 * application.
 
 * @param dataOrigin This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.Metadata.Builder setDataOrigin(@android.annotation.NonNull android.health.connect.datatypes.DataOrigin dataOrigin) { throw new RuntimeException("Stub!"); }

/**
 * Sets unique identifier of this data, assigned by the Android Health Platform at insertion
 * time. When {@link android.health.connect.datatypes.Record Record} is created before insertion, this takes a sentinel value, any
 * assigned value will be ignored.
 
 * @param id This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.Metadata.Builder setId(@android.annotation.NonNull java.lang.String id) { throw new RuntimeException("Stub!"); }

/**
 * Sets when data was last modified (or originally created). When {@link android.health.connect.datatypes.Record Record} is created
 * before inserted, this contains a sentinel value, any assigned value will be ignored.
 
 * @param lastModifiedTime This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.Metadata.Builder setLastModifiedTime(@android.annotation.NonNull java.time.Instant lastModifiedTime) { throw new RuntimeException("Stub!"); }

/**
 * Sets optional client supplied record unique data identifier associated with the data.
 * There is guaranteed a single entry for any type of data with same client provided
 * identifier for a given client. Any new insertions with the same client provided
 * identifier will either replace or be ignored depending on associated {@code
 * clientRecordVersion}. @see clientRecordVersion
 *
 * <p>A null value means that no clientRecordId is set

 * @param clientRecordId This value may be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.Metadata.Builder setClientRecordId(@android.annotation.Nullable java.lang.String clientRecordId) { throw new RuntimeException("Stub!"); }

/**
 * Sets optional client supplied version associated with the data. This determines conflict
 * resolution outcome when there are multiple insertions of the same {@code clientRecordId}.
 * Data with the highest {@code clientRecordVersion} takes precedence. {@code
 * clientRecordVersion} starts with 0. @see clientRecordId

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.Metadata.Builder setClientRecordVersion(long clientRecordVersion) { throw new RuntimeException("Stub!"); }

/**
 * Sets recording method for the {@link android.health.connect.datatypes.Record Record}. This detail helps to know how the data was
 * recorded which can be useful for prioritization of the record
 
 * @param recordingMethod Value is {@link android.health.connect.datatypes.Metadata#RECORDING_METHOD_UNKNOWN}, {@link android.health.connect.datatypes.Metadata#RECORDING_METHOD_ACTIVELY_RECORDED}, {@link android.health.connect.datatypes.Metadata#RECORDING_METHOD_AUTOMATICALLY_RECORDED}, or {@link android.health.connect.datatypes.Metadata#RECORDING_METHOD_MANUAL_ENTRY}
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.Metadata.Builder setRecordingMethod(int recordingMethod) { throw new RuntimeException("Stub!"); }

/**
 * @return {@link android.health.connect.datatypes.Metadata Metadata} object

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.Metadata build() { throw new RuntimeException("Stub!"); }
}

}

