/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.health.connect.datatypes;


/**
 * Represents a series of {@link android.health.connect.datatypes.PlannedExerciseStep PlannedExerciseStep}. Part of a {@link android.health.connect.datatypes.PlannedExerciseSessionRecord PlannedExerciseSessionRecord}.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class PlannedExerciseBlock {

PlannedExerciseBlock() { throw new RuntimeException("Stub!"); }

/**
 * A description for this block, e.g.&nbsp;"Main set".
 * @return This value may be {@code null}.
 */

@android.annotation.Nullable
public java.lang.CharSequence getDescription() { throw new RuntimeException("Stub!"); }

/**
 * The steps associated with this block.
 *
 * @return An unmodifiable list of {@link android.health.connect.datatypes.PlannedExerciseStep PlannedExerciseStep}.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<android.health.connect.datatypes.PlannedExerciseStep> getSteps() { throw new RuntimeException("Stub!"); }

/** The number of times this block should be repeated by the user. */

public int getRepetitions() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param o This value may be {@code null}.
 */

public boolean equals(@android.annotation.Nullable java.lang.Object o) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }
/** Builder of {@link android.health.connect.datatypes.PlannedExerciseBlock PlannedExerciseBlock}. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/**
 * @param repetitions The number of times this block should be repeated by the user.
 */

public Builder(int repetitions) { throw new RuntimeException("Stub!"); }

/**
 * Sets the number of repetitions.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.PlannedExerciseBlock.Builder setRepetitions(int repetitions) { throw new RuntimeException("Stub!"); }

/**
 * Sets the description.
 * @param description This value may be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.PlannedExerciseBlock.Builder setDescription(@android.annotation.Nullable java.lang.CharSequence description) { throw new RuntimeException("Stub!"); }

/**
 * Adds a {@link android.health.connect.datatypes.PlannedExerciseStep PlannedExerciseStep}.
 * @param step This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.PlannedExerciseBlock.Builder addStep(@android.annotation.NonNull android.health.connect.datatypes.PlannedExerciseStep step) { throw new RuntimeException("Stub!"); }

/**
 * Sets the {@link android.health.connect.datatypes.PlannedExerciseStep PlannedExerciseStep} entries.
 * @param steps This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.PlannedExerciseBlock.Builder setSteps(@android.annotation.NonNull java.util.List<android.health.connect.datatypes.PlannedExerciseStep> steps) { throw new RuntimeException("Stub!"); }

/**
 * Clears the {@link android.health.connect.datatypes.PlannedExerciseStep PlannedExerciseStep} entries.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.PlannedExerciseBlock.Builder clearSteps() { throw new RuntimeException("Stub!"); }

/**
 * @return Object of {@link android.health.connect.datatypes.PlannedExerciseBlock PlannedExerciseBlock}.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.PlannedExerciseBlock build() { throw new RuntimeException("Stub!"); }
}

}

