/*
 * Copyright (C) 2007 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.location;


/**
 * A class indicating the application criteria for selecting a location provider. Providers may be
 * ordered according to accuracy, power usage, ability to report altitude, speed, bearing, and
 * monetary cost.
 *
 * @deprecated Criteria based APIs are deprecated because they cannot fully capture the complexity
 *             of location providers, and encourage bad development practices. Prefer to explicit
 *             select the location provider of interest ({@link android.location.LocationManager#FUSED_PROVIDER LocationManager#FUSED_PROVIDER},
 *             {@link android.location.LocationManager#GPS_PROVIDER etc}), rather than relying on Criteria.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
@Deprecated
public class Criteria implements android.os.Parcelable {

/**
 * Constructs a new Criteria object.  The new object will have no
 * requirements on accuracy, power, or response time; will not
 * require altitude, speed, or bearing; and will not allow monetary
 * cost.
 */

@Deprecated
public Criteria() { throw new RuntimeException("Stub!"); }

/**
 * Constructs a new Criteria object that is a copy of the given criteria.
 */

@Deprecated
public Criteria(android.location.Criteria criteria) { throw new RuntimeException("Stub!"); }

/**
 * Indicates the desired horizontal accuracy (latitude and longitude). Accuracy may be
 * {@link #ACCURACY_LOW}, {@link #ACCURACY_MEDIUM}, {@link #ACCURACY_HIGH} or
 * {@link #NO_REQUIREMENT}. More accurate location may consume more power and may take longer.
 *
 * @throws java.lang.IllegalArgumentException if accuracy is not one of the supported constants

 * @param accuracy Value is {@link android.location.Criteria#NO_REQUIREMENT}, {@link android.location.Criteria#ACCURACY_LOW}, {@link android.location.Criteria#ACCURACY_MEDIUM}, or {@link android.location.Criteria#ACCURACY_HIGH}
 */

@Deprecated
public void setHorizontalAccuracy(int accuracy) { throw new RuntimeException("Stub!"); }

/**
 * Returns a constant indicating the desired horizontal accuracy (latitude and longitude).
 *
 * @see #setHorizontalAccuracy(int)

 * @return Value is {@link android.location.Criteria#NO_REQUIREMENT}, {@link android.location.Criteria#ACCURACY_LOW}, {@link android.location.Criteria#ACCURACY_MEDIUM}, or {@link android.location.Criteria#ACCURACY_HIGH}
 */

@Deprecated
public int getHorizontalAccuracy() { throw new RuntimeException("Stub!"); }

/**
 * Indicates the desired vertical accuracy (altitude). Accuracy may be {@link #ACCURACY_LOW},
 * {@link #ACCURACY_MEDIUM}, {@link #ACCURACY_HIGH} or {@link #NO_REQUIREMENT}. More accurate
 * location may consume more power and may take longer.
 *
 * @throws java.lang.IllegalArgumentException if accuracy is not one of the supported constants

 * @param accuracy Value is {@link android.location.Criteria#NO_REQUIREMENT}, {@link android.location.Criteria#ACCURACY_LOW}, {@link android.location.Criteria#ACCURACY_MEDIUM}, or {@link android.location.Criteria#ACCURACY_HIGH}
 */

@Deprecated
public void setVerticalAccuracy(int accuracy) { throw new RuntimeException("Stub!"); }

/**
 * Returns a constant indicating the desired vertical accuracy (altitude).
 *
 * @see #setVerticalAccuracy(int)

 * @return Value is {@link android.location.Criteria#NO_REQUIREMENT}, {@link android.location.Criteria#ACCURACY_LOW}, {@link android.location.Criteria#ACCURACY_MEDIUM}, or {@link android.location.Criteria#ACCURACY_HIGH}
 */

@Deprecated
public int getVerticalAccuracy() { throw new RuntimeException("Stub!"); }

/**
 * Indicates the desired speed accuracy. Accuracy may be {@link #ACCURACY_LOW},
 * {@link #ACCURACY_MEDIUM}, {@link #ACCURACY_HIGH}, or {@link #NO_REQUIREMENT}. More accurate
 * location may consume more power and may take longer.
 *
 * @throws java.lang.IllegalArgumentException if accuracy is not one of the supported constants

 * @param accuracy Value is {@link android.location.Criteria#NO_REQUIREMENT}, {@link android.location.Criteria#ACCURACY_LOW}, {@link android.location.Criteria#ACCURACY_MEDIUM}, or {@link android.location.Criteria#ACCURACY_HIGH}
 */

@Deprecated
public void setSpeedAccuracy(int accuracy) { throw new RuntimeException("Stub!"); }

/**
 * Returns a constant indicating the desired speed accuracy.
 *
 * @see #setSpeedAccuracy(int)

 * @return Value is {@link android.location.Criteria#NO_REQUIREMENT}, {@link android.location.Criteria#ACCURACY_LOW}, {@link android.location.Criteria#ACCURACY_MEDIUM}, or {@link android.location.Criteria#ACCURACY_HIGH}
 */

@Deprecated
public int getSpeedAccuracy() { throw new RuntimeException("Stub!"); }

/**
 * Indicates the desired bearing accuracy. Accuracy may be {@link #ACCURACY_LOW},
 * {@link #ACCURACY_MEDIUM}, {@link #ACCURACY_HIGH}, or {@link #NO_REQUIREMENT}. More accurate
 * location may consume more power and may take longer.
 *
 * @throws java.lang.IllegalArgumentException if accuracy is not one of the supported constants

 * @param accuracy Value is {@link android.location.Criteria#NO_REQUIREMENT}, {@link android.location.Criteria#ACCURACY_LOW}, {@link android.location.Criteria#ACCURACY_MEDIUM}, or {@link android.location.Criteria#ACCURACY_HIGH}
 */

@Deprecated
public void setBearingAccuracy(int accuracy) { throw new RuntimeException("Stub!"); }

/**
 * Returns a constant indicating the desired bearing accuracy.
 *
 * @see #setBearingAccuracy(int)

 * @return Value is {@link android.location.Criteria#NO_REQUIREMENT}, {@link android.location.Criteria#ACCURACY_LOW}, {@link android.location.Criteria#ACCURACY_MEDIUM}, or {@link android.location.Criteria#ACCURACY_HIGH}
 */

@Deprecated
public int getBearingAccuracy() { throw new RuntimeException("Stub!"); }

/**
 * Indicates the desired accuracy for latitude and longitude. Accuracy may be
 * {@link #ACCURACY_FINE} or {@link #ACCURACY_COARSE}. More accurate location may consume more
 * power and may take longer.
 *
 * @throws java.lang.IllegalArgumentException if accuracy is not one of the supported constants

 * @param accuracy Value is {@link android.location.Criteria#NO_REQUIREMENT}, {@link android.location.Criteria#ACCURACY_FINE}, or {@link android.location.Criteria#ACCURACY_COARSE}
 */

@Deprecated
public void setAccuracy(int accuracy) { throw new RuntimeException("Stub!"); }

/**
 * Returns a constant indicating desired accuracy of location.
 *
 * @see #setAccuracy(int)

 * @return Value is {@link android.location.Criteria#NO_REQUIREMENT}, {@link android.location.Criteria#ACCURACY_FINE}, or {@link android.location.Criteria#ACCURACY_COARSE}
 */

@Deprecated
public int getAccuracy() { throw new RuntimeException("Stub!"); }

/**
 * Indicates the desired maximum power requirement. The power requirement parameter may be
 * {@link #NO_REQUIREMENT}, {@link #POWER_LOW}, {@link #POWER_MEDIUM}, or {@link #POWER_HIGH}.

 * @param powerRequirement Value is {@link android.location.Criteria#NO_REQUIREMENT}, {@link android.location.Criteria#POWER_LOW}, {@link android.location.Criteria#POWER_MEDIUM}, or {@link android.location.Criteria#POWER_HIGH}
 */

@Deprecated
public void setPowerRequirement(int powerRequirement) { throw new RuntimeException("Stub!"); }

/**
 * Returns a constant indicating the desired maximum power requirement.
 *
 * @see #setPowerRequirement(int)

 * @return Value is {@link android.location.Criteria#NO_REQUIREMENT}, {@link android.location.Criteria#POWER_LOW}, {@link android.location.Criteria#POWER_MEDIUM}, or {@link android.location.Criteria#POWER_HIGH}
 */

@Deprecated
public int getPowerRequirement() { throw new RuntimeException("Stub!"); }

/**
 * Indicates whether the provider is allowed to incur monetary cost.
 */

@Deprecated
public void setCostAllowed(boolean costAllowed) { throw new RuntimeException("Stub!"); }

/**
 * Returns whether the provider is allowed to incur monetary cost.
 */

@Deprecated
public boolean isCostAllowed() { throw new RuntimeException("Stub!"); }

/**
 * Indicates whether the provider must provide altitude information. Not all fixes are
 * guaranteed to contain such information.
 */

@Deprecated
public void setAltitudeRequired(boolean altitudeRequired) { throw new RuntimeException("Stub!"); }

/**
 * Returns whether the provider must provide altitude information.
 *
 * @see #setAltitudeRequired(boolean)
 */

@Deprecated
public boolean isAltitudeRequired() { throw new RuntimeException("Stub!"); }

/**
 * Indicates whether the provider must provide speed information. Not all fixes are guaranteed
 * to contain such information.
 */

@Deprecated
public void setSpeedRequired(boolean speedRequired) { throw new RuntimeException("Stub!"); }

/**
 * Returns whether the provider must provide speed information.
 *
 * @see #setSpeedRequired(boolean)
 */

@Deprecated
public boolean isSpeedRequired() { throw new RuntimeException("Stub!"); }

/**
 * Indicates whether the provider must provide bearing information. Not all fixes are guaranteed
 * to contain such information.
 */

@Deprecated
public void setBearingRequired(boolean bearingRequired) { throw new RuntimeException("Stub!"); }

/**
 * Returns whether the provider must provide bearing information.
 *
 * @see #setBearingRequired(boolean)
 */

@Deprecated
public boolean isBearingRequired() { throw new RuntimeException("Stub!"); }

@Deprecated
public int describeContents() { throw new RuntimeException("Stub!"); }

@Deprecated
public void writeToParcel(android.os.Parcel parcel, int flags) { throw new RuntimeException("Stub!"); }

@Deprecated
public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/**
 * A constant indicating an approximate accuracy requirement
 */

@Deprecated public static final int ACCURACY_COARSE = 2; // 0x2

/**
 * A constant indicating a finer location accuracy requirement
 */

@Deprecated public static final int ACCURACY_FINE = 1; // 0x1

/**
 * a constant indicating a high accuracy requirement
 * - may be used for horizontal, altitude, speed or bearing accuracy.
 * For horizontal and vertical position this corresponds roughly to
 * an accuracy of less than 100 meters.
 */

@Deprecated public static final int ACCURACY_HIGH = 3; // 0x3

/**
 * A constant indicating a low location accuracy requirement
 * - may be used for horizontal, altitude, speed or bearing accuracy.
 * For horizontal and vertical position this corresponds roughly to
 * an accuracy of greater than 500 meters.
 */

@Deprecated public static final int ACCURACY_LOW = 1; // 0x1

/**
 * A constant indicating a medium accuracy requirement
 * - currently used only for horizontal accuracy.
 * For horizontal position this corresponds roughly to to an accuracy
 * of between 100 and 500 meters.
 */

@Deprecated public static final int ACCURACY_MEDIUM = 2; // 0x2

@Deprecated @android.annotation.NonNull public static final android.os.Parcelable.Creator<android.location.Criteria> CREATOR;
static { CREATOR = null; }

/**
 * A constant indicating that the application does not choose to
 * place requirement on a particular feature.
 */

@Deprecated public static final int NO_REQUIREMENT = 0; // 0x0

/**
 * A constant indicating a high power requirement.
 */

@Deprecated public static final int POWER_HIGH = 3; // 0x3

/**
 * A constant indicating a low power requirement.
 */

@Deprecated public static final int POWER_LOW = 1; // 0x1

/**
 * A constant indicating a medium power requirement.
 */

@Deprecated public static final int POWER_MEDIUM = 2; // 0x2
}

