/*
 * Copyright (C) 2014 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License
 */


package android.location;


/**
 * A class implementing a container for data associated with a measurement event.
 * Events are delivered to registered instances of {@link android.location.GnssMeasurementsEvent.Callback Callback}.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class GnssMeasurementsEvent implements android.os.Parcelable {

GnssMeasurementsEvent() { throw new RuntimeException("Stub!"); }

/**
 * Gets the GNSS receiver clock information associated with the measurements for the current
 * event.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.location.GnssClock getClock() { throw new RuntimeException("Stub!"); }

/**
 * Gets the collection of measurements associated with the current event.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.Collection<android.location.GnssMeasurement> getMeasurements() { throw new RuntimeException("Stub!"); }

/**
 * Gets the collection of {@link android.location.GnssAutomaticGainControl GnssAutomaticGainControl} associated with the
 * current event.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.Collection<android.location.GnssAutomaticGainControl> getGnssAutomaticGainControls() { throw new RuntimeException("Stub!"); }

/**
 * True indicates that this event was produced while the chipset was in full tracking mode, ie,
 * the GNSS chipset switched off duty cycling. In this mode, no clock discontinuities are
 * expected and, when supported, carrier phase should be continuous in good signal conditions.
 * All non-blocklisted, healthy constellations, satellites and frequency bands that are
 * meaningful to positioning accuracy must be tracked and reported in this mode.
 *
 * False indicates that the GNSS chipset may optimize power via duty cycling, constellations and
 * frequency limits, etc.
 *
 * <p>The value is only available if {@link #hasIsFullTracking()} is {@code true}.
 */

public boolean isFullTracking() { throw new RuntimeException("Stub!"); }

/**
 * Return {@code true} if {@link #isFullTracking()} is available, {@code false} otherwise.
 */

public boolean hasIsFullTracking() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public void writeToParcel(android.os.Parcel parcel, int flags) { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.location.GnssMeasurementsEvent> CREATOR;
static { CREATOR = null; }
/** Builder for {@link android.location.GnssMeasurementsEvent GnssMeasurementsEvent} */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/**
 * Constructs a {@link android.location.GnssMeasurementsEvent.Builder GnssMeasurementsEvent.Builder} instance.
 */

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * Constructs a {@link android.location.GnssMeasurementsEvent.Builder GnssMeasurementsEvent.Builder} instance by copying a
 * {@link android.location.GnssMeasurementsEvent GnssMeasurementsEvent}.

 * @param event This value cannot be {@code null}.
 */

public Builder(@android.annotation.NonNull android.location.GnssMeasurementsEvent event) { throw new RuntimeException("Stub!"); }

/**
 * Sets the {@link android.location.GnssClock GnssClock}.
 
 * @param clock This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.location.GnssMeasurementsEvent.Builder setClock(@android.annotation.NonNull android.location.GnssClock clock) { throw new RuntimeException("Stub!"); }

/**
 * Sets the collection of {@link android.location.GnssMeasurement GnssMeasurement}.
 
 * @param measurements This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.location.GnssMeasurementsEvent.Builder setMeasurements(@android.annotation.NonNull java.util.Collection<android.location.GnssMeasurement> measurements) { throw new RuntimeException("Stub!"); }

/**
 * Sets the collection of {@link android.location.GnssAutomaticGainControl GnssAutomaticGainControl}.
 
 * @param agcs This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.location.GnssMeasurementsEvent.Builder setGnssAutomaticGainControls(@android.annotation.NonNull java.util.Collection<android.location.GnssAutomaticGainControl> agcs) { throw new RuntimeException("Stub!"); }

/**
 * Sets whether the GNSS chipset was in the full tracking mode at the time this event was
 * produced.
 *
 * True indicates that this event was produced while the chipset was in full tracking
 * mode, ie, the GNSS chipset switched off duty cycling. In this mode, no clock
 * discontinuities are expected and, when supported, carrier phase should be continuous in
 * good signal conditions. All non-blocklisted, healthy constellations, satellites and
 * frequency bands that are meaningful to positioning accuracy must be tracked and reported
 * in this mode.
 *
 * False indicates that the GNSS chipset may optimize power via duty cycling, constellations
 * and frequency limits, etc.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.location.GnssMeasurementsEvent.Builder setIsFullTracking(boolean isFullTracking) { throw new RuntimeException("Stub!"); }

/**
 * Clears the full tracking mode indicator.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.location.GnssMeasurementsEvent.Builder clearIsFullTracking() { throw new RuntimeException("Stub!"); }

/**
 * Builds a {@link android.location.GnssMeasurementsEvent GnssMeasurementsEvent} instance as specified by this builder.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.location.GnssMeasurementsEvent build() { throw new RuntimeException("Stub!"); }
}

/**
 * Used for receiving GNSS satellite measurements from the GNSS engine.
 * Each measurement contains raw and computed data identifying a satellite.
 * You can implement this interface and call
 * {@link android.location.LocationManager#registerGnssMeasurementsCallback LocationManager#registerGnssMeasurementsCallback}.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract static class Callback {

public Callback() { throw new RuntimeException("Stub!"); }

/**
 * Reports the latest collected GNSS Measurements.
 */

public void onGnssMeasurementsReceived(android.location.GnssMeasurementsEvent eventArgs) { throw new RuntimeException("Stub!"); }

/**
 * Reports the latest status of the GNSS Measurements sub-system.
 *
 * @deprecated Do not rely on this callback. From Android S onwards this callback will be
 * invoked once with {@link #STATUS_READY} in all cases for backwards compatibility, and
 * then never invoked again. Use LocationManager APIs if you need to determine if
 * GNSS measurements are supported or if location is off, etc...

 * @param status Value is {@link android.location.GnssMeasurementsEvent.Callback#STATUS_NOT_SUPPORTED}, {@link android.location.GnssMeasurementsEvent.Callback#STATUS_READY}, {@link android.location.GnssMeasurementsEvent.Callback#STATUS_LOCATION_DISABLED}, or {@link android.location.GnssMeasurementsEvent.Callback#STATUS_NOT_ALLOWED}
 */

@Deprecated
public void onStatusChanged(int status) { throw new RuntimeException("Stub!"); }

/**
 * GPS provider or Location is disabled, updates will not be received until they are
 * enabled.
 *
 * @deprecated Do not use.
 */

@Deprecated public static final int STATUS_LOCATION_DISABLED = 2; // 0x2

/**
 * The client is not allowed to register for GNSS Measurements in general or in the
 * requested mode.
 *
 * <p>Such a status is returned when a client tries to request a functionality from the GNSS
 * chipset while another client has an ongoing request that does not allow such
 * functionality to be performed.
 *
 * <p>If such a status is received, one would try again at a later time point where no
 * other client is having a conflicting request.
 *
 * @deprecated Do not use.
 */

@Deprecated public static final int STATUS_NOT_ALLOWED = 3; // 0x3

/**
 * The system does not support tracking of GNSS Measurements.
 *
 * <p>This status will not change in the future.
 *
 * @deprecated Do not use.
 */

@Deprecated public static final int STATUS_NOT_SUPPORTED = 0; // 0x0

/**
 * GNSS Measurements are successfully being tracked, it will receive updates once they are
 * available.
 *
 * @deprecated Do not use.
 */

@Deprecated public static final int STATUS_READY = 1; // 0x1
}

}

