/*
 * Copyright (C) 2021 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.net;


/**
 * A {@link android.net.NetworkSpecifier NetworkSpecifier} used to identify ethernet interfaces.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class EthernetNetworkSpecifier extends android.net.NetworkSpecifier implements android.os.Parcelable {

/**
 * Create a new EthernetNetworkSpecifier.
 * @param interfaceName Name of the ethernet interface the specifier refers to.

 * This value cannot be {@code null}.
 */

public EthernetNetworkSpecifier(@android.annotation.NonNull java.lang.String interfaceName) { throw new RuntimeException("Stub!"); }

/**
 * Get the name of the ethernet interface the specifier refers to.

 * @return This value may be {@code null}.
 */

@android.annotation.Nullable
public java.lang.String getInterfaceName() { throw new RuntimeException("Stub!"); }

/** @hide */

public boolean canBeSatisfiedBy(@android.annotation.Nullable android.net.NetworkSpecifier other) { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param o This value may be {@code null}.
 */

public boolean equals(@android.annotation.Nullable java.lang.Object o) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.net.EthernetNetworkSpecifier> CREATOR;
static { CREATOR = null; }
}

