/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.net;


/**
 * This class represents a snapshot of the state of an IpSecTransform
 *
 * <p>This class provides the current state of an IpSecTransform, enabling link metric analysis by
 * the caller. Use cases include understanding transform usage, such as packet and byte counts, as
 * well as observing out-of-order delivery by checking the bitmap. Additionally, callers can query
 * IpSecTransformStates at two timestamps. By comparing the changes in packet counts and sequence
 * numbers, callers can estimate IPsec data loss in the inbound direction.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class IpSecTransformState implements android.os.Parcelable {

IpSecTransformState() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param out This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel out, int flags) { throw new RuntimeException("Stub!"); }

/**
 * Retrieve the timestamp (milliseconds) when this state was created, as per {@link android.os.SystemClock#elapsedRealtime  }
 *
 * @see android.net.IpSecTransformState.Builder#setTimestampMillis(long)
 */

public long getTimestampMillis() { throw new RuntimeException("Stub!"); }

/**
 * Retrieve the highest sequence number sent so far as an unsigned long
 *
 * @see android.net.IpSecTransformState.Builder#setTxHighestSequenceNumber(long)
 */

public long getTxHighestSequenceNumber() { throw new RuntimeException("Stub!"); }

/**
 * Retrieve the highest sequence number received so far as an unsigned long
 *
 * @see android.net.IpSecTransformState.Builder#setRxHighestSequenceNumber(long)
 */

public long getRxHighestSequenceNumber() { throw new RuntimeException("Stub!"); }

/**
 * Retrieve the number of packets processed so far as an unsigned long.
 *
 * <p>The packet count direction (inbound or outbound) aligns with the direction in which the
 * IpSecTransform is applied to.
 *
 * @see android.net.IpSecTransformState.Builder#setPacketCount(long)
 */

public long getPacketCount() { throw new RuntimeException("Stub!"); }

/**
 * Retrieve the number of bytes processed so far as an unsigned long
 *
 * <p>The byte count direction (inbound or outbound) aligns with the direction in which the
 * IpSecTransform is applied to.
 *
 * @see android.net.IpSecTransformState.Builder#setByteCount(long)
 */

public long getByteCount() { throw new RuntimeException("Stub!"); }

/**
 * Retrieve the replay bitmap
 *
 * <p>This bitmap represents a replay window, allowing the caller to observe out-of-order
 * delivery. The last bit represents the highest sequence number received so far and bits for
 * the received packets will be marked as true.
 *
 * <p>The size of a replay bitmap will never change over the lifetime of an IpSecTransform
 *
 * <p>The replay bitmap is solely useful for inbound IpSecTransforms. For outbound
 * IpSecTransforms, all bits will be unchecked.
 *
 * @see android.net.IpSecTransformState.Builder#setReplayBitmap(byte[])

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public byte[] getReplayBitmap() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.net.IpSecTransformState> CREATOR;
static { CREATOR = null; }
/**
 * Builder class for testing purposes
 *
 * <p>Except for testing, IPsec callers normally do not instantiate {@link android.net.IpSecTransformState IpSecTransformState}
 * themselves but instead get a reference via {@link android.net.IpSecTransformState IpSecTransformState}
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * Set the timestamp (milliseconds) when this state was created
 *
 * @see android.net.IpSecTransformState#getTimestampMillis()

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.IpSecTransformState.Builder setTimestampMillis(long timestamp) { throw new RuntimeException("Stub!"); }

/**
 * Set the highest sequence number sent so far as an unsigned long
 *
 * @see android.net.IpSecTransformState#getTxHighestSequenceNumber()

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.IpSecTransformState.Builder setTxHighestSequenceNumber(long seqNum) { throw new RuntimeException("Stub!"); }

/**
 * Set the highest sequence number received so far as an unsigned long
 *
 * @see android.net.IpSecTransformState#getRxHighestSequenceNumber()

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.IpSecTransformState.Builder setRxHighestSequenceNumber(long seqNum) { throw new RuntimeException("Stub!"); }

/**
 * Set the number of packets processed so far as an unsigned long
 *
 * @see android.net.IpSecTransformState#getPacketCount()

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.IpSecTransformState.Builder setPacketCount(long packetCount) { throw new RuntimeException("Stub!"); }

/**
 * Set the number of bytes processed so far as an unsigned long
 *
 * @see android.net.IpSecTransformState#getByteCount()

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.IpSecTransformState.Builder setByteCount(long byteCount) { throw new RuntimeException("Stub!"); }

/**
 * Set the replay bitmap
 *
 * @see android.net.IpSecTransformState#getReplayBitmap()
 
 * @param bitMap This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.IpSecTransformState.Builder setReplayBitmap(@android.annotation.NonNull byte[] bitMap) { throw new RuntimeException("Stub!"); }

/**
 * Build and validate the IpSecTransformState
 *
 * @return an immutable IpSecTransformState instance

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.IpSecTransformState build() { throw new RuntimeException("Stub!"); }
}

}

