// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.


package android.net.http;


/**
 * Exception passed to {@link android.net.http.UrlRequest.Callback#onFailed UrlRequest.Callback.onFailed()} when
 * {@link android.net.http.UrlRequest.Callback UrlRequest.Callback} or {@link android.net.http.UploadDataProvider UploadDataProvider} method throws an exception. In this
 * case {@link java.io.IOException#getCause getCause()} can be used to find the thrown exception.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract class CallbackException extends android.net.http.HttpException {

/**
 * Constructs an exception that wraps {@code cause} thrown by a {@link android.net.http.UrlRequest.Callback UrlRequest.Callback}.
 *
 * @param message explanation of failure.
 * @param cause exception thrown by {@link android.net.http.UrlRequest.Callback UrlRequest.Callback} that's being wrapped. It is
 *         saved
 * for later retrieval by the {@link java.io.IOException#getCause getCause()}.
 */

protected CallbackException(@android.annotation.Nullable java.lang.String message, @android.annotation.Nullable java.lang.Throwable cause) { super(null, null); throw new RuntimeException("Stub!"); }
}

