/*
 * Copyright (C) 2016 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.net.wifi.aware;


/**
 * The characteristics of the Wi-Fi Aware implementation.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class Characteristics implements android.os.Parcelable {

Characteristics() { throw new RuntimeException("Stub!"); }

/**
 * Returns the maximum string length that can be used to specify a Aware service name. Restricts
 * the parameters of the {@link android.net.wifi.aware.PublishConfig.Builder#setServiceName(java.lang.String) PublishConfig.Builder#setServiceName(String)} and
 * {@link android.net.wifi.aware.SubscribeConfig.Builder#setServiceName(java.lang.String) SubscribeConfig.Builder#setServiceName(String)}.
 *
 * @return A positive integer, maximum string length of Aware service name.
 */

public int getMaxServiceNameLength() { throw new RuntimeException("Stub!"); }

/**
 * Returns the maximum length of byte array that can be used to specify a Aware service specific
 * information field: the arbitrary load used in discovery or the message length of Aware
 * message exchange. Restricts the parameters of the
 * {@link android.net.wifi.aware.PublishConfig.Builder#setServiceSpecificInfo(byte[]) PublishConfig.Builder#setServiceSpecificInfo(byte[])},
 * {@link android.net.wifi.aware.SubscribeConfig.Builder#setServiceSpecificInfo(byte[]) SubscribeConfig.Builder#setServiceSpecificInfo(byte[])}, and
 * {@link android.net.wifi.aware.DiscoverySession#sendMessage(android.net.wifi.aware.PeerHandle,int,byte[]) DiscoverySession#sendMessage(PeerHandle, int, byte[])}
 * variants.
 *
 * @return A positive integer, maximum length of byte array for Aware messaging.
 */

public int getMaxServiceSpecificInfoLength() { throw new RuntimeException("Stub!"); }

/**
 * Returns the maximum length of byte array that can be used to specify a Aware match filter.
 * Restricts the parameters of the
 * {@link android.net.wifi.aware.PublishConfig.Builder#setMatchFilter(java.util.List) PublishConfig.Builder#setMatchFilter(java.util.List)} and
 * {@link android.net.wifi.aware.SubscribeConfig.Builder#setMatchFilter(java.util.List) SubscribeConfig.Builder#setMatchFilter(java.util.List)}.
 *
 * @return A positive integer, maximum length of byte array for Aware discovery match filter.
 */

public int getMaxMatchFilterLength() { throw new RuntimeException("Stub!"); }

/**
 * Returns the maximum number of Aware data interfaces supported by the device.
 *
 * @return A positive integer, maximum number of Aware data interfaces supported by the device.

 * Value is 1 or greater
 */

public int getNumberOfSupportedDataInterfaces() { throw new RuntimeException("Stub!"); }

/**
 * Returns the maximum number of Aware publish sessions supported by the device.
 * Use {@link android.net.wifi.aware.AwareResources#getAvailablePublishSessionsCount() AwareResources#getAvailablePublishSessionsCount()} to get the number of available
 * publish sessions which are not currently used by any app.
 *
 * @return A positive integer, maximum number of publish sessions supported by the device.

 * Value is 1 or greater
 */

public int getNumberOfSupportedPublishSessions() { throw new RuntimeException("Stub!"); }

/**
 * Returns the maximum number of Aware subscribe session supported by the device.
 * Use {@link android.net.wifi.aware.AwareResources#getAvailableSubscribeSessionsCount() AwareResources#getAvailableSubscribeSessionsCount()} to get the number of
 * available subscribe sessions which are not currently used by any app.
 *
 * @return A positive integer, maximum number of subscribe sessions supported by the device.

 * Value is 1 or greater
 */

public int getNumberOfSupportedSubscribeSessions() { throw new RuntimeException("Stub!"); }

/**
 * Returns the maximum number of Aware data paths(also known as NDPs - NAN Data Paths) supported
 * by the device.
 * Use {@link android.net.wifi.aware.AwareResources#getAvailableDataPathsCount() AwareResources#getAvailableDataPathsCount()} to get the number of available Aware
 * data paths which are not currently used by any app.
 *
 * @return A positive integer, maximum number of Aware data paths supported by the device.

 * Value is 1 or greater
 */

public int getNumberOfSupportedDataPaths() { throw new RuntimeException("Stub!"); }

/**
 * Check if instant communication mode is supported by device. The instant communication mode is
 * defined as per Wi-Fi Alliance (WFA) Wi-Fi Aware specifications version 3.1 Section 12.3.
 * @return True if supported, false otherwise.
 */

public boolean isInstantCommunicationModeSupported() { throw new RuntimeException("Stub!"); }

/**
 * Check if the Aware Pairing is supported. The Aware Pairing is defined as per Wi-Fi Alliance
 * (WFA) Wi-Fi Aware specifications version 4.0 Section 7.6.
 * @return True if supported, false otherwise.
 */

public boolean isAwarePairingSupported() { throw new RuntimeException("Stub!"); }

/**
 * Check if Aware Suspension is supported. Aware Suspension is a mechanism of putting an Aware
 * connection in and out of a low-power mode while preserving the discovery sessions and data
 * paths.
 * @return True if supported, false otherwise.
 */

public boolean isSuspensionSupported() { throw new RuntimeException("Stub!"); }

/**
 * Returns the set of cipher suites supported by the device for use in Wi-Fi Aware data-paths.
 * The device automatically picks the strongest cipher suite when initiating a data-path setup.
 *
 * @return A set of flags from {@link #WIFI_AWARE_CIPHER_SUITE_NCS_SK_128},
 * {@link #WIFI_AWARE_CIPHER_SUITE_NCS_SK_256}, {@link #WIFI_AWARE_CIPHER_SUITE_NCS_PK_128},
 * or {@link #WIFI_AWARE_CIPHER_SUITE_NCS_PK_256}

 * Value is either <code>0</code> or a combination of {@link android.net.wifi.aware.Characteristics#WIFI_AWARE_CIPHER_SUITE_NONE}, {@link android.net.wifi.aware.Characteristics#WIFI_AWARE_CIPHER_SUITE_NCS_SK_128}, {@link android.net.wifi.aware.Characteristics#WIFI_AWARE_CIPHER_SUITE_NCS_SK_256}, {@link android.net.wifi.aware.Characteristics#WIFI_AWARE_CIPHER_SUITE_NCS_PK_128}, and {@link android.net.wifi.aware.Characteristics#WIFI_AWARE_CIPHER_SUITE_NCS_PK_256}
 */

public int getSupportedCipherSuites() { throw new RuntimeException("Stub!"); }

/**
 * Returns the set of cipher suites supported by the device for use in Wi-Fi Aware pairing.
 *
 * @return A set of flags from {@link #WIFI_AWARE_CIPHER_SUITE_NCS_PK_PASN_256},
 * or {@link #WIFI_AWARE_CIPHER_SUITE_NCS_PK_PASN_256}

 * Value is either <code>0</code> or a combination of {@link android.net.wifi.aware.Characteristics#WIFI_AWARE_CIPHER_SUITE_NCS_PK_PASN_128}, and {@link android.net.wifi.aware.Characteristics#WIFI_AWARE_CIPHER_SUITE_NCS_PK_PASN_256}
 */

public int getSupportedPairingCipherSuites() { throw new RuntimeException("Stub!"); }

public void writeToParcel(android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.net.wifi.aware.Characteristics> CREATOR;
static { CREATOR = null; }

/**
 * Wi-Fi Aware supported cipher suite representing NCS PK 2WDH 128: 128 bit public-key.
 */

public static final int WIFI_AWARE_CIPHER_SUITE_NCS_PK_128 = 4; // 0x4

/**
 * Wi-Fi Aware supported cipher suite representing NCS 2WDH 256: 256 bit public-key.
 */

public static final int WIFI_AWARE_CIPHER_SUITE_NCS_PK_256 = 8; // 0x8

/**
 * Wi-Fi Aware supported cipher suite representing NCS PASN 128: 128 bit public-key.
 */

public static final int WIFI_AWARE_CIPHER_SUITE_NCS_PK_PASN_128 = 16; // 0x10

/**
 * Wi-Fi Aware supported cipher suite representing NCS PASN 256: 256 bit public-key.
 */

public static final int WIFI_AWARE_CIPHER_SUITE_NCS_PK_PASN_256 = 32; // 0x20

/**
 * Wi-Fi Aware supported cipher suite representing NCS SK 128: 128 bit shared-key.
 */

public static final int WIFI_AWARE_CIPHER_SUITE_NCS_SK_128 = 1; // 0x1

/**
 * Wi-Fi Aware supported cipher suite representing NCS SK 256: 256 bit shared-key.
 */

public static final int WIFI_AWARE_CIPHER_SUITE_NCS_SK_256 = 2; // 0x2

/**
 * Wi-Fi Aware supported open (unencrypted) data-path.
 */

public static final int WIFI_AWARE_CIPHER_SUITE_NONE = 0; // 0x0
}

