/**
 * Copyright (c) 2016, The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.net.wifi.hotspot2;

import android.net.wifi.WifiManager;
import android.net.wifi.hotspot2.pps.Credential;
import android.net.wifi.hotspot2.pps.HomeSp;

/**
 * Class representing Passpoint configuration.  This contains configurations specified in
 * PerProviderSubscription (PPS) Management Object (MO) tree.
 *
 * For more info, refer to Hotspot 2.0 PPS MO defined in section 9.1 of the Hotspot 2.0
 * Release 2 Technical Specification.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class PasspointConfiguration implements android.os.Parcelable {

/**
 * Constructor for creating PasspointConfiguration with default values.
 */

public PasspointConfiguration() { throw new RuntimeException("Stub!"); }

/**
 * Copy constructor.
 *
 * @param source The source to copy from
 */

public PasspointConfiguration(android.net.wifi.hotspot2.PasspointConfiguration source) { throw new RuntimeException("Stub!"); }

/**
 * Set the Home SP (Service Provider) information.
 *
 * @param homeSp The Home SP information to set to
 */

public void setHomeSp(android.net.wifi.hotspot2.pps.HomeSp homeSp) { throw new RuntimeException("Stub!"); }

/**
 * Get the Home SP (Service Provider) information.
 *
 * @return Home SP information
 */

public android.net.wifi.hotspot2.pps.HomeSp getHomeSp() { throw new RuntimeException("Stub!"); }

/**
 * Set the credential information.
 *
 * @param credential The credential information to set to
 */

public void setCredential(android.net.wifi.hotspot2.pps.Credential credential) { throw new RuntimeException("Stub!"); }

/**
 * Get the credential information.
 *
 * @return credential information
 */

public android.net.wifi.hotspot2.pps.Credential getCredential() { throw new RuntimeException("Stub!"); }

/**
 * Utility method to set the time this subscription will expire. The framework will not attempt
 * to auto-connect to networks using expired subscriptions.
 * @param subscriptionExpirationTimeInMillis The expiration time in the format of number of
 *                                           milliseconds since January 1, 1970, 00:00:00 GMT,
 *                                           or {@link java.lang.Long#MIN_VALUE Long#MIN_VALUE} to unset.

 * Value is a non-negative timestamp measured as the number of
 * milliseconds since 1970-01-01T00:00:00Z.
 */

public void setSubscriptionExpirationTimeInMillis(long subscriptionExpirationTimeInMillis) { throw new RuntimeException("Stub!"); }

/**
 *  Utility method to get the time this subscription will expire. It is in the format of number
 *  of milliseconds since January 1, 1970, 00:00:00 GMT.
 *
 *
 * <br>
 * Value is a non-negative timestamp measured as the number of
 * milliseconds since 1970-01-01T00:00:00Z.
 * @return The time this subscription will expire, or Long.MIN_VALUE to indicate unset value

 * Value is a non-negative timestamp measured as the number of
 * milliseconds since 1970-01-01T00:00:00Z.
 */

public long getSubscriptionExpirationTimeMillis() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public void writeToParcel(android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object thatObject) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/**
 * Indicates if the Passpoint Configuration was provisioned by a subscription (OSU) server,
 * which means that it's an R2 (or R3) profile.
 *
 * @return true if the Passpoint Configuration was provisioned by a subscription server.
 */

public boolean isOsuProvisioned() { throw new RuntimeException("Stub!"); }

/**
 * Get a unique identifier for a PasspointConfiguration object. The identifier depends on the
 * configuration that identify the service provider under the HomeSp subtree, and on the
 * credential configuration under the Credential subtree.
 * The method throws an {@link java.lang.IllegalStateException IllegalStateException} if the configuration under HomeSp subtree
 * or the configuration under Credential subtree are not initialized.
 *
 * @return A unique identifier

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String getUniqueId() { throw new RuntimeException("Stub!"); }

/**
 * Set a prefix for a decorated identity as per RFC 7542.
 * This prefix must contain a list of realms (could be a list of 1) delimited by a '!'
 * character. e.g. homerealm.example.org! or proxyrealm.example.net!homerealm.example.org!
 * A prefix of "homerealm.example.org!" will generate a decorated identity that
 * looks like: homerealm.example.org!user@otherrealm.example.net
 * Calling with a null parameter will clear the decorated prefix.
 * Note: Caller must verify that the device supports this feature by calling
 * {@link android.net.wifi.WifiManager#isDecoratedIdentitySupported() WifiManager#isDecoratedIdentitySupported()}
 *
 * @param decoratedIdentityPrefix The prefix to add to the outer/anonymous identity

 * This value may be {@code null}.
 */

public void setDecoratedIdentityPrefix(@android.annotation.Nullable java.lang.String decoratedIdentityPrefix) { throw new RuntimeException("Stub!"); }

/**
 * Get the decorated identity prefix.
 *
 * @return The decorated identity prefix

 * This value may be {@code null}.
 */

@android.annotation.Nullable
public java.lang.String getDecoratedIdentityPrefix() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.net.wifi.hotspot2.PasspointConfiguration> CREATOR;
static { CREATOR = null; }
}

