/*
 * Copyright (C) 2017 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.net.wifi.rtt;

import android.net.wifi.ScanResult;
import android.net.wifi.aware.AttachCallback;
import android.net.wifi.aware.DiscoverySessionCallback;
import android.net.wifi.aware.IdentityChangedListener;
import android.net.wifi.aware.PeerHandle;
import android.net.wifi.aware.WifiAwareManager;
import android.os.Handler;
import java.util.List;

/**
 * Defines the ranging request to other devices. The ranging request is built using
 * {@link android.net.wifi.rtt.RangingRequest.Builder RangingRequest.Builder}.
 * A ranging request is executed using
 * {@link android.net.wifi.rtt.WifiRttManager#startRanging(android.net.wifi.rtt.RangingRequest,java.util.concurrent.Executor,android.net.wifi.rtt.RangingResultCallback) WifiRttManager#startRanging(RangingRequest, java.util.concurrent.Executor, RangingResultCallback)}.
 * <p>
 * The ranging request is a batch request - specifying a set of devices (specified using
 * {@link android.net.wifi.rtt.RangingRequest.Builder#addAccessPoint(android.net.wifi.ScanResult) RangingRequest.Builder#addAccessPoint(ScanResult)} and
 * {@link android.net.wifi.rtt.RangingRequest.Builder#addAccessPoints(java.util.List) RangingRequest.Builder#addAccessPoints(List)}).
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class RangingRequest implements android.os.Parcelable {

RangingRequest() { throw new RuntimeException("Stub!"); }

/**
 * Returns the maximum number of peers to range which can be specified in a single {@code
 * RangingRequest}. The limit applies no matter how the peers are added to the request, e.g.
 * through {@link android.net.wifi.rtt.RangingRequest.Builder#addAccessPoint(android.net.wifi.ScanResult) RangingRequest.Builder#addAccessPoint(ScanResult)} or
 * {@link android.net.wifi.rtt.RangingRequest.Builder#addAccessPoints(java.util.List) RangingRequest.Builder#addAccessPoints(List)}.
 *
 * @return Maximum number of peers.
 */

public static int getMaxPeers() { throw new RuntimeException("Stub!"); }

/**
 * Returns the default RTT burst size used to determine the average range.
 *
 * @return the RTT burst size used by default
 */

public static int getDefaultRttBurstSize() { throw new RuntimeException("Stub!"); }

/**
 * Returns the minimum RTT burst size that can be used to determine a average range.
 *
 * @return the minimum RTT burst size that can be used
 */

public static int getMinRttBurstSize() { throw new RuntimeException("Stub!"); }

/**
 * Returns the minimum RTT burst size that can be used to determine a average range.
 *
 * @return the maximum RTT burst size that can be used
 */

public static int getMaxRttBurstSize() { throw new RuntimeException("Stub!"); }

/**
 * Returns the RTT burst size used to determine the average range.
 *
 * @return the RTT burst size used
 */

public int getRttBurstSize() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public void writeToParcel(android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

/** @hide */

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param o This value may be {@code null}.
 */

public boolean equals(@android.annotation.Nullable java.lang.Object o) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.net.wifi.rtt.RangingRequest> CREATOR;
static { CREATOR = null; }
/**
 * Builder class used to construct {@link android.net.wifi.rtt.RangingRequest RangingRequest} objects.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * Set the RTT Burst size for the ranging request.
 * <p>
 * If not set, the default RTT burst size given by
 * {@link #getDefaultRttBurstSize()} is used to determine the default value.
 * If set, the value must be in the range {@link #getMinRttBurstSize()} and
 * {@link #getMaxRttBurstSize()} inclusively, or a
 * {@link java.lang.IllegalArgumentException} will be thrown.
 *
 * Note: RTT burst size is applicable to IEEE 802.11mc, and for one special case it is
 * also applicable to IEEE 802.11az to generate multiple NTB ranging requests per
 * measurement. It is applicable for IEEE 802.11az based ranging requests when MIMO is
 * not available, with the transmit and receive spatial streams between the initiator and
 * responder station is equal to 1. See
 * {@link android.net.wifi.rtt.RangingResult#get80211azNumberOfRxSpatialStreams() RangingResult#get80211azNumberOfRxSpatialStreams()} and
 * {@link android.net.wifi.rtt.RangingResult#get80211azNumberOfTxSpatialStreams() RangingResult#get80211azNumberOfTxSpatialStreams()}.
 *
 * @param rttBurstSize The number of FTM packets used to estimate a range.
 * @return The builder to facilitate chaining
 * {@code builder.setXXX(..).setXXX(..)}.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.wifi.rtt.RangingRequest.Builder setRttBurstSize(int rttBurstSize) { throw new RuntimeException("Stub!"); }

/**
 * Add the device specified by the {@link android.net.wifi.ScanResult ScanResult} to the list of devices with
 * which to measure range. The total number of peers added to a request cannot exceed the
 * limit specified by {@link #getMaxPeers()}.
 * <p>
 * Two-sided Ranging will be performed if the local device and the AP support IEEE 802.11az
 * (non-trigger based ranging) or IEEE 802.11mc. AP capability is determined by the method
 * {@link android.net.wifi.ScanResult#is80211azNtbResponder() ScanResult#is80211azNtbResponder()} or {@link android.net.wifi.ScanResult#is80211mcResponder() ScanResult#is80211mcResponder()}.
 *
 * If both 11az and 11mc are supported by the local device and the AP, 11az non-trigger
 * based ranging will be performed.
 *
 * If two-sided ranging is not supported, one-sided RTT will be performed with no
 * correction for the AP packet turnaround time.
 *
 * @param apInfo Information about an Access Point (AP) obtained in a Scan Result.
 * This value cannot be {@code null}.
 * @return The builder to facilitate chaining
 *         {@code builder.setXXX(..).setXXX(..)}.
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.wifi.rtt.RangingRequest.Builder addAccessPoint(@android.annotation.NonNull android.net.wifi.ScanResult apInfo) { throw new RuntimeException("Stub!"); }

/**
 * Add the devices specified by the {@link android.net.wifi.ScanResult ScanResult}s to the list of devices with
 * which to measure range. The total number of peers added to a request cannot exceed the
 * limit specified by {@link #getMaxPeers()}.
 * <p>
 * Two-sided Ranging will be performed if the local device and the AP support IEEE 802.11az
 * (non-trigger based ranging) or IEEE 802.11mc. AP capability is determined by the method
 * {@link android.net.wifi.ScanResult#is80211azNtbResponder() ScanResult#is80211azNtbResponder()} or {@link android.net.wifi.ScanResult#is80211mcResponder() ScanResult#is80211mcResponder()}.
 *
 * If both 11az and 11mc are supported by the local device and the AP, 11az non-trigger
 * based ranging will be performed.
 *
 * If two-sided ranging is not supported, one-sided RTT will be performed with no
 * correction for the AP packet turnaround time.
 *
 * @param apInfos Information about Access Points (APs) obtained in a Scan Result.
 * This value cannot be {@code null}.
 * @return The builder to facilitate chaining
 *         {@code builder.setXXX(..).setXXX(..)}.
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.wifi.rtt.RangingRequest.Builder addAccessPoints(@android.annotation.NonNull java.util.List<android.net.wifi.ScanResult> apInfos) { throw new RuntimeException("Stub!"); }

/**
 * Add the Responder device specified by the {@link android.net.wifi.rtt.ResponderConfig ResponderConfig} to the list of devices
 * with which to measure range. The total number of peers added to the request cannot exceed
 * the limit specified by {@link #getMaxPeers()}.
 * <p>
 * Two-sided Ranging will be performed if the local device and the AP support IEEE 802.11az
 * (non-trigger based ranging) or IEEE 802.11mc. AP capability is determined by the method
 * {@link android.net.wifi.ScanResult#is80211azNtbResponder() ScanResult#is80211azNtbResponder()} or {@link android.net.wifi.ScanResult#is80211mcResponder() ScanResult#is80211mcResponder()}.
 *
 * If both 11az and 11mc are supported by the local device and the AP, 11az non-trigger
 * based ranging will be performed.
 *
 * If two-sided ranging is not supported, one-sided RTT will be performed with no
 * correction for the AP packet turnaround time.
 *
 * @param responder Information on the RTT Responder.
 * This value cannot be {@code null}.
 * @return The builder, to facilitate chaining {@code builder.setXXX(..).setXXX(..)}.
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.wifi.rtt.RangingRequest.Builder addResponder(@android.annotation.NonNull android.net.wifi.rtt.ResponderConfig responder) { throw new RuntimeException("Stub!"); }

/**
 * Add the devices specified by the {@link android.net.wifi.rtt.ResponderConfig ResponderConfig}s to the list of devices with
 * which to measure range. The total number of peers added to a request cannot exceed the
 * limit specified by {@link #getMaxPeers()}.
 * <p>
 * Two-sided Ranging will be performed if the local device and the AP support IEEE 802.11az
 * (non-trigger based ranging) or IEEE 802.11mc. AP capability is determined by the method
 * {@link android.net.wifi.ScanResult#is80211azNtbResponder() ScanResult#is80211azNtbResponder()} or {@link android.net.wifi.ScanResult#is80211mcResponder() ScanResult#is80211mcResponder()}.
 *
 * If both 11az and 11mc are supported by the local device and the AP, 11az non-trigger
 * based ranging will be performed.
 *
 * If two-sided ranging is not supported, one-sided RTT will be performed with no
 * correction for the AP packet turnaround time.
 *
 * @param responders Information representing the set of access points to be ranged
 * This value cannot be {@code null}.
 * @return The builder to facilitate chaining
 *         {@code builder.setXXX(..).setXXX(..)}.
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.wifi.rtt.RangingRequest.Builder addResponders(@android.annotation.NonNull java.util.List<android.net.wifi.rtt.ResponderConfig> responders) { throw new RuntimeException("Stub!"); }

/**
 * Add the non-802.11mc and non-802.11az capable device specified by the {@link android.net.wifi.ScanResult ScanResult}
 * to the list of devices with which to measure range. The total number of peers added to a
 * request cannot exceed the limit specified by {@link #getMaxPeers()}.
 * <p>
 * Accurate ranging cannot be supported if the Access Point does not support IEEE 802.11mc
 * and IEEE 802.11az, and instead an alternate protocol called one-sided RTT will be used
 * with lower accuracy. Use {@link android.net.wifi.ScanResult#is80211mcResponder() ScanResult#is80211mcResponder()} to verify the Access
 * Point(s) are not 802.11mc capable. Use {@link android.net.wifi.ScanResult#is80211azNtbResponder() ScanResult#is80211azNtbResponder()} ()} to
 * verify the Access Point)s) are not 802.11az capable.
 * <p>
 * One-sided RTT does not subtract the RTT turnaround time at the Access Point, which can
 * add hundreds of meters to the estimate. With experimentation, it is possible to use this
 * information to make a statistical estimate of the range by taking multiple measurements
 * to several Access Points and normalizing the result. For some applications this can be
 * used to improve range estimates based on Receive Signal Strength Indication (RSSI), but
 * will not be as accurate as IEEE 802.11mc (two-sided RTT).
 * <p>
 * Note: one-sided RTT should only be used if you are very familiar with statistical
 * estimation techniques.
 *
 * @param apInfo Information about an Access Point (AP) obtained in a Scan Result
 * This value cannot be {@code null}.
 * @return The builder to facilitate chaining
 *         {@code builder.setXXX(..).setXXX(..)}.
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.wifi.rtt.RangingRequest.Builder addNon80211mcCapableAccessPoint(@android.annotation.NonNull android.net.wifi.ScanResult apInfo) { throw new RuntimeException("Stub!"); }

/**
 * Add the non-802.11mc and non-802.11az capable devices specified by the {@link android.net.wifi.ScanResult ScanResult}
 * to the list of devices with which to measure range. The total number of peers added to a
 * request cannot exceed the limit specified by {@link #getMaxPeers()}.
 * <p>
 * Accurate ranging cannot be supported if the Access Point does not support IEEE 802.11mc
 * and IEEE 802.11az, and instead an alternate protocol called one-sided RTT will be used
 * with lower accuracy. Use {@link android.net.wifi.ScanResult#is80211mcResponder() ScanResult#is80211mcResponder()} to verify the Access
 * Point(s) are not 802.11mc capable. Use {@link android.net.wifi.ScanResult#is80211azNtbResponder() ScanResult#is80211azNtbResponder()} ()} to
 * verify the Access Point(s) are not 802.11az capable.
 * <p>
 * One-sided RTT does not subtract the RTT turnaround time at the Access Point, which can
 * add hundreds of meters to the estimate. With experimentation, it is possible to use this
 * information to make a statistical estimate of the range by taking multiple measurements
 * to several Access Points and normalizing the result. For some applications this can be
 * used to improve range estimates based on Receive Signal Strength Indication (RSSI), but
 * will not be as accurate as IEEE 802.11mc (two-sided RTT).
 * <p>
 * Note: one-sided RTT should only be used if you are very familiar with statistical
 * estimation techniques.
 *
 * @param apInfos Information about Access Points (APs) obtained in a Scan Result.
 * This value cannot be {@code null}.
 * @return The builder to facilitate chaining
 *         {@code builder.setXXX(..).setXXX(..)}.
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.wifi.rtt.RangingRequest.Builder addNon80211mcCapableAccessPoints(@android.annotation.NonNull java.util.List<android.net.wifi.ScanResult> apInfos) { throw new RuntimeException("Stub!"); }

/**
 * Add the device specified by the {@code peerMacAddress} to the list of devices with
 * which to measure range.
 * <p>
 * The MAC address may be obtained out-of-band from a peer Wi-Fi Aware device. A Wi-Fi
 * Aware device may obtain its MAC address using the {@link android.net.wifi.aware.IdentityChangedListener IdentityChangedListener}
 * provided to
 * {@link android.net.wifi.aware.WifiAwareManager#attach(android.net.wifi.aware.AttachCallback,android.net.wifi.aware.IdentityChangedListener,android.os.Handler) WifiAwareManager#attach(AttachCallback, IdentityChangedListener, Handler)}.
 * <p>
 * Note: in order to use this API the device must support Wi-Fi Aware
 * {@link android.net.wifi.aware}. The peer device which is being ranged to must be
 * configured to publish a service (with any name) with:
 * <li>Type {@link android.net.wifi.aware.PublishConfig#PUBLISH_TYPE_UNSOLICITED}.
 * <li>Ranging enabled
 * {@link android.net.wifi.aware.PublishConfig.Builder#setRangingEnabled(boolean)}.
 *
 * @param peerMacAddress The MAC address of the Wi-Fi Aware peer.
 * This value cannot be {@code null}.
 * @return The builder, to facilitate chaining {@code builder.setXXX(..).setXXX(..)}.
 */

public android.net.wifi.rtt.RangingRequest.Builder addWifiAwarePeer(@android.annotation.NonNull android.net.MacAddress peerMacAddress) { throw new RuntimeException("Stub!"); }

/**
 * Add a device specified by a {@link android.net.wifi.aware.PeerHandle PeerHandle} to the list of devices with which to
 * measure range.
 * <p>
 * The {@link android.net.wifi.aware.PeerHandle PeerHandle} may be obtained as part of the Wi-Fi Aware discovery process. E.g.
 * using {@link android.net.wifi.aware.DiscoverySessionCallback#onServiceDiscovered(android.net.wifi.aware.PeerHandle,byte[],java.util.List) DiscoverySessionCallback#onServiceDiscovered(PeerHandle, byte[], List)}.
 * <p>
 * Note: in order to use this API the device must support Wi-Fi Aware
 * {@link android.net.wifi.aware}. The requesting device can be either publisher or
 * subscriber in a discovery session. For both requesting device and peer device ranging
 * must be enabled on the discovery session:
 * <li>{@link android.net.wifi.aware.PublishConfig.Builder#setRangingEnabled(boolean)} for
 * publisher.</li>
 * <li>Either {@link android.net.wifi.aware.SubscribeConfig.Builder#setMinDistanceMm(int)}
 * or {@link android.net.wifi.aware.SubscribeConfig.Builder#setMaxDistanceMm(int)} must be
 * set to enable ranging on subscriber </li>
 *
 * @param peerHandle The peer handler of the peer Wi-Fi Aware device.
 * This value cannot be {@code null}.
 * @return The builder, to facilitate chaining {@code builder.setXXX(..).setXXX(..)}.
 */

public android.net.wifi.rtt.RangingRequest.Builder addWifiAwarePeer(@android.annotation.NonNull android.net.wifi.aware.PeerHandle peerHandle) { throw new RuntimeException("Stub!"); }

/**
 * Build {@link android.net.wifi.rtt.RangingRequest RangingRequest} given the current configurations made on the
 * builder.
 */

public android.net.wifi.rtt.RangingRequest build() { throw new RuntimeException("Stub!"); }
}

}

