/*
 * Copyright (C) 2018 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.net.wifi.rtt;

import android.content.Context;
import android.net.wifi.ScanResult;
import android.os.Bundle;
import java.util.List;
import java.util.concurrent.Executor;

/**
 * This class provides the primary API for measuring distance (range) to other devices using the
 * IEEE 802.11mc Wi-Fi Round Trip Time (RTT) technology.
 * <p>
 * The devices which can be ranged include:
 * <li>Access Points (APs)
 * <li>Wi-Fi Aware peers
 * <p>
 * Ranging requests are triggered using
 * {@link #startRanging(android.net.wifi.rtt.RangingRequest,java.util.concurrent.Executor,android.net.wifi.rtt.RangingResultCallback)}. Results (in case of
 * successful operation) are returned in the {@link android.net.wifi.rtt.RangingResultCallback#onRangingResults(java.util.List) RangingResultCallback#onRangingResults(List)}
 * callback.
 * <p>
 *     Wi-Fi RTT may not be usable at some points, e.g. when Wi-Fi is disabled. To validate that
 *     the functionality is available use the {@link #isAvailable()} function. To track
 *     changes in RTT usability register for the {@link #ACTION_WIFI_RTT_STATE_CHANGED}
 *     broadcast. Note that this broadcast is not sticky - you should register for it and then
 *     check the above API to avoid a race condition.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class WifiRttManager {

WifiRttManager() { throw new RuntimeException("Stub!"); }

/**
 * Returns the current status of RTT API: whether or not RTT is available. To track
 * changes in the state of RTT API register for the
 * {@link #ACTION_WIFI_RTT_STATE_CHANGED} broadcast.
 * <p>Note: availability of RTT does not mean that the app can use the API. The app's
 * permissions and platform Location Mode are validated at run-time.
 *
 * @return A boolean indicating whether the app can use the RTT API at this time (true) or
 * not (false).
 */

public boolean isAvailable() { throw new RuntimeException("Stub!"); }

/**
 * Initiate a request to range to a set of devices specified in the {@link android.net.wifi.rtt.RangingRequest RangingRequest}.
 * Results will be returned in the {@link android.net.wifi.rtt.RangingResultCallback RangingResultCallback} set of callbacks.
 * <p>
 * Ranging request with only Wifi Aware peers can be performed with either
 * {@link android.Manifest.permission#NEARBY_WIFI_DEVICES} with
 * android:usesPermissionFlags="neverForLocation", or
 * {@link android.Manifest.permission#ACCESS_FINE_LOCATION}. All other types of ranging requests
 * require {@link android.Manifest.permission#ACCESS_FINE_LOCATION}.
 *
 * <br>
 * Requires {@link android.Manifest.permission#ACCESS_FINE_LOCATION} and {@link android.Manifest.permission#CHANGE_WIFI_STATE} and {@link android.Manifest.permission#ACCESS_WIFI_STATE} and {@link android.Manifest.permission#NEARBY_WIFI_DEVICES}
 * @param request  A request specifying a set of devices whose distance measurements are
 *                 requested.
 * This value cannot be {@code null}.
 * @param executor The Executor on which to run the callback.
 * This value cannot be {@code null}.
 * Callback and listener events are dispatched through this
 * {@link java.util.concurrent.Executor Executor}, providing an easy way to control which thread is
 * used. To dispatch events through the main thread of your
 * application, you can use
 * {@link android.content.Context#getMainExecutor() Context.getMainExecutor()}.
 * Otherwise, provide an {@link java.util.concurrent.Executor Executor} that dispatches to an appropriate thread.
 * @param callback A callback for the result of the ranging request.

 * This value cannot be {@code null}.
 */

public void startRanging(@android.annotation.NonNull android.net.wifi.rtt.RangingRequest request, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.net.wifi.rtt.RangingResultCallback callback) { throw new RuntimeException("Stub!"); }

/**
 * Returns a Bundle which represents the characteristics of the Wi-Fi RTT interface: a set of
 * parameters which specify feature support. Each parameter can be accessed by the specified
 * Bundle key, one of the {@code CHARACTERISTICS_KEY_*} value.
 * <p>
 * May return an empty Bundle if the Wi-Fi RTT service is not initialized.
 *
 * <br>
 * Requires {@link android.Manifest.permission#ACCESS_WIFI_STATE}
 * @return A Bundle specifying feature support of RTT.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.os.Bundle getRttCharacteristics() { throw new RuntimeException("Stub!"); }

/**
 * Broadcast intent action to indicate that the state of Wi-Fi RTT availability has changed.
 * Use the {@link #isAvailable()} to query the current status.
 * This broadcast is <b>not</b> sticky, use the {@link #isAvailable()} API after registering
 * the broadcast to check the current state of Wi-Fi RTT.
 * <p>Note: The broadcast is only delivered to registered receivers - no manifest registered
 * components will be launched.
 */

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.BROADCAST_INTENT_ACTION) public static final java.lang.String ACTION_WIFI_RTT_STATE_CHANGED = "android.net.wifi.rtt.action.WIFI_RTT_STATE_CHANGED";

/**
 * Bundle key to access if getting the Location Configuration Information(LCI) from responder is
 * supported.
 * @see android.net.wifi.rtt.ResponderLocation
 */

public static final java.lang.String CHARACTERISTICS_KEY_BOOLEAN_LCI = "key_lci";

/**
 * Bundle key to access if getting the Location Civic Report(LCR) from responder is supported.
 * @see android.net.wifi.rtt.ResponderLocation
 */

public static final java.lang.String CHARACTERISTICS_KEY_BOOLEAN_LCR = "key_lcr";

/**
 * Bundle key to access if device supports to be a IEEE 802.11az non-trigger based initiator
 */

public static final java.lang.String CHARACTERISTICS_KEY_BOOLEAN_NTB_INITIATOR = "key_ntb_initiator";

/**
 * Bundle key to access if one-sided Wi-Fi RTT is supported. When it is not supported, only
 * two-sided RTT can be performed, which requires responder supports IEEE 802.11mc and this can
 * be determined by the method {@link android.net.wifi.ScanResult#is80211mcResponder() ScanResult#is80211mcResponder()}
 */

public static final java.lang.String CHARACTERISTICS_KEY_BOOLEAN_ONE_SIDED_RTT = "key_one_sided_rtt";

/**
 * Bundle key to access if device supports to be a responder in station mode
 */

public static final java.lang.String CHARACTERISTICS_KEY_BOOLEAN_STA_RESPONDER = "key_sta_responder";
}

