/*
 * Copyright (C) 2007 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.view;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class MotionEvent extends android.view.InputEvent implements android.os.Parcelable {

MotionEvent() { throw new RuntimeException("Stub!"); }

protected void finalize() throws java.lang.Throwable { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public static android.view.MotionEvent obtain(long downTime, long eventTime, int action, int pointerCount, @android.annotation.NonNull android.view.MotionEvent.PointerProperties[] pointerProperties, @android.annotation.NonNull android.view.MotionEvent.PointerCoords[] pointerCoords, int metaState, int buttonState, float xPrecision, float yPrecision, int deviceId, int edgeFlags, int source, int displayId, int flags, int classification) { throw new RuntimeException("Stub!"); }

public static android.view.MotionEvent obtain(long downTime, long eventTime, int action, int pointerCount, android.view.MotionEvent.PointerProperties[] pointerProperties, android.view.MotionEvent.PointerCoords[] pointerCoords, int metaState, int buttonState, float xPrecision, float yPrecision, int deviceId, int edgeFlags, int source, int flags) { throw new RuntimeException("Stub!"); }

@Deprecated
public static android.view.MotionEvent obtain(long downTime, long eventTime, int action, int pointerCount, int[] pointerIds, android.view.MotionEvent.PointerCoords[] pointerCoords, int metaState, float xPrecision, float yPrecision, int deviceId, int edgeFlags, int source, int flags) { throw new RuntimeException("Stub!"); }

public static android.view.MotionEvent obtain(long downTime, long eventTime, int action, float x, float y, float pressure, float size, int metaState, float xPrecision, float yPrecision, int deviceId, int edgeFlags) { throw new RuntimeException("Stub!"); }

@Deprecated
public static android.view.MotionEvent obtain(long downTime, long eventTime, int action, int pointerCount, float x, float y, float pressure, float size, int metaState, float xPrecision, float yPrecision, int deviceId, int edgeFlags) { throw new RuntimeException("Stub!"); }

public static android.view.MotionEvent obtain(long downTime, long eventTime, int action, float x, float y, int metaState) { throw new RuntimeException("Stub!"); }

public static android.view.MotionEvent obtain(android.view.MotionEvent other) { throw new RuntimeException("Stub!"); }

public static android.view.MotionEvent obtainNoHistory(android.view.MotionEvent other) { throw new RuntimeException("Stub!"); }

public void recycle() { throw new RuntimeException("Stub!"); }

public int getDeviceId() { throw new RuntimeException("Stub!"); }

public int getSource() { throw new RuntimeException("Stub!"); }

public void setSource(int source) { throw new RuntimeException("Stub!"); }

public int getAction() { throw new RuntimeException("Stub!"); }

public int getActionMasked() { throw new RuntimeException("Stub!"); }

public int getActionIndex() { throw new RuntimeException("Stub!"); }

public int getFlags() { throw new RuntimeException("Stub!"); }

public long getDownTime() { throw new RuntimeException("Stub!"); }

public long getEventTime() { throw new RuntimeException("Stub!"); }

public long getEventTimeNanos() { throw new RuntimeException("Stub!"); }

public float getX() { throw new RuntimeException("Stub!"); }

public float getY() { throw new RuntimeException("Stub!"); }

public float getPressure() { throw new RuntimeException("Stub!"); }

public float getSize() { throw new RuntimeException("Stub!"); }

public float getTouchMajor() { throw new RuntimeException("Stub!"); }

public float getTouchMinor() { throw new RuntimeException("Stub!"); }

public float getToolMajor() { throw new RuntimeException("Stub!"); }

public float getToolMinor() { throw new RuntimeException("Stub!"); }

public float getOrientation() { throw new RuntimeException("Stub!"); }

public float getAxisValue(int axis) { throw new RuntimeException("Stub!"); }

public int getPointerCount() { throw new RuntimeException("Stub!"); }

public int getPointerId(int pointerIndex) { throw new RuntimeException("Stub!"); }

public int getToolType(int pointerIndex) { throw new RuntimeException("Stub!"); }

public int findPointerIndex(int pointerId) { throw new RuntimeException("Stub!"); }

public float getX(int pointerIndex) { throw new RuntimeException("Stub!"); }

public float getY(int pointerIndex) { throw new RuntimeException("Stub!"); }

public float getPressure(int pointerIndex) { throw new RuntimeException("Stub!"); }

public float getSize(int pointerIndex) { throw new RuntimeException("Stub!"); }

public float getTouchMajor(int pointerIndex) { throw new RuntimeException("Stub!"); }

public float getTouchMinor(int pointerIndex) { throw new RuntimeException("Stub!"); }

public float getToolMajor(int pointerIndex) { throw new RuntimeException("Stub!"); }

public float getToolMinor(int pointerIndex) { throw new RuntimeException("Stub!"); }

public float getOrientation(int pointerIndex) { throw new RuntimeException("Stub!"); }

public float getAxisValue(int axis, int pointerIndex) { throw new RuntimeException("Stub!"); }

public void getPointerCoords(int pointerIndex, android.view.MotionEvent.PointerCoords outPointerCoords) { throw new RuntimeException("Stub!"); }

public void getPointerProperties(int pointerIndex, android.view.MotionEvent.PointerProperties outPointerProperties) { throw new RuntimeException("Stub!"); }

public int getMetaState() { throw new RuntimeException("Stub!"); }

public int getButtonState() { throw new RuntimeException("Stub!"); }

public int getClassification() { throw new RuntimeException("Stub!"); }

public int getActionButton() { throw new RuntimeException("Stub!"); }

public float getRawX() { throw new RuntimeException("Stub!"); }

public float getRawY() { throw new RuntimeException("Stub!"); }

public float getRawX(int pointerIndex) { throw new RuntimeException("Stub!"); }

public float getRawY(int pointerIndex) { throw new RuntimeException("Stub!"); }

public float getXPrecision() { throw new RuntimeException("Stub!"); }

public float getYPrecision() { throw new RuntimeException("Stub!"); }

public int getHistorySize() { throw new RuntimeException("Stub!"); }

public long getHistoricalEventTime(int pos) { throw new RuntimeException("Stub!"); }

public long getHistoricalEventTimeNanos(int pos) { throw new RuntimeException("Stub!"); }

public float getHistoricalX(int pos) { throw new RuntimeException("Stub!"); }

public float getHistoricalY(int pos) { throw new RuntimeException("Stub!"); }

public float getHistoricalPressure(int pos) { throw new RuntimeException("Stub!"); }

public float getHistoricalSize(int pos) { throw new RuntimeException("Stub!"); }

public float getHistoricalTouchMajor(int pos) { throw new RuntimeException("Stub!"); }

public float getHistoricalTouchMinor(int pos) { throw new RuntimeException("Stub!"); }

public float getHistoricalToolMajor(int pos) { throw new RuntimeException("Stub!"); }

public float getHistoricalToolMinor(int pos) { throw new RuntimeException("Stub!"); }

public float getHistoricalOrientation(int pos) { throw new RuntimeException("Stub!"); }

public float getHistoricalAxisValue(int axis, int pos) { throw new RuntimeException("Stub!"); }

public float getHistoricalX(int pointerIndex, int pos) { throw new RuntimeException("Stub!"); }

public float getHistoricalY(int pointerIndex, int pos) { throw new RuntimeException("Stub!"); }

public float getHistoricalPressure(int pointerIndex, int pos) { throw new RuntimeException("Stub!"); }

public float getHistoricalSize(int pointerIndex, int pos) { throw new RuntimeException("Stub!"); }

public float getHistoricalTouchMajor(int pointerIndex, int pos) { throw new RuntimeException("Stub!"); }

public float getHistoricalTouchMinor(int pointerIndex, int pos) { throw new RuntimeException("Stub!"); }

public float getHistoricalToolMajor(int pointerIndex, int pos) { throw new RuntimeException("Stub!"); }

public float getHistoricalToolMinor(int pointerIndex, int pos) { throw new RuntimeException("Stub!"); }

public float getHistoricalOrientation(int pointerIndex, int pos) { throw new RuntimeException("Stub!"); }

public float getHistoricalAxisValue(int axis, int pointerIndex, int pos) { throw new RuntimeException("Stub!"); }

public void getHistoricalPointerCoords(int pointerIndex, int pos, android.view.MotionEvent.PointerCoords outPointerCoords) { throw new RuntimeException("Stub!"); }

public int getEdgeFlags() { throw new RuntimeException("Stub!"); }

public void setEdgeFlags(int flags) { throw new RuntimeException("Stub!"); }

public void setAction(int action) { throw new RuntimeException("Stub!"); }

public void offsetLocation(float deltaX, float deltaY) { throw new RuntimeException("Stub!"); }

public void setLocation(float x, float y) { throw new RuntimeException("Stub!"); }

public void transform(android.graphics.Matrix matrix) { throw new RuntimeException("Stub!"); }

public void addBatch(long eventTime, float x, float y, float pressure, float size, int metaState) { throw new RuntimeException("Stub!"); }

public void addBatch(long eventTime, android.view.MotionEvent.PointerCoords[] pointerCoords, int metaState) { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

public static java.lang.String actionToString(int action) { throw new RuntimeException("Stub!"); }

public static java.lang.String axisToString(int axis) { throw new RuntimeException("Stub!"); }

public static int axisFromString(java.lang.String symbolicName) { throw new RuntimeException("Stub!"); }

public boolean isButtonPressed(int button) { throw new RuntimeException("Stub!"); }

public void writeToParcel(android.os.Parcel out, int flags) { throw new RuntimeException("Stub!"); }

public static final int ACTION_BUTTON_PRESS = 11; // 0xb

public static final int ACTION_BUTTON_RELEASE = 12; // 0xc

public static final int ACTION_CANCEL = 3; // 0x3

public static final int ACTION_DOWN = 0; // 0x0

public static final int ACTION_HOVER_ENTER = 9; // 0x9

public static final int ACTION_HOVER_EXIT = 10; // 0xa

public static final int ACTION_HOVER_MOVE = 7; // 0x7

public static final int ACTION_MASK = 255; // 0xff

public static final int ACTION_MOVE = 2; // 0x2

public static final int ACTION_OUTSIDE = 4; // 0x4

@Deprecated public static final int ACTION_POINTER_1_DOWN = 5; // 0x5

@Deprecated public static final int ACTION_POINTER_1_UP = 6; // 0x6

@Deprecated public static final int ACTION_POINTER_2_DOWN = 261; // 0x105

@Deprecated public static final int ACTION_POINTER_2_UP = 262; // 0x106

@Deprecated public static final int ACTION_POINTER_3_DOWN = 517; // 0x205

@Deprecated public static final int ACTION_POINTER_3_UP = 518; // 0x206

public static final int ACTION_POINTER_DOWN = 5; // 0x5

@Deprecated public static final int ACTION_POINTER_ID_MASK = 65280; // 0xff00

@Deprecated public static final int ACTION_POINTER_ID_SHIFT = 8; // 0x8

public static final int ACTION_POINTER_INDEX_MASK = 65280; // 0xff00

public static final int ACTION_POINTER_INDEX_SHIFT = 8; // 0x8

public static final int ACTION_POINTER_UP = 6; // 0x6

public static final int ACTION_SCROLL = 8; // 0x8

public static final int ACTION_UP = 1; // 0x1

public static final int AXIS_BRAKE = 23; // 0x17

public static final int AXIS_DISTANCE = 24; // 0x18

public static final int AXIS_GAS = 22; // 0x16

public static final int AXIS_GENERIC_1 = 32; // 0x20

public static final int AXIS_GENERIC_10 = 41; // 0x29

public static final int AXIS_GENERIC_11 = 42; // 0x2a

public static final int AXIS_GENERIC_12 = 43; // 0x2b

public static final int AXIS_GENERIC_13 = 44; // 0x2c

public static final int AXIS_GENERIC_14 = 45; // 0x2d

public static final int AXIS_GENERIC_15 = 46; // 0x2e

public static final int AXIS_GENERIC_16 = 47; // 0x2f

public static final int AXIS_GENERIC_2 = 33; // 0x21

public static final int AXIS_GENERIC_3 = 34; // 0x22

public static final int AXIS_GENERIC_4 = 35; // 0x23

public static final int AXIS_GENERIC_5 = 36; // 0x24

public static final int AXIS_GENERIC_6 = 37; // 0x25

public static final int AXIS_GENERIC_7 = 38; // 0x26

public static final int AXIS_GENERIC_8 = 39; // 0x27

public static final int AXIS_GENERIC_9 = 40; // 0x28

public static final int AXIS_GESTURE_PINCH_SCALE_FACTOR = 52; // 0x34

public static final int AXIS_GESTURE_SCROLL_X_DISTANCE = 50; // 0x32

public static final int AXIS_GESTURE_SCROLL_Y_DISTANCE = 51; // 0x33

public static final int AXIS_GESTURE_X_OFFSET = 48; // 0x30

public static final int AXIS_GESTURE_Y_OFFSET = 49; // 0x31

public static final int AXIS_HAT_X = 15; // 0xf

public static final int AXIS_HAT_Y = 16; // 0x10

public static final int AXIS_HSCROLL = 10; // 0xa

public static final int AXIS_LTRIGGER = 17; // 0x11

public static final int AXIS_ORIENTATION = 8; // 0x8

public static final int AXIS_PRESSURE = 2; // 0x2

public static final int AXIS_RELATIVE_X = 27; // 0x1b

public static final int AXIS_RELATIVE_Y = 28; // 0x1c

public static final int AXIS_RTRIGGER = 18; // 0x12

public static final int AXIS_RUDDER = 20; // 0x14

public static final int AXIS_RX = 12; // 0xc

public static final int AXIS_RY = 13; // 0xd

public static final int AXIS_RZ = 14; // 0xe

public static final int AXIS_SCROLL = 26; // 0x1a

public static final int AXIS_SIZE = 3; // 0x3

public static final int AXIS_THROTTLE = 19; // 0x13

public static final int AXIS_TILT = 25; // 0x19

public static final int AXIS_TOOL_MAJOR = 6; // 0x6

public static final int AXIS_TOOL_MINOR = 7; // 0x7

public static final int AXIS_TOUCH_MAJOR = 4; // 0x4

public static final int AXIS_TOUCH_MINOR = 5; // 0x5

public static final int AXIS_VSCROLL = 9; // 0x9

public static final int AXIS_WHEEL = 21; // 0x15

public static final int AXIS_X = 0; // 0x0

public static final int AXIS_Y = 1; // 0x1

public static final int AXIS_Z = 11; // 0xb

public static final int BUTTON_BACK = 8; // 0x8

public static final int BUTTON_FORWARD = 16; // 0x10

public static final int BUTTON_PRIMARY = 1; // 0x1

public static final int BUTTON_SECONDARY = 2; // 0x2

public static final int BUTTON_STYLUS_PRIMARY = 32; // 0x20

public static final int BUTTON_STYLUS_SECONDARY = 64; // 0x40

public static final int BUTTON_TERTIARY = 4; // 0x4

public static final int CLASSIFICATION_AMBIGUOUS_GESTURE = 1; // 0x1

public static final int CLASSIFICATION_DEEP_PRESS = 2; // 0x2

public static final int CLASSIFICATION_NONE = 0; // 0x0

public static final int CLASSIFICATION_PINCH = 5; // 0x5

public static final int CLASSIFICATION_TWO_FINGER_SWIPE = 3; // 0x3

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.view.MotionEvent> CREATOR;
static { CREATOR = null; }

public static final int EDGE_BOTTOM = 2; // 0x2

public static final int EDGE_LEFT = 4; // 0x4

public static final int EDGE_RIGHT = 8; // 0x8

public static final int EDGE_TOP = 1; // 0x1

public static final int FLAG_CANCELED = 32; // 0x20

public static final int FLAG_WINDOW_IS_OBSCURED = 1; // 0x1

public static final int FLAG_WINDOW_IS_PARTIALLY_OBSCURED = 2; // 0x2

public static final int INVALID_POINTER_ID = -1; // 0xffffffff

public static final int TOOL_TYPE_ERASER = 4; // 0x4

public static final int TOOL_TYPE_FINGER = 1; // 0x1

public static final int TOOL_TYPE_MOUSE = 3; // 0x3

public static final int TOOL_TYPE_STYLUS = 2; // 0x2

public static final int TOOL_TYPE_UNKNOWN = 0; // 0x0
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class PointerCoords {

public PointerCoords() { throw new RuntimeException("Stub!"); }

public PointerCoords(android.view.MotionEvent.PointerCoords other) { throw new RuntimeException("Stub!"); }

public boolean isResampled() { throw new RuntimeException("Stub!"); }

public void clear() { throw new RuntimeException("Stub!"); }

public void copyFrom(android.view.MotionEvent.PointerCoords other) { throw new RuntimeException("Stub!"); }

public float getAxisValue(int axis) { throw new RuntimeException("Stub!"); }

public void setAxisValue(int axis, float value) { throw new RuntimeException("Stub!"); }

public float orientation;

public float pressure;

public float size;

public float toolMajor;

public float toolMinor;

public float touchMajor;

public float touchMinor;

public float x;

public float y;
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class PointerProperties {

public PointerProperties() { throw new RuntimeException("Stub!"); }

public PointerProperties(android.view.MotionEvent.PointerProperties other) { throw new RuntimeException("Stub!"); }

public void clear() { throw new RuntimeException("Stub!"); }

public void copyFrom(android.view.MotionEvent.PointerProperties other) { throw new RuntimeException("Stub!"); }

public boolean equals(@android.annotation.Nullable java.lang.Object other) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

public int id;

public int toolType;
}

}

