/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.view.inputmethod;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class TextBoundsInfo implements android.os.Parcelable {

TextBoundsInfo() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public void getMatrix(@android.annotation.NonNull android.graphics.Matrix matrix) { throw new RuntimeException("Stub!"); }

public int getStartIndex() { throw new RuntimeException("Stub!"); }

public int getEndIndex() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public void getCharacterBounds(int index, @android.annotation.NonNull android.graphics.RectF bounds) { throw new RuntimeException("Stub!"); }

public int getCharacterFlags(int index) { throw new RuntimeException("Stub!"); }

public int getCharacterBidiLevel(int index) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.text.SegmentFinder getWordSegmentFinder() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.text.SegmentFinder getGraphemeSegmentFinder() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.text.SegmentFinder getLineSegmentFinder() { throw new RuntimeException("Stub!"); }

public int getOffsetForPosition(float x, float y) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public int[] getRangeForRect(@android.annotation.NonNull android.graphics.RectF area, @android.annotation.NonNull android.text.SegmentFinder segmentFinder, @android.annotation.NonNull android.text.Layout.TextInclusionStrategy inclusionStrategy) { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.view.inputmethod.TextBoundsInfo> CREATOR;
static { CREATOR = null; }

public static final int FLAG_CHARACTER_LINEFEED = 2; // 0x2

public static final int FLAG_CHARACTER_PUNCTUATION = 4; // 0x4

public static final int FLAG_CHARACTER_WHITESPACE = 1; // 0x1

public static final int FLAG_LINE_IS_RTL = 8; // 0x8
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder(int start, int end) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.view.inputmethod.TextBoundsInfo.Builder clear() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.view.inputmethod.TextBoundsInfo.Builder setMatrix(@android.annotation.NonNull android.graphics.Matrix matrix) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.view.inputmethod.TextBoundsInfo.Builder setStartAndEnd(int start, int end) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.view.inputmethod.TextBoundsInfo.Builder setCharacterBounds(@android.annotation.NonNull float[] characterBounds) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.view.inputmethod.TextBoundsInfo.Builder setCharacterFlags(@android.annotation.NonNull int[] characterFlags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.view.inputmethod.TextBoundsInfo.Builder setCharacterBidiLevel(@android.annotation.NonNull int[] characterBidiLevels) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.view.inputmethod.TextBoundsInfo.Builder setGraphemeSegmentFinder(@android.annotation.NonNull android.text.SegmentFinder graphemeSegmentFinder) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.view.inputmethod.TextBoundsInfo.Builder setWordSegmentFinder(@android.annotation.NonNull android.text.SegmentFinder wordSegmentFinder) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.view.inputmethod.TextBoundsInfo.Builder setLineSegmentFinder(@android.annotation.NonNull android.text.SegmentFinder lineSegmentFinder) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.view.inputmethod.TextBoundsInfo build() { throw new RuntimeException("Stub!"); }
}

}

