/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * This file is available under and governed by the GNU General Public
 * License version 2 only, as published by the Free Software Foundation.
 * However, the following notice accompanied the original version of this
 * file:
 *
 * Written by Doug Lea with assistance from members of JCP JSR-166
 * Expert Group and released to the public domain, as explained at
 * http://creativecommons.org/publicdomain/zero/1.0/
 *
 * Additional modifications by Guy Steele in 2019 to refactor the code
 * and to implement the {@link RandomGenerator} interface.
 */


package java.util.concurrent;

import java.util.Random;

/**
 * A random number generator (with period 2<sup>64</sup>) isolated
 * to the current thread.  Like the global {@link java.util.Random}
 * generator used by the {@link java.lang.Math} class,
 * a {@code ThreadLocalRandom} is initialized
 * with an internally generated seed that may not otherwise be
 * modified. When applicable, use of {@code ThreadLocalRandom} rather
 * than shared {@code Random} objects in concurrent programs will
 * typically encounter much less overhead and contention.  Use of
 * {@code ThreadLocalRandom} is particularly appropriate when multiple
 * tasks (for example, each a {@link java.util.concurrent.ForkJoinTask ForkJoinTask}) use random numbers
 * in parallel in thread pools.
 *
 * <p>Usages of this class should typically be of the form:
 * {@code ThreadLocalRandom.current().nextX(...)} (where
 * {@code X} is {@code Int}, {@code Long}, etc).
 * When all usages are of this form, it is never possible to
 * accidentally share a {@code ThreadLocalRandom} across multiple threads.
 *
 * <p>This class also provides additional commonly used bounded random
 * generation methods.
 *
 * <p>Instances of {@code ThreadLocalRandom} are not cryptographically
 * secure.  Consider instead using {@link java.security.SecureRandom}
 * in security-sensitive applications. Additionally,
 * default-constructed instances do not use a cryptographically random
 * seed unless the {@linkplain java.lang.System#getProperty system property}
 * {@code java.util.secureRandomSeed} is set to {@code true}.
 *
 * @since 1.7
 * @author Doug Lea
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class ThreadLocalRandom extends java.util.Random {

ThreadLocalRandom() { throw new RuntimeException("Stub!"); }

/**
 * Returns the current thread's {@code ThreadLocalRandom} object.
 * Methods of this object should be called only by the current thread,
 * not by other threads.
 *
 * @return the current thread's {@code ThreadLocalRandom}
 */

public static java.util.concurrent.ThreadLocalRandom current() { throw new RuntimeException("Stub!"); }

/**
 * Throws {@code UnsupportedOperationException}.  Setting seeds in
 * this generator is not supported.
 *
 * @throws java.lang.UnsupportedOperationException always
 */

public void setSeed(long seed) { throw new RuntimeException("Stub!"); }

/**
 * Generates a pseudorandom number with the indicated number of
 * low-order bits.  Because this class has no subclasses, this
 * method cannot be invoked or overridden.
 *
 * @param  bits random bits
 * @return the next pseudorandom value from this random number
 *         generator's sequence
 */

protected int next(int bits) { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}
 */

public boolean nextBoolean() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}
 */

public int nextInt() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}
 * @throws java.lang.IllegalArgumentException {@inheritDoc}
 */

public int nextInt(int bound) { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}
 * @throws java.lang.IllegalArgumentException {@inheritDoc}
 */

public int nextInt(int origin, int bound) { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}
 */

public long nextLong() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}
 * @throws java.lang.IllegalArgumentException {@inheritDoc}
 */

public long nextLong(long bound) { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}
 * @throws java.lang.IllegalArgumentException {@inheritDoc}
 */

public long nextLong(long origin, long bound) { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}
 */

public float nextFloat() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}
 * @throws java.lang.IllegalArgumentException {@inheritDoc}
 * @implNote {@inheritDoc}
 */

public float nextFloat(float bound) { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}
 * @throws java.lang.IllegalArgumentException {@inheritDoc}
 * @implNote {@inheritDoc}
 */

public float nextFloat(float origin, float bound) { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}
 */

public double nextDouble() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}
 * @throws java.lang.IllegalArgumentException {@inheritDoc}
 * @implNote {@inheritDoc}
 */

public double nextDouble(double bound) { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}
 * @throws java.lang.IllegalArgumentException {@inheritDoc}
 * @implNote {@inheritDoc}
 */

public double nextDouble(double origin, double bound) { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}
 * @throws java.lang.IllegalArgumentException {@inheritDoc}
 * @since 1.8
 */

public java.util.stream.IntStream ints(long streamSize) { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}
 * @implNote This method is implemented to be equivalent to
 *           {@code ints(Long.MAX_VALUE)}.
 * @since 1.8
 */

public java.util.stream.IntStream ints() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}
 * @throws java.lang.IllegalArgumentException {@inheritDoc}
 * @since 1.8
 */

public java.util.stream.IntStream ints(long streamSize, int randomNumberOrigin, int randomNumberBound) { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}
 * @implNote This method is implemented to be equivalent to
 *           {@code ints(Long.MAX_VALUE, randomNumberOrigin, randomNumberBound)}.
 * @throws java.lang.IllegalArgumentException {@inheritDoc}
 * @since 1.8
 */

public java.util.stream.IntStream ints(int randomNumberOrigin, int randomNumberBound) { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}
 * @throws java.lang.IllegalArgumentException {@inheritDoc}
 * @since 1.8
 */

public java.util.stream.LongStream longs(long streamSize) { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}
 * @implNote This method is implemented to be equivalent to
 *           {@code longs(Long.MAX_VALUE)}.
 * @since 1.8
 */

public java.util.stream.LongStream longs() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}
 * @throws java.lang.IllegalArgumentException {@inheritDoc}
 * @since 1.8
 */

public java.util.stream.LongStream longs(long streamSize, long randomNumberOrigin, long randomNumberBound) { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}
 * @implNote This method is implemented to be equivalent to
 *           {@code longs(Long.MAX_VALUE, randomNumberOrigin, randomNumberBound)}.
 * @throws java.lang.IllegalArgumentException {@inheritDoc}
 * @since 1.8
 */

public java.util.stream.LongStream longs(long randomNumberOrigin, long randomNumberBound) { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}
 * @throws java.lang.IllegalArgumentException {@inheritDoc}
 * @since 1.8
 */

public java.util.stream.DoubleStream doubles(long streamSize) { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}
 * @implNote This method is implemented to be equivalent to
 *           {@code doubles(Long.MAX_VALUE)}.
 * @since 1.8
 */

public java.util.stream.DoubleStream doubles() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}
 * @throws java.lang.IllegalArgumentException {@inheritDoc}
 * @since 1.8
 */

public java.util.stream.DoubleStream doubles(long streamSize, double randomNumberOrigin, double randomNumberBound) { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}
 * @implNote This method is implemented to be equivalent to
 *           {@code doubles(Long.MAX_VALUE, randomNumberOrigin, randomNumberBound)}.
 * @throws java.lang.IllegalArgumentException {@inheritDoc}
 * @since 1.8
 */

public java.util.stream.DoubleStream doubles(double randomNumberOrigin, double randomNumberBound) { throw new RuntimeException("Stub!"); }
}

