/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmuilib;

import com.android.ddmlib.Client;
import com.android.ddmlib.IStackTraceInfo;
import com.android.ddmuilib.TableHelper;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;

public final class StackTracePanel {
    private static ISourceRevealer sSourceRevealer;
    private Table mStackTraceTable;
    private TableViewer mStackTraceViewer;
    private Client mCurrentClient;

    public static void setSourceRevealer(ISourceRevealer revealer) {
        sSourceRevealer = revealer;
    }

    public Table createPanel(Composite parent, String prefs_stack_column, IPreferenceStore store) {
        this.mStackTraceTable = new Table(parent, 65538);
        this.mStackTraceTable.setHeaderVisible(false);
        this.mStackTraceTable.setLinesVisible(false);
        TableHelper.createTableColumn(this.mStackTraceTable, "Info", 16384, "SomeLongClassName.method(android/somepackage/someotherpackage/somefile.java:99999)", prefs_stack_column, store);
        this.mStackTraceViewer = new TableViewer(this.mStackTraceTable);
        this.mStackTraceViewer.setContentProvider((IContentProvider)new StackTraceContentProvider());
        this.mStackTraceViewer.setLabelProvider((IBaseLabelProvider)new StackTraceLabelProvider());
        this.mStackTraceViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                StackTraceElement traceElement;
                IStructuredSelection structuredSelection;
                Object object;
                ISelection selection;
                if (sSourceRevealer != null && StackTracePanel.this.mCurrentClient != null && (selection = StackTracePanel.this.mStackTraceViewer.getSelection()) instanceof IStructuredSelection && (object = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) instanceof StackTraceElement && !(traceElement = (StackTraceElement)object).isNativeMethod()) {
                    sSourceRevealer.reveal(StackTracePanel.this.mCurrentClient.getClientData().getClientDescription(), traceElement.getClassName(), traceElement.getLineNumber());
                }
            }
        });
        return this.mStackTraceTable;
    }

    public void setViewerInput(IStackTraceInfo input) {
        this.mStackTraceViewer.setInput((Object)input);
        this.mStackTraceViewer.refresh();
    }

    public void setCurrentClient(Client currentClient) {
        this.mCurrentClient = currentClient;
    }

    public static interface ISourceRevealer {
        public void reveal(String var1, String var2, int var3);
    }

    private static class StackTraceLabelProvider
    implements ITableLabelProvider {
        private StackTraceLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof StackTraceElement && columnIndex == 0) {
                StackTraceElement traceElement = (StackTraceElement)element;
                return "  at " + traceElement.toString();
            }
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private static class StackTraceContentProvider
    implements IStructuredContentProvider {
        private StackTraceContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            Object[] trace;
            if (inputElement instanceof IStackTraceInfo && (trace = ((IStackTraceInfo)inputElement).getStackTrace()) != null) {
                return trace;
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

